/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.parser;

import java.nio.CharBuffer;
import java.util.Set;
import jpt.sun.tools.javac.code.Lint;
import jpt.sun.tools.javac.code.Preview;
import jpt.sun.tools.javac.code.Source;
import jpt.sun.tools.javac.file.JavacFileManager;
import jpt.sun.tools.javac.parser.ScannerFactory;
import jpt.sun.tools.javac.parser.TextBlockSupport;
import jpt.sun.tools.javac.parser.Tokens;
import jpt.sun.tools.javac.parser.UnicodeReader;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Names;
import jpt.sun.tools.javac.util.Position;
import nbjavac.StringWrapper;

public class JavaTokenizer
extends UnicodeReader {
    private static final boolean scannerDebug = false;
    private int NOT_FOUND = -1;
    private Source source;
    private Preview preview;
    private final Log log;
    private final Tokens tokens;
    private final Names names;
    protected Tokens.TokenKind tk;
    protected int radix;
    protected Name name;
    protected int errPos = -1;
    protected boolean isTextBlock;
    protected boolean hasEscapeSequences;
    protected StringBuilder sb;
    protected ScannerFactory fac;
    protected Lint lint;

    protected JavaTokenizer(ScannerFactory fac, CharBuffer cb) {
        this(fac, JavacFileManager.toArray(cb), cb.limit());
    }

    protected JavaTokenizer(ScannerFactory fac, char[] array, int length) {
        super(fac, array, length);
        this.fac = fac;
        this.log = fac.log;
        this.names = fac.names;
        this.tokens = fac.tokens;
        this.source = fac.source;
        this.preview = fac.preview;
        this.lint = fac.lint;
        this.sb = new StringBuilder(256);
    }

    protected void checkSourceLevel(int pos, Source.Feature feature) {
        if (this.preview.isPreview(feature) && !this.preview.isEnabled()) {
            this.lexError(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, pos, this.preview.disabledError(feature));
        } else if (!feature.allowedInSource(this.source)) {
            this.lexError(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, pos, feature.error(this.source.name));
        } else if (this.preview.isPreview(feature)) {
            this.preview.warnPreview(pos, feature);
        }
    }

    protected void lexError(int pos, JCDiagnostic.Error key) {
        this.log.error(pos, key);
        this.tk = Tokens.TokenKind.ERROR;
        this.errPos = pos;
    }

    protected void lexError(JCDiagnostic.DiagnosticFlag flags, int pos, JCDiagnostic.Error key) {
        this.log.error(flags, pos, key);
        if (flags != JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL) {
            this.tk = Tokens.TokenKind.ERROR;
        }
        this.errPos = pos;
    }

    protected void lexWarning(Lint.LintCategory lc, int pos, JCDiagnostic.Warning key) {
        JCDiagnostic.SimpleDiagnosticPosition dp = new JCDiagnostic.SimpleDiagnosticPosition(pos);
        this.log.warning(lc, dp, key);
    }

    protected void put(char ch) {
        this.sb.append(ch);
    }

    protected void putCodePoint(int codePoint) {
        this.sb.appendCodePoint(codePoint);
    }

    protected void put() {
        if (this.isSurrogate()) {
            this.putCodePoint(this.getCodepoint());
        } else {
            this.put(this.get());
        }
    }

    protected void put(String string) {
        this.sb.append(string);
    }

    protected char putThenNext() {
        this.put();
        return this.next();
    }

    protected boolean acceptThenPut(char ch) {
        if (this.is(ch)) {
            this.put(this.get());
            this.next();
            return true;
        }
        return false;
    }

    protected boolean acceptOneOfThenPut(char ch1, char ch2) {
        if (this.isOneOf(ch1, ch2)) {
            this.put(this.get());
            this.next();
            return true;
        }
        return false;
    }

    private boolean isEOLN() {
        return this.isOneOf('\n', '\r');
    }

    private void skipLineTerminator() {
        int start = this.position();
        this.accept('\r');
        this.accept('\n');
        this.processLineTerminator(start, this.position());
    }

    private void scanLitChar(int pos) {
        block10: {
            block9: {
                if (!this.acceptThenPut('\\')) break block9;
                this.hasEscapeSequences = true;
                switch (this.get()) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.get();
                        this.putThenNext();
                        if (this.inRange('0', '7')) {
                            this.putThenNext();
                            if (leadch <= '3' && this.inRange('0', '7')) {
                                this.putThenNext();
                                break;
                            }
                        }
                        break block10;
                    }
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        this.putThenNext();
                        break;
                    }
                    case 's': {
                        this.checkSourceLevel(this.position(), Source.Feature.TEXT_BLOCKS);
                        this.putThenNext();
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if (this.isTextBlock) {
                            this.skipLineTerminator();
                            this.put('\n');
                            break;
                        }
                        this.lexError(this.position(), CompilerProperties.Errors.IllegalEscChar);
                        break;
                    }
                    default: {
                        this.lexError(this.position(), CompilerProperties.Errors.IllegalEscChar);
                        break;
                    }
                }
                break block10;
            }
            this.putThenNext();
        }
    }

    private void scanString(int pos) {
        this.tk = Tokens.TokenKind.STRINGLITERAL;
        int firstEOLN = this.NOT_FOUND;
        this.isTextBlock = this.accept("\"\"\"");
        if (this.isTextBlock) {
            this.checkSourceLevel(pos, Source.Feature.TEXT_BLOCKS);
            this.skipWhitespace();
            if (this.isEOLN()) {
                this.skipLineTerminator();
            } else {
                this.lexError(this.position(), CompilerProperties.Errors.IllegalTextBlockOpen);
                return;
            }
            while (this.isAvailable()) {
                if (this.accept("\"\"\"")) {
                    return;
                }
                if (this.isEOLN()) {
                    this.skipLineTerminator();
                    this.put('\n');
                    if (firstEOLN != this.NOT_FOUND) continue;
                    firstEOLN = this.position();
                    continue;
                }
                this.scanLitChar(pos);
            }
        } else {
            this.next();
            while (this.isAvailable()) {
                if (this.accept('\"')) {
                    return;
                }
                if (!this.isEOLN()) {
                    this.scanLitChar(pos);
                    continue;
                }
                break;
            }
        }
        this.lexError(pos, this.isTextBlock ? CompilerProperties.Errors.UnclosedTextBlock : CompilerProperties.Errors.UnclosedStrLit);
        if (firstEOLN != this.NOT_FOUND) {
            this.reset(firstEOLN);
        }
    }

    private void scanDigits(int pos, int digitRadix) {
        int trailingUnderscorePos;
        int leadingUnderscorePos;
        int n = leadingUnderscorePos = this.is('_') ? this.position() : this.NOT_FOUND;
        do {
            if (!this.is('_')) {
                this.put();
                trailingUnderscorePos = this.NOT_FOUND;
            } else {
                trailingUnderscorePos = this.position();
            }
            this.next();
        } while (this.digit(pos, digitRadix) >= 0 || this.is('_'));
        if (leadingUnderscorePos != this.NOT_FOUND) {
            this.lexError(leadingUnderscorePos, CompilerProperties.Errors.IllegalUnderscore);
        } else if (trailingUnderscorePos != this.NOT_FOUND) {
            this.lexError(trailingUnderscorePos, CompilerProperties.Errors.IllegalUnderscore);
        }
    }

    private void scanHexExponentAndSuffix(int pos) {
        if (this.acceptOneOfThenPut('p', 'P')) {
            this.skipIllegalUnderscores();
            this.acceptOneOfThenPut('+', '-');
            this.skipIllegalUnderscores();
            if (this.digit(pos, 10) >= 0) {
                this.scanDigits(pos, 10);
            } else {
                this.lexError(pos, CompilerProperties.Errors.MalformedFpLit);
            }
        } else {
            this.lexError(pos, CompilerProperties.Errors.MalformedFpLit);
        }
        if (this.acceptOneOfThenPut('f', 'F')) {
            this.tk = Tokens.TokenKind.FLOATLITERAL;
            this.radix = 16;
        } else {
            this.acceptOneOfThenPut('d', 'D');
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
            this.radix = 16;
        }
    }

    private void scanFraction(int pos) {
        this.skipIllegalUnderscores();
        if (this.digit(pos, 10) >= 0) {
            this.scanDigits(pos, 10);
        }
        int index = this.sb.length();
        if (this.acceptOneOfThenPut('e', 'E')) {
            this.skipIllegalUnderscores();
            this.acceptOneOfThenPut('+', '-');
            this.skipIllegalUnderscores();
            if (this.digit(pos, 10) >= 0) {
                this.scanDigits(pos, 10);
                return;
            }
            this.lexError(pos, CompilerProperties.Errors.MalformedFpLit);
            this.sb.setLength(index);
        }
    }

    private void scanFractionAndSuffix(int pos) {
        this.radix = 10;
        this.scanFraction(pos);
        if (this.acceptOneOfThenPut('f', 'F')) {
            this.tk = Tokens.TokenKind.FLOATLITERAL;
        } else {
            this.acceptOneOfThenPut('d', 'D');
            this.tk = Tokens.TokenKind.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(int pos, boolean seendigit) {
        this.radix = 16;
        Assert.check(this.is('.'));
        this.putThenNext();
        this.skipIllegalUnderscores();
        if (this.digit(pos, 16) >= 0) {
            seendigit = true;
            this.scanDigits(pos, 16);
        }
        if (!seendigit) {
            this.lexError(pos, CompilerProperties.Errors.InvalidHexNumber);
        } else {
            this.scanHexExponentAndSuffix(pos);
        }
    }

    private void skipIllegalUnderscores() {
        if (this.is('_')) {
            this.lexError(this.position(), CompilerProperties.Errors.IllegalUnderscore);
            this.skip('_');
        }
    }

    private void scanNumber(int pos, int radix) {
        boolean seenValidDigit;
        this.radix = radix;
        int digitRadix = radix == 8 ? 10 : radix;
        int firstDigit = this.digit(pos, Math.max(10, digitRadix));
        boolean seendigit = firstDigit >= 0;
        boolean bl = seenValidDigit = firstDigit >= 0 && firstDigit < digitRadix;
        if (seendigit) {
            this.scanDigits(pos, digitRadix);
        }
        if (radix == 16 && this.is('.')) {
            this.scanHexFractionAndSuffix(pos, seendigit);
        } else if (seendigit && radix == 16 && this.isOneOf('p', 'P')) {
            this.scanHexExponentAndSuffix(pos);
        } else if (digitRadix == 10 && this.is('.')) {
            this.putThenNext();
            this.scanFractionAndSuffix(pos);
        } else if (digitRadix == 10 && this.isOneOf('e', 'E', 'f', 'F', 'd', 'D')) {
            this.scanFractionAndSuffix(pos);
        } else {
            if (!seenValidDigit) {
                switch (radix) {
                    case 2: {
                        this.lexError(pos, CompilerProperties.Errors.InvalidBinaryNumber);
                        break;
                    }
                    case 16: {
                        this.lexError(pos, CompilerProperties.Errors.InvalidHexNumber);
                    }
                }
            }
            if (radix == 8) {
                this.sb.setLength(0);
                this.reset(pos);
                this.scanDigits(pos, 8);
            }
            this.tk = this.acceptOneOf('l', 'L') ? Tokens.TokenKind.LONGLITERAL : Tokens.TokenKind.INTLITERAL;
        }
    }

    private void checkIdent() {
        this.name = this.names.fromString(this.sb.toString());
        this.tk = this.tokens.lookupKind(this.name);
    }

    private void scanIdent() {
        this.putThenNext();
        block5: while (true) {
            switch (this.get()) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    break;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '\u007f': {
                    this.next();
                    continue block5;
                }
                case '\u001a': {
                    if (this.isAvailable()) {
                        this.next();
                        continue block5;
                    }
                    this.checkIdent();
                    return;
                }
                default: {
                    boolean isJavaIdentifierPart;
                    if (this.isASCII()) {
                        isJavaIdentifierPart = false;
                    } else {
                        if (Character.isIdentifierIgnorable(this.get())) {
                            this.next();
                            continue block5;
                        }
                        boolean bl = isJavaIdentifierPart = this.isSurrogate() ? Character.isJavaIdentifierPart(this.getCodepoint()) : Character.isJavaIdentifierPart(this.get());
                    }
                    if (isJavaIdentifierPart) break;
                    this.checkIdent();
                    return;
                }
            }
            this.putThenNext();
        }
    }

    private boolean isSpecial(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.put();
            Tokens.TokenKind newtk = this.tokens.lookupKind(this.sb.toString());
            if (newtk == Tokens.TokenKind.IDENTIFIER) {
                this.sb.setLength(this.sb.length() - 1);
                break;
            }
            this.tk = newtk;
            this.next();
        } while (this.isSpecial(this.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tokens.Token readToken() {
        this.sb.setLength(0);
        this.name = null;
        this.radix = 0;
        this.isTextBlock = false;
        this.hasEscapeSequences = false;
        List<Tokens.Comment> comments = null;
        try {
            Object arg;
            int pos;
            block30: while (true) {
                pos = this.position();
                switch (this.get()) {
                    case '\t': 
                    case '\f': 
                    case ' ': {
                        this.skipWhitespace();
                        this.processWhiteSpace(pos, this.position());
                        continue block30;
                    }
                    case '\n': {
                        this.next();
                        this.processLineTerminator(pos, this.position());
                        continue block30;
                    }
                    case '\r': {
                        this.next();
                        this.accept('\n');
                        this.processLineTerminator(pos, this.position());
                        continue block30;
                    }
                    case '$': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'G': 
                    case 'H': 
                    case 'I': 
                    case 'J': 
                    case 'K': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'O': 
                    case 'P': 
                    case 'Q': 
                    case 'R': 
                    case 'S': 
                    case 'T': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'X': 
                    case 'Y': 
                    case 'Z': 
                    case '_': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'g': 
                    case 'h': 
                    case 'i': 
                    case 'j': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'n': 
                    case 'o': 
                    case 'p': 
                    case 'q': 
                    case 'r': 
                    case 's': 
                    case 't': 
                    case 'u': 
                    case 'v': 
                    case 'w': 
                    case 'x': 
                    case 'y': 
                    case 'z': {
                        this.scanIdent();
                        break block30;
                    }
                    case '0': {
                        int savePos;
                        this.next();
                        if (this.acceptOneOf('x', 'X')) {
                            this.skipIllegalUnderscores();
                            this.scanNumber(pos, 16);
                            break block30;
                        }
                        if (this.acceptOneOf('b', 'B')) {
                            this.skipIllegalUnderscores();
                            this.scanNumber(pos, 2);
                            break block30;
                        }
                        this.put('0');
                        if (this.is('_')) {
                            savePos = this.position();
                            this.skip('_');
                            if (this.digit(pos, 10) < 0) {
                                this.lexError(savePos, CompilerProperties.Errors.IllegalUnderscore);
                            }
                        }
                        this.scanNumber(pos, 8);
                        break block30;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.scanNumber(pos, 10);
                        break block30;
                    }
                    case '.': {
                        if (this.accept("...")) {
                            this.put("...");
                            this.tk = Tokens.TokenKind.ELLIPSIS;
                            break block30;
                        }
                        this.next();
                        int savePos = this.position();
                        if (this.accept('.')) {
                            this.lexError(savePos, CompilerProperties.Errors.IllegalDot);
                            break block30;
                        }
                        if (this.digit(pos, 10) >= 0) {
                            this.put('.');
                            this.scanFractionAndSuffix(pos);
                            break block30;
                        }
                        this.tk = Tokens.TokenKind.DOT;
                        break block30;
                    }
                    case ',': {
                        this.next();
                        this.tk = Tokens.TokenKind.COMMA;
                        break block30;
                    }
                    case ';': {
                        this.next();
                        this.tk = Tokens.TokenKind.SEMI;
                        break block30;
                    }
                    case '(': {
                        this.next();
                        this.tk = Tokens.TokenKind.LPAREN;
                        break block30;
                    }
                    case ')': {
                        this.next();
                        this.tk = Tokens.TokenKind.RPAREN;
                        break block30;
                    }
                    case '[': {
                        this.next();
                        this.tk = Tokens.TokenKind.LBRACKET;
                        break block30;
                    }
                    case ']': {
                        this.next();
                        this.tk = Tokens.TokenKind.RBRACKET;
                        break block30;
                    }
                    case '{': {
                        this.next();
                        this.tk = Tokens.TokenKind.LBRACE;
                        break block30;
                    }
                    case '}': {
                        this.next();
                        this.tk = Tokens.TokenKind.RBRACE;
                        break block30;
                    }
                    case '/': {
                        this.next();
                        if (this.accept('/')) {
                            this.skipToEOLN();
                            if (!this.isAvailable()) continue block30;
                            comments = this.appendComment(comments, this.processComment(pos, this.position(), Tokens.Comment.CommentStyle.LINE));
                            continue block30;
                        }
                        if (this.accept('*')) {
                            Tokens.Comment.CommentStyle style;
                            boolean isEmpty = false;
                            if (this.accept('*')) {
                                style = Tokens.Comment.CommentStyle.JAVADOC;
                                if (this.is('/')) {
                                    isEmpty = true;
                                }
                            } else {
                                style = Tokens.Comment.CommentStyle.BLOCK;
                            }
                            if (!isEmpty) {
                                while (this.isAvailable()) {
                                    if (this.accept('*')) {
                                        if (!this.is('/')) continue;
                                        break;
                                    }
                                    this.next();
                                }
                            }
                            if (this.accept('/')) {
                                comments = this.appendComment(comments, this.processComment(pos, this.position(), style));
                                continue block30;
                            }
                            this.lexError(pos, CompilerProperties.Errors.UnclosedComment);
                            break block30;
                        }
                        if (this.accept('=')) {
                            this.tk = Tokens.TokenKind.SLASHEQ;
                            break block30;
                        }
                        this.tk = Tokens.TokenKind.SLASH;
                        break block30;
                    }
                    case '\'': {
                        this.next();
                        if (this.accept('\'')) {
                            this.lexError(pos, CompilerProperties.Errors.EmptyCharLit);
                            break block30;
                        }
                        if (this.isEOLN()) {
                            this.lexError(pos, CompilerProperties.Errors.IllegalLineEndInCharLit);
                        }
                        this.scanLitChar(pos);
                        if (this.accept('\'')) {
                            this.tk = Tokens.TokenKind.CHARLITERAL;
                            break block30;
                        }
                        this.lexError(pos, CompilerProperties.Errors.UnclosedCharLit);
                        break block30;
                    }
                    case '\"': {
                        this.scanString(pos);
                        break block30;
                    }
                    default: {
                        boolean isJavaIdentifierStart;
                        if (this.isSpecial(this.get())) {
                            this.scanOperator();
                            break block30;
                        }
                        if (this.isASCII()) {
                            isJavaIdentifierStart = false;
                        } else {
                            boolean bl = isJavaIdentifierStart = this.isSurrogate() ? Character.isJavaIdentifierStart(this.getCodepoint()) : Character.isJavaIdentifierStart(this.get());
                        }
                        if (isJavaIdentifierStart) {
                            this.scanIdent();
                            break block30;
                        }
                        if (this.digit(pos, 10) >= 0) {
                            this.scanNumber(pos, 10);
                            break block30;
                        }
                        if (this.is('\u001a') || !this.isAvailable()) {
                            this.tk = Tokens.TokenKind.EOF;
                            pos = this.position();
                            break block30;
                        }
                        if (this.isSurrogate()) {
                            int n = this.getCodepoint();
                            char hi = Character.highSurrogate(n);
                            char lo = Character.lowSurrogate(n);
                            arg = String.format("\\u%04x\\u%04x", hi, (int)lo);
                        } else {
                            char c = this.get();
                            arg = ' ' < c && c < '\u007f' ? String.format("%s", Character.valueOf(c)) : String.format("\\u%04x", c);
                        }
                        this.lexError(pos, CompilerProperties.Errors.IllegalChar((String)arg));
                        this.next();
                        break block30;
                    }
                }
                break;
            }
            int endPos = this.position();
            if (this.tk.tag == Tokens.Token.Tag.DEFAULT) {
                arg = new Tokens.Token(this.tk, pos, endPos, comments);
                return arg;
            }
            if (this.tk.tag == Tokens.Token.Tag.NAMED) {
                arg = new Tokens.NamedToken(this.tk, pos, endPos, this.name, comments);
                return arg;
            }
            String string = this.sb.toString();
            if (this.isTextBlock) {
                if (this.lint.isEnabled(Lint.LintCategory.TEXT_BLOCKS)) {
                    Set<TextBlockSupport.WhitespaceChecks> numericToken = TextBlockSupport.checkWhitespace(string);
                    if (numericToken.contains((Object)TextBlockSupport.WhitespaceChecks.INCONSISTENT)) {
                        this.lexWarning(Lint.LintCategory.TEXT_BLOCKS, pos, CompilerProperties.Warnings.InconsistentWhiteSpaceIndentation);
                    }
                    if (numericToken.contains((Object)TextBlockSupport.WhitespaceChecks.TRAILING)) {
                        this.lexWarning(Lint.LintCategory.TEXT_BLOCKS, pos, CompilerProperties.Warnings.TrailingWhiteSpaceWillBeRemoved);
                    }
                }
                try {
                    string = StringWrapper.stripIndent(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.hasEscapeSequences) {
                try {
                    string = StringWrapper.translateEscapes(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.tk.tag == Tokens.Token.Tag.STRING) {
                Tokens.StringToken stringToken = new Tokens.StringToken(this.tk, pos, endPos, string, comments);
                return stringToken;
            }
            Tokens.NumericToken numericToken = new Tokens.NumericToken(this.tk, pos, endPos, string, this.radix, comments);
            return numericToken;
        }
        finally {
            int exception = this.position();
        }
    }

    List<Tokens.Comment> appendComment(List<Tokens.Comment> comments, Tokens.Comment comment) {
        return comments == null ? List.of(comment) : comments.prepend(comment);
    }

    public int errPos() {
        return this.errPos;
    }

    public void errPos(int pos) {
        this.errPos = pos;
    }

    protected Tokens.Comment processComment(int pos, int endPos, Tokens.Comment.CommentStyle style) {
        char[] buf = this.getRawCharacters(pos, endPos);
        return new BasicComment(style, this.fac, buf, pos);
    }

    protected void processWhiteSpace(int pos, int endPos) {
    }

    protected void processLineTerminator(int pos, int endPos) {
    }

    public Position.LineMap getLineMap() {
        return Position.makeLineMap(this.getRawCharacters(), this.length(), false);
    }

    protected static class BasicComment
    extends UnicodeReader.PositionTrackingReader
    implements Tokens.Comment {
        Tokens.Comment.CommentStyle cs;
        protected boolean deprecatedFlag = false;
        protected boolean scanned = false;

        protected BasicComment(Tokens.Comment.CommentStyle cs, ScannerFactory sf, char[] array, int offset) {
            super(sf, array, offset);
            this.cs = cs;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        public int getSourcePos(int pos) {
            return -1;
        }

        @Override
        public Tokens.Comment.CommentStyle getStyle() {
            return this.cs;
        }

        @Override
        public boolean isDeprecated() {
            if (!this.scanned && this.cs == Tokens.Comment.CommentStyle.JAVADOC) {
                this.scanDocComment();
            }
            return this.deprecatedFlag;
        }

        protected void scanDocComment() {
            try {
                boolean deprecatedPrefix = false;
                this.accept("/**");
                block10: while (this.isAvailable()) {
                    this.skipWhitespace();
                    while (this.accept('*')) {
                        if (!this.is('/')) continue;
                        return;
                    }
                    this.skipWhitespace();
                    boolean bl = deprecatedPrefix = this.deprecatedFlag || this.accept("@deprecated");
                    if (deprecatedPrefix && this.isAvailable()) {
                        if (Character.isWhitespace(this.get())) {
                            this.deprecatedFlag = true;
                        } else if (this.accept('*') && this.is('/')) {
                            this.deprecatedFlag = true;
                            return;
                        }
                    }
                    block12: while (this.isAvailable()) {
                        switch (this.get()) {
                            case '*': {
                                this.next();
                                if (!this.is('/')) continue block12;
                                return;
                            }
                            case '\n': 
                            case '\r': {
                                this.accept('\r');
                                this.accept('\n');
                                continue block10;
                            }
                        }
                        this.next();
                    }
                }
                return;
            }
            finally {
                this.scanned = true;
            }
        }
    }
}

