/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.awt.Color;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.ProjectProblems;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;

public final class LogicalViewProviders {
    private LogicalViewProviders() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    public static LogicalViewProviderBuilder createBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull String extensionFolder) {
        return new LogicalViewProviderBuilder(project, eval, extensionFolder);
    }

    private static final class SimpleInfo
    implements ProjectInformation {
        private final Project project;

        SimpleInfo(@NonNull Project project) {
            Parameters.notNull("project", project);
            this.project = project;
        }

        @Override
        public String getName() {
            return this.project.getProjectDirectory().getName();
        }

        @Override
        public String getDisplayName() {
            return this.getName();
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public Project getProject() {
            return this.project;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private static class LogicalViewProviderImpl
    implements LogicalViewProvider2 {
        private static final RequestProcessor RP = new RequestProcessor(LogicalViewProviders.class);
        private static final String COMPILE_ON_SAVE_DISABLED_BADGE_PATH = "org/netbeans/modules/java/api/common/project/ui/resources/compileOnSaveDisabledBadge.gif";
        private static final Image compileOnSaveDisabledBadge;
        private final Project project;
        private final PropertyEvaluator evaluator;
        private final String projectType;
        private final HelpCtx helpContext;
        private final CompileOnSaveBadge badgeStatus;
        private final ChangeSupport changeSupport = new ChangeSupport(this);
        private final PropertyChangeListener pcl;
        private final RequestProcessor.Task task = RP.create(new Runnable(){

            @Override
            public void run() {
                this.setBroken(ProjectProblems.isBroken(project));
                this.setCompileOnSaveDisabled(this.isCompileOnSaveDisabled());
            }
        });
        private volatile boolean listenersInited;
        private volatile boolean broken;
        private volatile boolean compileOnSaveDisabled;

        public LogicalViewProviderImpl(@NonNull Project project, @NonNull PropertyEvaluator evaluator, @NonNull String projectType, @NullAllowed HelpCtx helpContext, final @NullAllowed CompileOnSaveBadge badgeStatus) {
            Parameters.notNull("project", project);
            Parameters.notNull("evaluator", evaluator);
            Parameters.notNull("projectType", projectType);
            this.project = project;
            this.evaluator = evaluator;
            this.projectType = projectType;
            this.helpContext = helpContext;
            this.badgeStatus = badgeStatus;
            this.pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("problems".equals(evt.getPropertyName()) || badgeStatus != null && (propName == null || badgeStatus.isImportant(propName))) {
                        this.testBroken();
                    }
                }
            };
        }

        private void initListeners() {
            if (this.listenersInited) {
                return;
            }
            ProjectManager.mutex().readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<LogicalViewProviderImpl> clazz = LogicalViewProviderImpl.class;
                    synchronized (LogicalViewProviderImpl.class) {
                        if (!listenersInited) {
                            evaluator.addPropertyChangeListener(pcl);
                            ProjectProblemsProvider ppp = project.getLookup().lookup(ProjectProblemsProvider.class);
                            if (ppp != null) {
                                ppp.addPropertyChangeListener(pcl);
                            }
                            listenersInited = true;
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
        }

        @Override
        public Node createLogicalView() {
            this.initListeners();
            InstanceContent ic = new InstanceContent();
            ic.add(this.project);
            ic.add(this.project, new InstanceContent.Convertor<Project, FileObject>(){

                @Override
                public FileObject convert(Project obj) {
                    return obj.getProjectDirectory();
                }

                @Override
                public Class<? extends FileObject> type(Project obj) {
                    return FileObject.class;
                }

                @Override
                public String id(Project obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                @Override
                public String displayName(Project obj) {
                    return obj.toString();
                }
            });
            ic.add(this.project, new InstanceContent.Convertor<Project, DataObject>(){

                @Override
                public DataObject convert(Project obj) {
                    try {
                        FileObject fo = obj.getProjectDirectory();
                        return fo == null ? null : DataObject.find(fo);
                    }
                    catch (DataObjectNotFoundException ex) {
                        return null;
                    }
                }

                @Override
                public Class<? extends DataObject> type(Project obj) {
                    return DataObject.class;
                }

                @Override
                public String id(Project obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                @Override
                public String displayName(Project obj) {
                    return obj.toString();
                }
            });
            return new LogicalViewRootNode((Lookup)new AbstractLookup(ic));
        }

        @Override
        public Node findPath(Node root, Object target) {
            Project prj = root.getLookup().lookup(Project.class);
            if (prj == null) {
                return null;
            }
            if (target instanceof FileObject) {
                FileObject fo = (FileObject)target;
                if (LogicalViewProviderImpl.isOtherProjectSource(fo, prj)) {
                    return null;
                }
                for (Node n : root.getChildren().getNodes(true)) {
                    Node result = PackageView.findPath(n, target);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }

        private static boolean isOtherProjectSource(@NonNull FileObject fo, @NonNull Project me) {
            Project owner = FileOwnerQuery.getOwner(fo);
            if (owner == null) {
                return false;
            }
            if (me.equals(owner)) {
                return false;
            }
            for (SourceGroup sg : ProjectUtils.getSources(owner).getSourceGroups("java")) {
                if (!FileUtil.isParentOf(sg.getRootFolder(), fo)) continue;
                return true;
            }
            return false;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public void testBroken() {
            this.task.schedule(500);
        }

        private boolean isCompileOnSaveDisabled() {
            return this.badgeStatus != null && this.badgeStatus.isBadgeVisible();
        }

        private void setBroken(boolean broken) {
            if (this.broken != broken) {
                this.broken = broken;
                this.changeSupport.fireChange();
            }
        }

        private void setCompileOnSaveDisabled(boolean value) {
            if (this.compileOnSaveDisabled != value) {
                this.compileOnSaveDisabled = value;
                this.changeSupport.fireChange();
            }
        }

        @NonNull
        private static Color getErrorForeground() {
            Color result = UIManager.getDefaults().getColor("nb.errorForeground");
            if (result == null) {
                result = Color.RED;
            }
            return result;
        }

        static {
            URL errorBadgeIconURL = LogicalViewProviders.class.getClassLoader().getResource(COMPILE_ON_SAVE_DISABLED_BADGE_PATH);
            String compileOnSaveDisabledTP = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(LogicalViewProviders.class, "TP_CompileOnSaveDisabled");
            compileOnSaveDisabledBadge = ImageUtilities.assignToolTipToImage(ImageUtilities.loadImage(COMPILE_ON_SAVE_DISABLED_BADGE_PATH), compileOnSaveDisabledTP);
        }

        private final class LogicalViewRootNode
        extends AbstractNode
        implements ChangeListener,
        PropertyChangeListener {
            private final ProjectInformation info;

            LogicalViewRootNode(Lookup lkp) {
                super(NodeFactorySupport.createCompositeChildren(LogicalViewProviderImpl.this.project, String.format("Projects/%s/Nodes", LogicalViewProviderImpl.this.projectType)), lkp);
                LogicalViewProviderImpl.this.broken = ProjectProblems.isBroken(LogicalViewProviderImpl.this.project);
                LogicalViewProviderImpl.this.compileOnSaveDisabled = LogicalViewProviderImpl.this.isCompileOnSaveDisabled();
                LogicalViewProviderImpl.this.addChangeListener(WeakListeners.change(this, LogicalViewProviderImpl.this));
                ProjectInformation pi = LogicalViewProviderImpl.this.project.getLookup().lookup(ProjectInformation.class);
                this.info = pi != null ? pi : new SimpleInfo(LogicalViewProviderImpl.this.project);
                this.info.addPropertyChangeListener(WeakListeners.propertyChange(this, this.info));
            }

            @Override
            public String getShortDescription() {
                String prjDirDispName = FileUtil.getFileDisplayName(LogicalViewProviderImpl.this.project.getProjectDirectory());
                return NbBundle.getMessage(LogicalViewProviderImpl.class, "HINT_project_root_node", prjDirDispName);
            }

            @Override
            public String getHtmlDisplayName() {
                String dispName = super.getDisplayName();
                try {
                    dispName = XMLUtil.toElementContent(dispName);
                }
                catch (CharConversionException ex) {
                    return dispName;
                }
                return LogicalViewProviderImpl.this.broken ? "<font color=\"#" + Integer.toHexString(LogicalViewProviderImpl.getErrorForeground().getRGB() & 0xFFFFFF) + "\">" + dispName + "</font>" : null;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.fireIconChange();
                this.fireOpenedIconChange();
                this.fireDisplayNameChange(null, null);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        LogicalViewRootNode.this.fireNameChange(null, null);
                        LogicalViewRootNode.this.fireDisplayNameChange(null, null);
                    }
                });
            }

            @Override
            public Action[] getActions(boolean context) {
                return CommonProjectActions.forType(LogicalViewProviderImpl.this.projectType);
            }

            @Override
            public boolean canRename() {
                return true;
            }

            @Override
            public String getName() {
                return this.info.getDisplayName();
            }

            @Override
            public void setName(String s) {
                DefaultProjectOperations.performDefaultRenameOperation(LogicalViewProviderImpl.this.project, s);
            }

            @Override
            public Image getIcon(int type) {
                Icon icon = this.info.getIcon();
                Image img = icon == null ? super.getIcon(type) : ImageUtilities.icon2Image(icon);
                return !LogicalViewProviderImpl.this.broken && LogicalViewProviderImpl.this.compileOnSaveDisabled ? ImageUtilities.mergeImages(img, compileOnSaveDisabledBadge, 8, 0) : img;
            }

            @Override
            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }

            @Override
            public HelpCtx getHelpCtx() {
                return LogicalViewProviderImpl.this.helpContext == null ? super.getHelpCtx() : LogicalViewProviderImpl.this.helpContext;
            }
        }
    }

    public static interface CompileOnSaveBadge {
        public boolean isBadgeVisible();

        public boolean isImportant(@NonNull String var1);
    }

    public static class LogicalViewProviderBuilder {
        private final Project project;
        private final PropertyEvaluator eval;
        private final String projectType;
        private HelpCtx helpContext;
        private CompileOnSaveBadge badgeStatus;

        private LogicalViewProviderBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull String projectType) {
            Parameters.notNull("project", project);
            Parameters.notNull("eval", eval);
            Parameters.notNull("projectType", projectType);
            this.project = project;
            this.eval = eval;
            this.projectType = projectType;
        }

        @NonNull
        public LogicalViewProviderBuilder setHelpCtx(@NonNull HelpCtx helpContext) {
            Parameters.notNull("helpContext", helpContext);
            this.helpContext = helpContext;
            return this;
        }

        @NonNull
        public LogicalViewProviderBuilder setCompileOnSaveBadge(@NonNull CompileOnSaveBadge badgeStatus) {
            Parameters.notNull("badgeStatus", badgeStatus);
            this.badgeStatus = badgeStatus;
            return this;
        }

        @NonNull
        public LogicalViewProvider2 build() {
            return new LogicalViewProviderImpl(this.project, this.eval, this.projectType, this.helpContext, this.badgeStatus);
        }
    }
}

