/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.support.FixFactory;
import org.openide.util.NbBundle;

public class ClassStructure {
    public static ErrorDescription finalClass(HintContext context) {
        ClassTree cls = (ClassTree)context.getPath().getLeaf();
        if (cls.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return ErrorDescriptionFactory.forName(context, cls, NbBundle.getMessage(ClassStructure.class, "MSG_FinalClass", cls.getSimpleName()), FixFactory.removeModifiersFix(context.getInfo(), TreePath.getPath(context.getPath(), (Tree)cls.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, "FIX_RemoveFinalFromClass", cls.getSimpleName())));
        }
        return null;
    }

    public static ErrorDescription finalMethod(HintContext context) {
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        if (mth.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return ErrorDescriptionFactory.forName(context, mth, NbBundle.getMessage(ClassStructure.class, "MSG_FinalMethod", mth.getName()), FixFactory.removeModifiersFix(context.getInfo(), TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, "FIX_RemoveFinalFromMethod", mth.getName())));
        }
        return null;
    }

    public static ErrorDescription finalPrivateMethod(HintContext context) {
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        if (mth.getModifiers().getFlags().containsAll(EnumSet.of(Modifier.FINAL, Modifier.PRIVATE))) {
            return ErrorDescriptionFactory.forName(context, mth, NbBundle.getMessage(ClassStructure.class, "MSG_FinalPrivateMethod", mth.getName()), FixFactory.removeModifiersFix(context.getInfo(), TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, "FIX_RemoveFinalFromMethod", mth.getName())));
        }
        return null;
    }

    public static ErrorDescription finalMethodInFinalClass(HintContext context) {
        ExecutableElement ee;
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && mth.getModifiers().getFlags().contains((Object)Modifier.FINAL) && ((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.FINAL) && ((ee = (ExecutableElement)context.getInfo().getTrees().getElement(context.getPath())) == null || ee.getAnnotation(SafeVarargs.class) == null)) {
            return ErrorDescriptionFactory.forName(context, mth, NbBundle.getMessage(ClassStructure.class, "MSG_FinalMethodInFinalClass", mth.getName()), FixFactory.removeModifiersFix(context.getInfo(), TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, "FIX_RemoveFinalFromMethod", mth.getName())));
        }
        return null;
    }

    public static ErrorDescription noopMethodInAbstractClass(HintContext context) {
        BlockTree body;
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && ((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) && (body = mth.getBody()) != null && body.getStatements().isEmpty()) {
            return ErrorDescriptionFactory.forName(context, mth, NbBundle.getMessage(ClassStructure.class, "MSG_NoopMethodInAbstractClass", mth.getName()), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription publicConstructorInNonPublicClass(HintContext context) {
        MethodTree mth = (MethodTree)context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind()) && mth.getReturnType() == null && "<init>".contentEquals(mth.getName()) && mth.getModifiers().getFlags().contains((Object)Modifier.PUBLIC) && !((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
            return ErrorDescriptionFactory.forName(context, mth, NbBundle.getMessage(ClassStructure.class, "MSG_PublicConstructorInNonPublicClass", mth.getName()), FixFactory.removeModifiersFix(context.getInfo(), TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.PUBLIC), NbBundle.getMessage(ClassStructure.class, "FIX_RemovePublicFromConstructor")));
        }
        return null;
    }

    public static ErrorDescription protectedMemberInFinalClass(HintContext context) {
        Tree tree = context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getKind())) {
            if (tree.getKind() == Tree.Kind.METHOD) {
                MethodTree mth = (MethodTree)tree;
                if (mth.getModifiers().getFlags().contains((Object)Modifier.PROTECTED) && ((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
                    Element el = context.getInfo().getTrees().getElement(context.getPath());
                    if (el == null || el.getKind() != ElementKind.METHOD) {
                        return null;
                    }
                    LinkedList<ElementDescription> overrides = new LinkedList<ElementDescription>();
                    ComputeOverriding.detectOverrides(context.getInfo(), (TypeElement)el.getEnclosingElement(), (ExecutableElement)el, overrides);
                    for (ElementDescription ed : overrides) {
                        Element res = ed.getHandle().resolve(context.getInfo());
                        if (res == null || !res.getModifiers().contains((Object)Modifier.PROTECTED) && !res.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                        return null;
                    }
                    return ErrorDescriptionFactory.forName(context, mth, NbBundle.getMessage(ClassStructure.class, "MSG_ProtectedMethodInFinalClass", mth.getName()), FixFactory.removeModifiersFix(context.getInfo(), TreePath.getPath(context.getPath(), (Tree)mth.getModifiers()), EnumSet.of(Modifier.PROTECTED), NbBundle.getMessage(ClassStructure.class, "FIX_RemoveProtectedFromMethod", mth.getName())));
                }
            } else {
                VariableTree var = (VariableTree)tree;
                if (var.getModifiers().getFlags().contains((Object)Modifier.PROTECTED) && ((ClassTree)parent).getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
                    return ErrorDescriptionFactory.forName(context, var, NbBundle.getMessage(ClassStructure.class, "MSG_ProtectedFieldInFinalClass", var.getName()), FixFactory.removeModifiersFix(context.getInfo(), TreePath.getPath(context.getPath(), (Tree)var.getModifiers()), EnumSet.of(Modifier.PROTECTED), NbBundle.getMessage(ClassStructure.class, "FIX_RemoveProtectedFromField", var.getName())));
                }
            }
        }
        return null;
    }

    public static ErrorDescription markerInterface(HintContext context) {
        ClassTree cls = (ClassTree)context.getPath().getLeaf();
        if (context.getInfo().getTreeUtilities().isInterface(cls) && cls.getMembers().isEmpty() && cls.getImplementsClause().size() < 2) {
            return ErrorDescriptionFactory.forName(context, cls, NbBundle.getMessage(ClassStructure.class, "MSG_MarkerInterface", cls.getSimpleName()), new Fix[0]);
        }
        return null;
    }

    public static ErrorDescription classMayBeInterface(HintContext context) {
        ClassTree cls = (ClassTree)context.getPath().getLeaf();
        TreeUtilities treeUtilities = context.getInfo().getTreeUtilities();
        if (treeUtilities.isClass(cls) && ClassStructure.testClassMayBeInterface(context.getInfo().getTrees(), treeUtilities, context.getPath())) {
            return ErrorDescriptionFactory.forName(context, cls, NbBundle.getMessage(ClassStructure.class, "MSG_ClassMayBeInterface", cls.getSimpleName()), new ConvertClassToInterfaceFixImpl(TreePathHandle.create(context.getPath(), context.getInfo()), NbBundle.getMessage(ClassStructure.class, "FIX_ConvertClassToInterface", cls.getSimpleName())).toEditorFix());
        }
        return null;
    }

    public static ErrorDescription multipleTopLevelClassesInFile(HintContext context) {
        ClassTree cls = (ClassTree)context.getPath().getLeaf();
        Tree parent = context.getPath().getParentPath().getLeaf();
        if (parent.getKind() == Tree.Kind.COMPILATION_UNIT) {
            ArrayList<? extends Tree> typeDecls = new ArrayList<Tree>(((CompilationUnitTree)parent).getTypeDecls());
            Iterator it = typeDecls.iterator();
            while (it.hasNext()) {
                if (((Tree)it.next()).getKind() != Tree.Kind.EMPTY_STATEMENT) continue;
                it.remove();
            }
            if (typeDecls.size() > 1 && typeDecls.get(0) != cls) {
                return ErrorDescriptionFactory.forName(context, cls, NbBundle.getMessage(ClassStructure.class, "MSG_MultipleTopLevelClassesInFile"), new Fix[0]);
            }
        }
        return null;
    }

    private static boolean testClassMayBeInterface(Trees trees, TreeUtilities treeUtilities, TreePath path) {
        TypeMirror superclass;
        ClassTree cls = (ClassTree)path.getLeaf();
        if (!treeUtilities.isClass(cls)) {
            return true;
        }
        Element element = trees.getElement(path);
        if (element == null) {
            return false;
        }
        TypeMirror typeMirror = superclass = element.getKind().isClass() ? ((TypeElement)element).getSuperclass() : null;
        if (superclass == null || superclass.getKind() != TypeKind.DECLARED || !"java.lang.Object".contentEquals(((TypeElement)((DeclaredType)superclass).asElement()).getQualifiedName())) {
            return false;
        }
        block5: for (Tree tree : cls.getMembers()) {
            TreePath memberPath = TreePath.getPath(path, tree);
            if (treeUtilities.isSynthetic(memberPath)) continue;
            switch (tree.getKind()) {
                case VARIABLE: {
                    if (((VariableTree)tree).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL))) continue block5;
                    return false;
                }
                case METHOD: {
                    if (((MethodTree)tree).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.PUBLIC, Modifier.ABSTRACT))) continue block5;
                    return false;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (ClassStructure.testClassMayBeInterface(trees, treeUtilities, memberPath)) continue block5;
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private static final class ConvertClassToInterfaceFixImpl
    extends JavaFix {
        private final String text;

        public ConvertClassToInterfaceFixImpl(TreePathHandle clsHandle, String text) {
            super(clsHandle);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            GeneratorUtilities gu = GeneratorUtilities.get(wc);
            TreePath path = ctx.getPath();
            ClassTree cls = (ClassTree)path.getLeaf();
            gu.importComments(cls, wc.getCompilationUnit());
            TreeMaker treeMaker = wc.getTreeMaker();
            ModifiersTree mods = cls.getModifiers();
            if (mods.getFlags().contains((Object)Modifier.ABSTRACT)) {
                EnumSet<Modifier> modifiers = EnumSet.copyOf(mods.getFlags());
                modifiers.remove((Object)Modifier.ABSTRACT);
                ModifiersTree nmods = treeMaker.Modifiers(modifiers, mods.getAnnotations());
                gu.copyComments(mods, nmods, true);
                gu.copyComments(mods, nmods, false);
                mods = nmods;
            }
            ClassTree nue = treeMaker.Interface(mods, cls.getSimpleName(), cls.getTypeParameters(), cls.getImplementsClause(), cls.getMembers());
            gu.copyComments(cls, nue, true);
            gu.copyComments(cls, nue, false);
            wc.rewrite(path.getLeaf(), nue);
        }
    }
}

