/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.macos;

import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.NBPackage;
import org.apache.netbeans.nbpackage.macos.AppBundleTask;
import org.apache.netbeans.nbpackage.macos.MacOS;

class PkgTask
extends AppBundleTask {
    PkgTask(ExecutionContext context) {
        super(context);
    }

    @Override
    protected void checkPackageRequirements() throws Exception {
        super.checkPackageRequirements();
        this.validateTools("pkgbuild");
    }

    @Override
    protected Path buildPackage(Path image) throws Exception {
        Path bundle = super.buildPackage(image);
        String name = this.context().getValue(NBPackage.PACKAGE_NAME).orElseThrow();
        String version = this.context().getValue(NBPackage.PACKAGE_VERSION).orElseThrow();
        String arch = this.bundleArch();
        String outputName = "universal".equals(arch) ? this.sanitizeNoWhitespace(name) + "-" + this.sanitizeNoWhitespace(version) + ".pkg" : this.sanitizeNoWhitespace(name) + "-" + this.sanitizeNoWhitespace(version) + "-" + arch + ".pkg";
        Path output = this.context().destination().resolve(outputName);
        String signingID = this.context().getValue(MacOS.PKGBUILD_ID).orElse("");
        ArrayList<String> command = new ArrayList<String>();
        command.add("pkgbuild");
        command.add("--component");
        command.add(bundle.toString());
        command.add("--version");
        command.add(version);
        command.add("--install-location");
        command.add("/Applications");
        if (signingID.isBlank()) {
            this.context().warningHandler().accept(MacOS.MESSAGES.getString("message.nopkgbuildid"));
        } else {
            command.add("--sign");
            command.add(signingID);
        }
        command.add(output.toString());
        int result = this.context().exec(command);
        if (result != 0) {
            throw new Exception();
        }
        return output;
    }

    @Override
    protected String calculateImageName(Path input) throws Exception {
        return super.calculateImageName(input) + "-pkg";
    }

    private String sanitizeNoWhitespace(String text) {
        return this.sanitize(text).replaceAll("\\s", "-");
    }
}

