/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.component.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.c2.protocol.component.api.Attribute;
import org.apache.nifi.c2.protocol.component.api.ConfigurableExtensionDefinition;
import org.apache.nifi.c2.protocol.component.api.DynamicRelationship;
import org.apache.nifi.c2.protocol.component.api.Relationship;

@ApiModel
public class ProcessorDefinition
extends ConfigurableExtensionDefinition {
    private static final long serialVersionUID = 1L;
    private InputRequirement.Requirement inputRequirement;
    private List<Relationship> supportedRelationships;
    private boolean supportsDynamicRelationships;
    private DynamicRelationship dynamicRelationship;
    private boolean triggerSerially;
    private boolean triggerWhenEmpty;
    private boolean triggerWhenAnyDestinationAvailable;
    private boolean supportsBatching;
    private boolean supportsEventDriven;
    private boolean primaryNodeOnly;
    private boolean sideEffectFree;
    private List<String> supportedSchedulingStrategies;
    private String defaultSchedulingStrategy;
    private Map<String, Integer> defaultConcurrentTasksBySchedulingStrategy;
    private Map<String, String> defaultSchedulingPeriodBySchedulingStrategy;
    private String defaultPenaltyDuration;
    private String defaultYieldDuration;
    private String defaultBulletinLevel;
    private List<Attribute> readsAttributes;
    private List<Attribute> writesAttributes;

    @ApiModelProperty(value="Any input requirements this processor has.")
    public InputRequirement.Requirement getInputRequirement() {
        return this.inputRequirement;
    }

    public void setInputRequirement(InputRequirement.Requirement inputRequirement) {
        this.inputRequirement = inputRequirement;
    }

    @ApiModelProperty(value="The supported relationships for this processor.")
    public List<Relationship> getSupportedRelationships() {
        return this.supportedRelationships == null ? Collections.emptyList() : Collections.unmodifiableList(this.supportedRelationships);
    }

    public void setSupportedRelationships(List<Relationship> supportedRelationships) {
        this.supportedRelationships = supportedRelationships;
    }

    @ApiModelProperty(value="Whether or not this processor supports dynamic relationships.")
    public boolean getSupportsDynamicRelationships() {
        return this.supportsDynamicRelationships;
    }

    public void setSupportsDynamicRelationships(boolean supportsDynamicRelationships) {
        this.supportsDynamicRelationships = supportsDynamicRelationships;
    }

    @ApiModelProperty(value="If the processor supports dynamic relationships, this describes the dynamic relationship")
    public DynamicRelationship getDynamicRelationship() {
        return this.dynamicRelationship;
    }

    public void setDynamicRelationship(DynamicRelationship dynamicRelationship) {
        this.dynamicRelationship = dynamicRelationship;
    }

    @ApiModelProperty(value="Whether or not this processor should be triggered serially (i.e. no concurrent execution).")
    public boolean getTriggerSerially() {
        return this.triggerSerially;
    }

    public void setTriggerSerially(boolean triggerSerially) {
        this.triggerSerially = triggerSerially;
    }

    @ApiModelProperty(value="Whether or not this processor should be triggered when incoming queues are empty.")
    public boolean getTriggerWhenEmpty() {
        return this.triggerWhenEmpty;
    }

    public void setTriggerWhenEmpty(boolean triggerWhenEmpty) {
        this.triggerWhenEmpty = triggerWhenEmpty;
    }

    @ApiModelProperty(value="Whether or not this processor should be triggered when any destination queue has room.")
    public boolean getTriggerWhenAnyDestinationAvailable() {
        return this.triggerWhenAnyDestinationAvailable;
    }

    public void setTriggerWhenAnyDestinationAvailable(boolean triggerWhenAnyDestinationAvailable) {
        this.triggerWhenAnyDestinationAvailable = triggerWhenAnyDestinationAvailable;
    }

    @ApiModelProperty(value="Whether or not this processor supports batching. If a Processor uses this annotation, it allows the Framework to batch calls to session commits, as well as allowing the Framework to return the same session multiple times.")
    public boolean getSupportsBatching() {
        return this.supportsBatching;
    }

    public void setSupportsBatching(boolean supportsBatching) {
        this.supportsBatching = supportsBatching;
    }

    @ApiModelProperty(value="Whether or not this processor supports event driven scheduling. Indicates to the framework that the Processor is eligible to be scheduled to run based on the occurrence of an \"Event\" (e.g., when a FlowFile is enqueued in an incoming Connection), rather than being triggered periodically.")
    public boolean getSupportsEventDriven() {
        return this.supportsEventDriven;
    }

    public void setSupportsEventDriven(boolean supportsEventDriven) {
        this.supportsEventDriven = supportsEventDriven;
    }

    @ApiModelProperty(value="Whether or not this processor should be scheduled only on the primary node in a cluster.")
    public boolean getPrimaryNodeOnly() {
        return this.primaryNodeOnly;
    }

    public void setPrimaryNodeOnly(boolean primaryNodeOnly) {
        this.primaryNodeOnly = primaryNodeOnly;
    }

    @ApiModelProperty(value="Whether or not this processor is considered side-effect free. Side-effect free indicate that the processor's operations on FlowFiles can be safely repeated across process sessions.")
    public boolean getSideEffectFree() {
        return this.sideEffectFree;
    }

    public void setSideEffectFree(boolean sideEffectFree) {
        this.sideEffectFree = sideEffectFree;
    }

    @ApiModelProperty(value="The supported scheduling strategies, such as TIME_DRIVER, CRON, or EVENT_DRIVEN.")
    public List<String> getSupportedSchedulingStrategies() {
        return this.supportedSchedulingStrategies;
    }

    public void setSupportedSchedulingStrategies(List<String> supportedSchedulingStrategies) {
        this.supportedSchedulingStrategies = supportedSchedulingStrategies;
    }

    @ApiModelProperty(value="The default scheduling strategy for the processor.")
    public String getDefaultSchedulingStrategy() {
        return this.defaultSchedulingStrategy;
    }

    public void setDefaultSchedulingStrategy(String defaultSchedulingStrategy) {
        this.defaultSchedulingStrategy = defaultSchedulingStrategy;
    }

    @ApiModelProperty(value="The default concurrent tasks for each scheduling strategy.")
    public Map<String, Integer> getDefaultConcurrentTasksBySchedulingStrategy() {
        return this.defaultConcurrentTasksBySchedulingStrategy != null ? Collections.unmodifiableMap(this.defaultConcurrentTasksBySchedulingStrategy) : null;
    }

    public void setDefaultConcurrentTasksBySchedulingStrategy(Map<String, Integer> defaultConcurrentTasksBySchedulingStrategy) {
        this.defaultConcurrentTasksBySchedulingStrategy = defaultConcurrentTasksBySchedulingStrategy;
    }

    @ApiModelProperty(value="The default scheduling period for each scheduling strategy. The scheduling period is expected to be a time period, such as \"30 sec\".")
    public Map<String, String> getDefaultSchedulingPeriodBySchedulingStrategy() {
        return this.defaultSchedulingPeriodBySchedulingStrategy != null ? Collections.unmodifiableMap(this.defaultSchedulingPeriodBySchedulingStrategy) : null;
    }

    public void setDefaultSchedulingPeriodBySchedulingStrategy(Map<String, String> defaultSchedulingPeriodBySchedulingStrategy) {
        this.defaultSchedulingPeriodBySchedulingStrategy = defaultSchedulingPeriodBySchedulingStrategy;
    }

    @ApiModelProperty(value="The default penalty duration as a time period, such as \"30 sec\".")
    public String getDefaultPenaltyDuration() {
        return this.defaultPenaltyDuration;
    }

    public void setDefaultPenaltyDuration(String defaultPenaltyDuration) {
        this.defaultPenaltyDuration = defaultPenaltyDuration;
    }

    @ApiModelProperty(value="The default yield duration as a time period, such as \"1 sec\".")
    public String getDefaultYieldDuration() {
        return this.defaultYieldDuration;
    }

    public void setDefaultYieldDuration(String defaultYieldDuration) {
        this.defaultYieldDuration = defaultYieldDuration;
    }

    @ApiModelProperty(value="The default bulletin level, such as WARN, INFO, DEBUG, etc.")
    public String getDefaultBulletinLevel() {
        return this.defaultBulletinLevel;
    }

    public void setDefaultBulletinLevel(String defaultBulletinLevel) {
        this.defaultBulletinLevel = defaultBulletinLevel;
    }

    @ApiModelProperty(value="The FlowFile attributes this processor reads")
    public List<Attribute> getReadsAttributes() {
        return this.readsAttributes;
    }

    public void setReadsAttributes(List<Attribute> readsAttributes) {
        this.readsAttributes = readsAttributes;
    }

    @ApiModelProperty(value="The FlowFile attributes this processor writes/updates")
    public List<Attribute> getWritesAttributes() {
        return this.writesAttributes;
    }

    public void setWritesAttributes(List<Attribute> writesAttributes) {
        this.writesAttributes = writesAttributes;
    }
}

