/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Optional;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.exception.InvalidCommandException;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.service.UpdateConfigurationService;
import org.apache.nifi.minifi.bootstrap.service.UpdatePropertiesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapCodec {
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private final RunMiNiFi runner;
    private final Logger logger = LoggerFactory.getLogger(BootstrapCodec.class);
    private final UpdatePropertiesService updatePropertiesService;
    private final UpdateConfigurationService updateConfigurationService;

    public BootstrapCodec(RunMiNiFi runner, BootstrapFileProvider bootstrapFileProvider, ConfigurationChangeListener configurationChangeListener) {
        this.runner = runner;
        this.updatePropertiesService = new UpdatePropertiesService(runner, this.logger, bootstrapFileProvider);
        this.updateConfigurationService = new UpdateConfigurationService(runner, configurationChangeListener, bootstrapFileProvider);
    }

    public void communicate(InputStream in, OutputStream out) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        String line = reader.readLine();
        String[] splits = Optional.ofNullable(line).map(l -> l.split(" ")).orElse(new String[0]);
        if (splits.length == 0) {
            throw new IOException("Received invalid command from MiNiFi: " + line);
        }
        BootstrapCommand cmd = BootstrapCommand.safeValueOf(splits[0]);
        String[] args = splits.length == 1 ? new String[]{} : Arrays.copyOfRange(splits, 1, splits.length);
        try {
            this.processRequest(cmd, args, writer);
        }
        catch (InvalidCommandException exception) {
            throw new IOException("Received invalid command from MiNiFi: " + line, exception);
        }
    }

    private void processRequest(BootstrapCommand cmd, String[] args, BufferedWriter writer) throws InvalidCommandException, IOException {
        switch (cmd) {
            case PORT: {
                this.handlePortCommand(args, writer);
                break;
            }
            case STARTED: {
                this.handleStartedCommand(args, writer);
                break;
            }
            case SHUTDOWN: {
                this.handleShutDownCommand(writer);
                break;
            }
            case RELOAD: {
                this.handleReloadCommand(writer);
                break;
            }
            case UPDATE_PROPERTIES: {
                this.handlePropertiesUpdateCommand(writer);
                break;
            }
            case UPDATE_CONFIGURATION: {
                this.handleUpdateConfigurationCommand(writer);
                break;
            }
            default: {
                throw new InvalidCommandException("Unknown command: " + (Object)((Object)cmd));
            }
        }
    }

    private void handleUpdateConfigurationCommand(BufferedWriter writer) throws IOException {
        this.logger.debug("Received 'UPDATE_CONFIGURATION' command from MINIFI");
        this.writeOk(writer);
        this.runner.setCommandInProgress(true);
        this.updateConfigurationService.handleUpdate().ifPresent(this.runner::sendAcknowledgeToMiNiFi);
    }

    private void handlePropertiesUpdateCommand(BufferedWriter writer) throws IOException {
        this.logger.debug("Received 'UPDATE_PROPERTIES' command from MINIFI");
        this.writeOk(writer);
        this.runner.setCommandInProgress(true);
        this.updatePropertiesService.handleUpdate().ifPresent(this.runner::sendAcknowledgeToMiNiFi);
    }

    private void handleReloadCommand(BufferedWriter writer) throws IOException {
        this.logger.debug("Received 'RELOAD' command from MINIFI");
        this.writeOk(writer);
    }

    private void handleShutDownCommand(BufferedWriter writer) throws IOException {
        this.logger.debug("Received 'SHUTDOWN' command from MINIFI");
        this.writeOk(writer);
        this.runner.shutdownChangeNotifier();
        this.runner.getPeriodicStatusReporterManager().shutdownPeriodicStatusReporters();
    }

    private void handleStartedCommand(String[] args, BufferedWriter writer) throws InvalidCommandException, IOException {
        this.logger.info("Received 'STARTED' command from MINIFI");
        if (args.length != 1) {
            throw new InvalidCommandException("STARTED command must contain a status argument");
        }
        if (!TRUE.equalsIgnoreCase(args[0]) && !FALSE.equalsIgnoreCase(args[0])) {
            throw new InvalidCommandException("Invalid status for STARTED command; should be true or false, but was '" + args[0] + "'");
        }
        this.writeOk(writer);
        this.runner.getPeriodicStatusReporterManager().shutdownPeriodicStatusReporters();
        this.runner.getPeriodicStatusReporterManager().startPeriodicNotifiers();
        this.runner.getConfigurationChangeCoordinator().start();
        this.runner.setNiFiStarted(Boolean.parseBoolean(args[0]));
    }

    private void handlePortCommand(String[] args, BufferedWriter writer) throws InvalidCommandException, IOException {
        int port;
        this.logger.debug("Received 'PORT' command from MINIFI");
        if (args.length != 2) {
            throw new InvalidCommandException("PORT command must contain the port and secretKey arguments");
        }
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidCommandException("Invalid Port number; should be integer between 1 and 65535");
        }
        if (port < 1 || port > 65535) {
            throw new InvalidCommandException("Invalid Port number; should be integer between 1 and 65535");
        }
        this.writeOk(writer);
        this.runner.setMiNiFiParameters(port, args[1]);
    }

    private void writeOk(BufferedWriter writer) throws IOException {
        writer.write("OK");
        writer.newLine();
        writer.flush();
    }

    private static enum BootstrapCommand {
        PORT,
        STARTED,
        SHUTDOWN,
        RELOAD,
        UPDATE_PROPERTIES,
        UPDATE_CONFIGURATION,
        UNKNOWN;


        public static BootstrapCommand safeValueOf(String value) {
            try {
                return BootstrapCommand.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

