/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.exception.FlowFileAccessException;

public class FlowFileAccessOutputStream
extends FilterOutputStream {
    private final FlowFile flowFile;
    private final OutputStream out;

    public FlowFileAccessOutputStream(OutputStream out, FlowFile flowFile) {
        super(out);
        this.flowFile = flowFile;
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.out.write(b, off, len);
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not write to " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.out.write(b);
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not write to " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.out.write(b);
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not write to " + this.flowFile, (Throwable)ioe);
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.out.flush();
        }
        catch (IOException ioe) {
            throw new FlowFileAccessException("Could not flush OutputStream for " + this.flowFile, (Throwable)ioe);
        }
    }
}

