/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.ComparableValueType;
import jetbrains.exodus.bindings.DoubleBinding;
import jetbrains.exodus.bindings.FloatBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.IntArrayList;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.IntHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLong23TreeSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongSet;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.DiskBasedBlobVault;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.Settings;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.tables.BlobsTable;
import jetbrains.exodus.entitystore.tables.FieldIndex;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.LinksTable;
import jetbrains.exodus.entitystore.tables.PropertiesTable;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.entitystore.tables.SingleColumnTable;
import jetbrains.exodus.env.Bitmap;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.kotlin.KodusKt;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0006J\u0006\u0010\u0014\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0006J\b\u0010\u0016\u001a\u00020\u0006H\u0007J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010\u001e\u001a\u00020\u0006J*\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\t2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00060\"H\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\t2\u0006\u0010!\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ljetbrains/exodus/entitystore/PersistentEntityStoreRefactorings;", "", "store", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "(Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;)V", "refactorAllBlobsIndexToBitmap", "", "refactorAllIdxToBitmap", "indexName", "", "getIndexName", "Lkotlin/Function1;", "", "refactorAllLinksIndexToBitmap", "refactorAllPropsIndexToBitmap", "refactorBlobFileLengths", "refactorBlobsToVersion2Format", "settings", "Ljetbrains/exodus/env/Store;", "refactorCreateNullBlobIndices", "refactorCreateNullLinkIndices", "refactorCreateNullPropertyIndices", "refactorDeduplicateInPlaceBlobs", "refactorDeduplicateInPlaceBlobsPeriodically", "refactorDeleteRedundantBlobs", "refactorDropEmptyPrimaryLinkTables", "refactorEntitiesTablesToBitmap", "refactorFixNegativeFloatAndDoubleProps", "refactorMakeLinkTablesConsistent", "internalSettings", "refactorMakePropTablesConsistent", "safeExecuteRefactoringForEachEntityType", "message", "executable", "Lkotlin/Function2;", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "safeExecuteRefactoringForEntityType", "entityType", "Ljetbrains/exodus/entitystore/StoreTransactionalExecutable;", "safeRemoveStore", "name", "txn", "Ljetbrains/exodus/env/Transaction;", "Companion", "xodus-entity-store"})
public final class PersistentEntityStoreRefactorings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PersistentEntityStoreImpl store;

    public PersistentEntityStoreRefactorings(@NotNull PersistentEntityStoreImpl store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    public final void refactorDeleteRedundantBlobs() {
        BlobVault blobVault = this.store.getBlobVault();
        Intrinsics.checkNotNullExpressionValue((Object)blobVault, (String)"store.blobVault");
        BlobVault blobVault2 = blobVault;
        if (blobVault2 instanceof FileSystemBlobVaultOld) {
            PersistentEntityStoreRefactorings.Companion.logInfo("Deleting redundant blobs...");
            Long nextBlobHandle = (Long)this.store.computeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorDeleteRedundantBlobs$lambda-0(blobVault2, arg_0));
            int n = 0;
            while (n < 10000) {
                int i = n++;
                BlobVaultItem blobVaultItem = blobVault2.getBlob(nextBlobHandle + (long)i);
                Intrinsics.checkNotNullExpressionValue((Object)blobVaultItem, (String)"blobVault.getBlob(nextBlobHandle + i)");
                BlobVaultItem item = blobVaultItem;
                if (!item.exists()) continue;
                if (blobVault2.delete(item.getHandle())) {
                    PersistentEntityStoreRefactorings.Companion.logInfo(Intrinsics.stringPlus((String)"Deleted ", (Object)item));
                    continue;
                }
                Companion.getLogger().error(Intrinsics.stringPlus((String)"Failed to delete ", (Object)item));
            }
        }
    }

    public final void refactorCreateNullPropertyIndices() {
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorCreateNullPropertyIndices$lambda-4(this, arg_0));
    }

    public final void refactorCreateNullBlobIndices() {
        this.safeExecuteRefactoringForEachEntityType("Refactoring creating null-value blob indices", (Function2<? super String, ? super PersistentStoreTransaction, Unit>)((Function2)new Function2<String, PersistentStoreTransaction, Unit>(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull String entityType, @NotNull PersistentStoreTransaction txn) {
                Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
                Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
                int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypeId(txn, entityType, false);
                BlobsTable blobsTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getBlobsTable(txn, entityTypeId);
                Intrinsics.checkNotNullExpressionValue((Object)blobsTable, (String)"store.getBlobsTable(txn, entityTypeId)");
                BlobsTable blobs = blobsTable;
                FieldIndex allBlobsIndex = blobs.getAllBlobsIndex();
                Object object = txn.getEnvironmentTransaction();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"txn.environmentTransaction");
                Transaction envTxn = object;
                object = (Closeable)blobs.getPrimaryIndex().openCursor(envTxn);
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)object;
                    boolean bl = false;
                    while (cursor.getNext()) {
                        PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                        allBlobsIndex.put(envTxn, propertyKey.getPropertyId(), propertyKey.getEntityLocalId());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }));
    }

    public final void refactorBlobFileLengths() {
        BlobVault blobVault = this.store.getBlobVault();
        Intrinsics.checkNotNullExpressionValue((Object)blobVault, (String)"store.blobVault");
        BlobVault blobVault2 = blobVault;
        if (blobVault2 instanceof DiskBasedBlobVault) {
            DiskBasedBlobVault diskVault = (DiskBasedBlobVault)blobVault2;
            this.safeExecuteRefactoringForEachEntityType("Refactoring blob lengths table", (Function2<? super String, ? super PersistentStoreTransaction, Unit>)((Function2)new Function2<String, PersistentStoreTransaction, Unit>(this, diskVault){
                final /* synthetic */ PersistentEntityStoreRefactorings this$0;
                final /* synthetic */ DiskBasedBlobVault $diskVault;
                {
                    this.this$0 = $receiver;
                    this.$diskVault = $diskVault;
                    super(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull String entityType, @NotNull PersistentStoreTransaction txn) {
                    Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
                    Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
                    int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypeId(txn, entityType, false);
                    BlobsTable blobsTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getBlobsTable(txn, entityTypeId);
                    Intrinsics.checkNotNullExpressionValue((Object)blobsTable, (String)"store.getBlobsTable(txn, entityTypeId)");
                    BlobsTable blobs = blobsTable;
                    Object object = txn.getEnvironmentTransaction();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"txn.environmentTransaction");
                    Transaction envTxn = object;
                    object = (Closeable)blobs.getPrimaryIndex().openCursor(envTxn);
                    PersistentEntityStoreRefactorings persistentEntityStoreRefactorings = this.this$0;
                    DiskBasedBlobVault diskBasedBlobVault = this.$diskVault;
                    Throwable throwable = null;
                    try {
                        Cursor cursor = (Cursor)object;
                        boolean bl = false;
                        while (cursor.getNext()) {
                            long blobHandle = LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue());
                            if (PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) continue;
                            PersistentEntityStoreRefactorings.access$getStore$p(persistentEntityStoreRefactorings).setBlobFileLength(txn, blobHandle, diskBasedBlobVault.getBlobLocation(blobHandle).length());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                }
            }));
        }
    }

    public final void refactorCreateNullLinkIndices() {
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorCreateNullLinkIndices$lambda-5(this, arg_0));
    }

    public final void refactorDropEmptyPrimaryLinkTables() {
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorDropEmptyPrimaryLinkTables$lambda-6(this, arg_0));
    }

    public final void refactorMakeLinkTablesConsistent(@NotNull Store internalSettings) {
        Intrinsics.checkNotNullParameter((Object)internalSettings, (String)"internalSettings");
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorMakeLinkTablesConsistent$lambda-7(this, internalSettings, arg_0));
    }

    public final void refactorMakePropTablesConsistent() {
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorMakePropTablesConsistent$lambda-8(this, arg_0));
    }

    public final void refactorFixNegativeFloatAndDoubleProps(@NotNull Store settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorFixNegativeFloatAndDoubleProps$lambda-15(this, settings, arg_0));
    }

    public final void refactorBlobsToVersion2Format(@NotNull Store settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorBlobsToVersion2Format$lambda-22(this, settings, arg_0));
    }

    public final void refactorEntitiesTablesToBitmap(@NotNull Store settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorEntitiesTablesToBitmap$lambda-27(this, settings, arg_0));
    }

    public final void refactorAllPropsIndexToBitmap() {
        this.refactorAllIdxToBitmap("allPropsIndex", (Function1<? super Integer, String>)((Function1)new Function1<Integer, String>(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(int entityTypeId) {
                return Intrinsics.stringPlus((String)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getNamingRules().getPropertiesTableName(entityTypeId), (Object)"#all_idx");
            }
        }));
    }

    public final void refactorAllLinksIndexToBitmap() {
        this.refactorAllIdxToBitmap("allLinksIndex", (Function1<? super Integer, String>)((Function1)new Function1<Integer, String>(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(int entityTypeId) {
                return Intrinsics.stringPlus((String)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getNamingRules().getLinksTableName(entityTypeId), (Object)"#all_idx");
            }
        }));
    }

    public final void refactorAllBlobsIndexToBitmap() {
        this.refactorAllIdxToBitmap("allBlobsIndex", (Function1<? super Integer, String>)((Function1)new Function1<Integer, String>(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(int entityTypeId) {
                return Intrinsics.stringPlus((String)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getNamingRules().getBlobsTableName(entityTypeId), (Object)"#all_idx");
            }
        }));
    }

    public final void refactorDeduplicateInPlaceBlobsPeriodically(@NotNull Store settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.store.getEnvironment().executeBeforeGc(() -> PersistentEntityStoreRefactorings.refactorDeduplicateInPlaceBlobsPeriodically$lambda-28(this, settings));
    }

    @Deprecated(message="This method can be used in tests only.")
    public final void refactorDeduplicateInPlaceBlobs() {
        Environment environment = this.store.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)environment, (String)"store.environment");
        Environment env = environment;
        Store store = (Store)env.computeInTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorDeduplicateInPlaceBlobs$lambda-29(env, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"store");
        this.refactorDeduplicateInPlaceBlobs(store);
    }

    private final void refactorDeduplicateInPlaceBlobs(Store settings) {
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorDeduplicateInPlaceBlobs$lambda-35(this, settings, arg_0));
    }

    private final void refactorAllIdxToBitmap(String indexName, Function1<? super Integer, String> getIndexName) {
        this.store.executeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorAllIdxToBitmap$lambda-38(this, getIndexName, indexName, arg_0));
    }

    private final void safeExecuteRefactoringForEachEntityType(String message, Function2<? super String, ? super PersistentStoreTransaction, Unit> executable) {
        List entityTypes = (List)this.store.computeInReadonlyTransaction(arg_0 -> PersistentEntityStoreRefactorings.safeExecuteRefactoringForEachEntityType$lambda-39(this, arg_0));
        for (String entityType : entityTypes) {
            PersistentEntityStoreRefactorings.Companion.logInfo(message + " for [" + entityType + ']');
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"entityType");
            this.safeExecuteRefactoringForEntityType(entityType, arg_0 -> PersistentEntityStoreRefactorings.safeExecuteRefactoringForEachEntityType$lambda-40(executable, entityType, arg_0));
        }
    }

    private final void safeExecuteRefactoringForEntityType(String entityType, StoreTransactionalExecutable executable) {
        try {
            this.store.executeInTransaction(executable);
        }
        catch (Throwable t) {
            Companion.getLogger().error(Intrinsics.stringPlus((String)"Failed to execute refactoring for entity type: ", (Object)entityType), t);
            PersistentEntityStoreRefactorings.Companion.throwJVMError(t);
        }
    }

    private final void safeRemoveStore(String name, Transaction txn) {
        try {
            Environment $this$safeRemoveStore_u24lambda_u2d41 = txn.getEnvironment();
            boolean bl = false;
            if ($this$safeRemoveStore_u24lambda_u2d41.storeExists(name, txn)) {
                $this$safeRemoveStore_u24lambda_u2d41.removeStore(name, txn);
            }
        }
        catch (ExodusException e) {
            Companion.getLogger().error(Intrinsics.stringPlus((String)"Failed to remove store ", (Object)name), (Throwable)e);
        }
    }

    private static final Long refactorDeleteRedundantBlobs$lambda-0(BlobVault $blobVault, StoreTransaction tx) {
        Intrinsics.checkNotNullParameter((Object)$blobVault, (String)"$blobVault");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
        return $blobVault.nextHandle(txn.getEnvironmentTransaction());
    }

    private static final void refactorCreateNullPropertyIndices$lambda-4$dumpAdded$lambda-1(PropertiesTable $props, IntArrayList $aFieldIds, LongArrayList $aLocalIds, Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)$props, (String)"$props");
        Intrinsics.checkNotNullParameter((Object)$aFieldIds, (String)"$aFieldIds");
        Intrinsics.checkNotNullParameter((Object)$aLocalIds, (String)"$aLocalIds");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        FieldIndex allPropsIndex = $props.getAllPropsIndex();
        int n = 0;
        int n2 = $aFieldIds.size();
        while (n < n2) {
            int i = n++;
            allPropsIndex.put(txn, $aFieldIds.get(i), $aLocalIds.get(i));
        }
    }

    private static final void refactorCreateNullPropertyIndices$lambda-4$dumpAdded(IntArrayList aFieldIds, PersistentEntityStoreRefactorings this$0, LongArrayList aLocalIds, PropertiesTable props) {
        if (!aFieldIds.isEmpty()) {
            this$0.store.getEnvironment().executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorCreateNullPropertyIndices$lambda-4$dumpAdded$lambda-1(props, aFieldIds, aLocalIds, arg_0));
            aFieldIds.clear();
            aLocalIds.clear();
        }
    }

    private static final void refactorCreateNullPropertyIndices$lambda-4$dumpDeleted$lambda-2(IntArrayList $dFieldIds, PropertiesTable $props, LongArrayList $dLocalIds, Ref.ObjectRef $cursorValueToDelete, Ref.ObjectRef $propTypeToDelete, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)$dFieldIds, (String)"$dFieldIds");
        Intrinsics.checkNotNullParameter((Object)$props, (String)"$props");
        Intrinsics.checkNotNullParameter((Object)$dLocalIds, (String)"$dLocalIds");
        Intrinsics.checkNotNullParameter((Object)$cursorValueToDelete, (String)"$cursorValueToDelete");
        Intrinsics.checkNotNullParameter((Object)$propTypeToDelete, (String)"$propTypeToDelete");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        int n = 0;
        int n2 = $dFieldIds.size();
        while (n < n2) {
            int i = n++;
            $props.delete((PersistentStoreTransaction)txn, $dLocalIds.get(i), (ByteIterable)KodusKt.getNotNull((Object)$cursorValueToDelete.element), $dFieldIds.get(i), (ComparableValueType)KodusKt.getNotNull((Object)$propTypeToDelete.element));
        }
    }

    private static final void refactorCreateNullPropertyIndices$lambda-4$dumpDeleted(IntArrayList dFieldIds, PersistentEntityStoreRefactorings this$0, LongArrayList dLocalIds, PropertiesTable props, Ref.ObjectRef<ArrayByteIterable> cursorValueToDelete, Ref.ObjectRef<ComparableValueType> propTypeToDelete) {
        if (!dFieldIds.isEmpty()) {
            this$0.store.executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorCreateNullPropertyIndices$lambda-4$dumpDeleted$lambda-2(dFieldIds, props, dLocalIds, cursorValueToDelete, propTypeToDelete, arg_0));
            dFieldIds.clear();
            dLocalIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refactorCreateNullPropertyIndices$lambda-4(PersistentEntityStoreRefactorings this$0, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        Ref.ObjectRef cursorValueToDelete = new Ref.ObjectRef();
        Ref.ObjectRef propTypeToDelete = new Ref.ObjectRef();
        for (String entityType : this$0.store.getEntityTypes((PersistentStoreTransaction)txn)) {
            PersistentEntityStoreRefactorings.Companion.logInfo("Refactoring creating null-value property indices for [" + entityType + ']');
            int entityTypeId = this$0.store.getEntityTypeId((PersistentStoreTransaction)txn, entityType, false);
            PropertiesTable propertiesTable = this$0.store.getPropertiesTable((PersistentStoreTransaction)txn, entityTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)propertiesTable, (String)"store.getPropertiesTable(txn, entityTypeId)");
            PropertiesTable props = propertiesTable;
            IntArrayList aFieldIds = new IntArrayList();
            LongArrayList aLocalIds = new LongArrayList();
            IntArrayList dFieldIds = new IntArrayList();
            LongArrayList dLocalIds = new LongArrayList();
            Closeable closeable = (Closeable)this$0.store.getPrimaryPropertyIndexCursor((PersistentStoreTransaction)txn, entityTypeId);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                while (cursor.getNext()) {
                    PropertyKey propKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                    ArrayByteIterable cursorValue = new ArrayByteIterable(cursor.getValue());
                    PropertyValue propValue = this$0.store.getPropertyTypes().entryToPropertyValue((ByteIterable)cursorValue);
                    Comparable comparable = propValue.getData();
                    Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"propValue.data");
                    Comparable data = comparable;
                    int fieldId = propKey.getPropertyId();
                    long localId = propKey.getEntityLocalId();
                    if (!(data instanceof Boolean) || Intrinsics.areEqual((Object)data, (Object)true)) {
                        aFieldIds.add(fieldId);
                        aLocalIds.add(localId);
                        if (aFieldIds.size() != 1000) continue;
                        PersistentEntityStoreRefactorings.refactorCreateNullPropertyIndices$lambda-4$dumpAdded(aFieldIds, this$0, aLocalIds, props);
                        continue;
                    }
                    dFieldIds.add(fieldId);
                    dLocalIds.add(localId);
                    cursorValueToDelete.element = cursorValue;
                    propTypeToDelete.element = propValue.getType();
                    if (dFieldIds.size() != 1000) continue;
                    PersistentEntityStoreRefactorings.refactorCreateNullPropertyIndices$lambda-4$dumpDeleted(dFieldIds, this$0, dLocalIds, props, (Ref.ObjectRef<ArrayByteIterable>)cursorValueToDelete, (Ref.ObjectRef<ComparableValueType>)propTypeToDelete);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            PersistentEntityStoreRefactorings.refactorCreateNullPropertyIndices$lambda-4$dumpAdded(aFieldIds, this$0, aLocalIds, props);
            PersistentEntityStoreRefactorings.refactorCreateNullPropertyIndices$lambda-4$dumpDeleted(dFieldIds, this$0, dLocalIds, props, (Ref.ObjectRef<ArrayByteIterable>)cursorValueToDelete, (Ref.ObjectRef<ComparableValueType>)propTypeToDelete);
        }
    }

    private static final void refactorCreateNullLinkIndices$lambda-5(PersistentEntityStoreRefactorings this$0, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        for (String entityType : this$0.store.getEntityTypes((PersistentStoreTransaction)txn)) {
            PersistentEntityStoreRefactorings.Companion.logInfo("Refactoring creating null-value link indices for [" + entityType + ']');
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"entityType");
            this$0.safeExecuteRefactoringForEntityType(entityType, new StoreTransactionalExecutable(this$0, entityType){
                final /* synthetic */ PersistentEntityStoreRefactorings this$0;
                final /* synthetic */ String $entityType;
                {
                    this.this$0 = $receiver;
                    this.$entityType = $entityType;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(@NotNull StoreTransaction tx) {
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                    int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypeId(txn, this.$entityType, false);
                    LinksTable linksTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getLinksTable(txn, entityTypeId);
                    Intrinsics.checkNotNullExpressionValue((Object)linksTable, (String)"store.getLinksTable(txn, entityTypeId)");
                    LinksTable links = linksTable;
                    FieldIndex allLinksIndex = links.getAllLinksIndex();
                    Object object = txn.getEnvironmentTransaction();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"txn.environmentTransaction");
                    Transaction envTxn = object;
                    if (allLinksIndex.getStore().count(envTxn) > 0L) {
                        PersistentEntityStoreRefactorings.Companion.getLogger().warn("Refactoring creating null-value link indices looped for [" + this.$entityType + ']');
                        envTxn.getEnvironment().truncateStore(allLinksIndex.getStore().getName(), envTxn);
                        PersistentEntityStoreRefactorings.access$getStore$p((PersistentEntityStoreRefactorings)this.this$0).linksTables.remove(entityTypeId);
                        object = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getLinksTable(txn, entityTypeId);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"store.getLinksTable(txn, entityTypeId)");
                        links = object;
                        allLinksIndex = links.getAllLinksIndex();
                    }
                    Transaction readonlySnapshot = envTxn.getReadonlySnapshot();
                    try {
                        Cursor cursor = links.getSecondIndexCursor(readonlySnapshot);
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"links.getSecondIndexCursor(readonlySnapshot)");
                        Cursor cursor2 = cursor;
                        long total = links.getSecondaryCount(readonlySnapshot);
                        long done = 0L;
                        int prevLinkId = -1;
                        PersistentLongSet.MutableSet idSet2 = new PersistentLong23TreeSet().beginWrite();
                        String format = Intrinsics.stringPlus((String)"done %4.1f%% for ", (Object)this.$entityType);
                        while (cursor2.getNext()) {
                            PropertyKey linkKey = PropertyKey.entryToPropertyKey(cursor2.getValue());
                            int linkId = linkKey.getPropertyId();
                            long entityLocalId = linkKey.getEntityLocalId();
                            if (prevLinkId != linkId) {
                                if (prevLinkId == -1) {
                                    prevLinkId = linkId;
                                } else {
                                    if (linkId < prevLinkId) {
                                        throw new IllegalStateException("Unsorted index");
                                    }
                                    FieldIndex fieldIndex = allLinksIndex;
                                    Intrinsics.checkNotNullExpressionValue((Object)fieldIndex, (String)"allLinksIndex");
                                    double d = total;
                                    Intrinsics.checkNotNullExpressionValue((Object)idSet2, (String)"idSet");
                                    done = this.dumpSetAndFlush(format, fieldIndex, txn, d, done, prevLinkId, idSet2);
                                    prevLinkId = linkId;
                                }
                            }
                            idSet2.add(entityLocalId);
                        }
                        if (prevLinkId != -1) {
                            FieldIndex fieldIndex = allLinksIndex;
                            Intrinsics.checkNotNullExpressionValue((Object)fieldIndex, (String)"allLinksIndex");
                            double d = total;
                            Intrinsics.checkNotNullExpressionValue((Object)idSet2, (String)"idSet");
                            this.dumpSetAndFlush(format, fieldIndex, txn, d, done, prevLinkId, idSet2);
                        }
                        cursor2.close();
                    }
                    finally {
                        readonlySnapshot.abort();
                    }
                }

                private final long dumpSetAndFlush(String format, FieldIndex allLinksIndex, PersistentStoreTransaction txn, double total, long done, int prevLinkId, PersistentLongSet.MutableSet idSet2) {
                    long done2 = done;
                    LongIterator itr = idSet2.longIterator();
                    while (itr.hasNext()) {
                        Transaction transaction = txn.getEnvironmentTransaction();
                        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
                        allLinksIndex.put(transaction, prevLinkId, itr.nextLong());
                        long l = done2;
                        done2 = l + 1L;
                        if (done2 % (long)10000 == 0L) {
                            Object[] objectArray = new Object[]{(double)done2 * (double)100 / total};
                            String string = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                            jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, string);
                        }
                        if (done2 % (long)100000 != 0L || txn.flush()) continue;
                        throw new IllegalStateException("cannot flush");
                    }
                    idSet2.clear();
                    return done2;
                }
            });
        }
    }

    private static final void refactorDropEmptyPrimaryLinkTables$lambda-6(PersistentEntityStoreRefactorings this$0, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        for (String entityType : this$0.store.getEntityTypes((PersistentStoreTransaction)txn)) {
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"entityType");
            PersistentEntityStoreRefactorings.Companion.runReadonlyTransactionSafeForEntityType(entityType, (Function0<Unit>)((Function0)new Function0<Unit>(txn, this$0, entityType){
                final /* synthetic */ StoreTransaction $txn;
                final /* synthetic */ PersistentEntityStoreRefactorings this$0;
                final /* synthetic */ String $entityType;
                {
                    this.$txn = $txn;
                    this.this$0 = $receiver;
                    this.$entityType = $entityType;
                    super(0);
                }

                public final void invoke() {
                    Transaction transaction = ((PersistentStoreTransaction)this.$txn).getEnvironmentTransaction();
                    Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
                    Transaction envTxn = transaction;
                    int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypeId((PersistentStoreTransaction)this.$txn, this.$entityType, false);
                    LinksTable linksTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getLinksTable((PersistentStoreTransaction)this.$txn, entityTypeId);
                    Intrinsics.checkNotNullExpressionValue((Object)linksTable, (String)"store.getLinksTable(txn, entityTypeId)");
                    LinksTable linksTable2 = linksTable;
                    long primaryCount = linksTable2.getPrimaryCount(envTxn);
                    if (primaryCount != 0L && linksTable2.getSecondaryCount(envTxn) == 0L) {
                        PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEnvironment().executeInTransaction(arg_0 -> refactorDropEmptyPrimaryLinkTables.1.1.invoke$lambda-0(linksTable2, arg_0));
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Drop links' tables when primary index is empty for [" + this.$entityType + ']');
                    }
                }

                private static final void invoke$lambda-0(LinksTable $linksTable, Transaction txn) {
                    Intrinsics.checkNotNullParameter((Object)$linksTable, (String)"$linksTable");
                    Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
                    $linksTable.truncateFirst(txn);
                }
            }));
        }
    }

    private static final void refactorMakeLinkTablesConsistent$lambda-7(PersistentEntityStoreRefactorings this$0, Store $internalSettings, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$internalSettings, (String)"$internalSettings");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        for (String entityType : this$0.store.getEntityTypes((PersistentStoreTransaction)txn)) {
            PersistentEntityStoreRefactorings.Companion.logInfo("Refactoring making links' tables consistent for [" + entityType + ']');
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"entityType");
            PersistentEntityStoreRefactorings.Companion.runReadonlyTransactionSafeForEntityType(entityType, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, txn, entityType, $internalSettings){
                final /* synthetic */ PersistentEntityStoreRefactorings this$0;
                final /* synthetic */ StoreTransaction $txn;
                final /* synthetic */ String $entityType;
                final /* synthetic */ Store $internalSettings;
                {
                    this.this$0 = $receiver;
                    this.$txn = $txn;
                    this.$entityType = $entityType;
                    this.$internalSettings = $internalSettings;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    Object second;
                    Cursor cursor2;
                    ArrayList<kotlin.Pair> redundantLinks = new ArrayList<kotlin.Pair>();
                    ArrayList<kotlin.Pair> deleteLinks = new ArrayList<kotlin.Pair>();
                    int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypeId((PersistentStoreTransaction)this.$txn, this.$entityType, false);
                    LinksTable linksTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getLinksTable((PersistentStoreTransaction)this.$txn, entityTypeId);
                    Intrinsics.checkNotNullExpressionValue((Object)linksTable, (String)"store.getLinksTable(txn, entityTypeId)");
                    LinksTable linksTable2 = linksTable;
                    Transaction transaction = ((PersistentStoreTransaction)this.$txn).getEnvironmentTransaction();
                    Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
                    Transaction envTxn = transaction;
                    EntityIdSet entityIdSet = ((EntityIterableBase)this.$txn.getAll(this.$entityType)).toSet((PersistentStoreTransaction)this.$txn);
                    Intrinsics.checkNotNullExpressionValue((Object)entityIdSet, (String)"txn.getAll(entityType) a\u2026yIterableBase).toSet(txn)");
                    EntityIdSet all = entityIdSet;
                    PackedLongHashSet linkFilter = new PackedLongHashSet(null, 0.0f, 3, null);
                    IntHashSet redundantLinkTypes = new IntHashSet();
                    IntHashSet deletedLinkTypes = new IntHashSet();
                    IntHashSet deletedLinkIds = new IntHashSet();
                    Closeable closeable = (Closeable)linksTable2.getFirstIndexCursor(envTxn);
                    Object object = this.this$0;
                    StoreTransaction storeTransaction = this.$txn;
                    Throwable throwable = null;
                    try {
                        cursor2 = (Cursor)closeable;
                        boolean bl = false;
                        while (cursor2.getNext()) {
                            ByteIterable byteIterable = cursor2.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"cursor.key");
                            ByteIterable first = byteIterable;
                            ByteIterable byteIterable2 = cursor2.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)byteIterable2, (String)"cursor.value");
                            second = byteIterable2;
                            LinkValue linkValue = null;
                            long localId = LongBinding.compressedEntryToLong((ByteIterable)first);
                            if (!all.contains(entityTypeId, localId)) {
                                try {
                                    linkValue = LinkValue.entryToLinkValue(second);
                                    deletedLinkTypes.add(linkValue.getEntityId().getTypeId());
                                    deletedLinkIds.add(linkValue.getLinkId());
                                }
                                catch (ExodusException exodusException) {
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                                do {
                                    deleteLinks.add(TuplesKt.to((Object)new ArrayByteIterable(first), (Object)new ArrayByteIterable(second)));
                                } while (cursor2.getNextDup());
                                continue;
                            }
                            linkFilter.add(((long)first.hashCode() << 31) + (long)second.hashCode());
                            try {
                                linkValue = LinkValue.entryToLinkValue(second);
                            }
                            catch (ArrayIndexOutOfBoundsException ignore) {
                                deleteLinks.add(TuplesKt.to((Object)new ArrayByteIterable(first), (Object)new ArrayByteIterable(second)));
                            }
                            if (linkValue == null) continue;
                            EntityId entityId = linkValue.getEntityId();
                            Intrinsics.checkNotNullExpressionValue((Object)entityId, (String)"linkValue.entityId");
                            EntityId targetEntityId = entityId;
                            if (PersistentEntityStoreRefactorings.access$getStore$p((PersistentEntityStoreRefactorings)object).getLastVersion((PersistentStoreTransaction)storeTransaction, targetEntityId) < 0) {
                                deletedLinkTypes.add(targetEntityId.getTypeId());
                                deletedLinkIds.add(linkValue.getLinkId());
                                deleteLinks.add(TuplesKt.to((Object)new ArrayByteIterable(first), (Object)new ArrayByteIterable(second)));
                                continue;
                            }
                            linkFilter.add(((long)first.hashCode() << 31) + (long)second.hashCode());
                            if (linksTable2.contains2(envTxn, first, (ByteIterable)second)) continue;
                            redundantLinkTypes.add(targetEntityId.getTypeId());
                            redundantLinks.add(TuplesKt.to((Object)new ArrayByteIterable(first), (Object)new ArrayByteIterable(second)));
                        }
                        cursor2 = Unit.INSTANCE;
                    }
                    catch (Throwable cursor2) {
                        throwable = cursor2;
                        throw cursor2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (!((Collection)redundantLinks).isEmpty()) {
                        PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEnvironment().executeInExclusiveTransaction(arg_0 -> refactorMakeLinkTablesConsistent.1.1.invoke$lambda-1(redundantLinks, linksTable2, arg_0));
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, redundantLinks.size() + " missing links found for [" + this.$entityType + ']');
                        redundantLinks.clear();
                    }
                    closeable = (Closeable)linksTable2.getSecondIndexCursor(envTxn);
                    object = null;
                    try {
                        Cursor cursor3 = (Cursor)closeable;
                        boolean bl = false;
                        while (cursor3.getNext()) {
                            cursor2 = cursor3.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"cursor.key");
                            Cursor second2 = cursor2;
                            second = cursor3.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)second, (String)"cursor.value");
                            ByteIterable first = second;
                            if (linkFilter.contains((Object)(((long)first.hashCode() << 31) + (long)second2.hashCode())) || linksTable2.contains(envTxn, first, (ByteIterable)second2)) continue;
                            redundantLinks.add(TuplesKt.to((Object)new ArrayByteIterable(first), (Object)new ArrayByteIterable((ByteIterable)second2)));
                        }
                        cursor3 = Unit.INSTANCE;
                    }
                    catch (Throwable cursor3) {
                        object = cursor3;
                        throw cursor3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    int redundantLinksSize = redundantLinks.size();
                    int deleteLinksSize = deleteLinks.size();
                    if (redundantLinksSize > 0 || deleteLinksSize > 0) {
                        PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEnvironment().executeInExclusiveTransaction(arg_0 -> refactorMakeLinkTablesConsistent.1.1.invoke$lambda-3(redundantLinks, linksTable2, deleteLinks, arg_0));
                        if (PersistentEntityStoreRefactorings.Companion.getLogger().isInfoEnabled()) {
                            if (redundantLinksSize > 0) {
                                ArrayList<String> redundantLinkTypeNames = new ArrayList<String>(redundantLinkTypes.size());
                                for (Integer typeId : redundantLinkTypes) {
                                    PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0);
                                    PersistentStoreTransaction persistentStoreTransaction = (PersistentStoreTransaction)this.$txn;
                                    Intrinsics.checkNotNullExpressionValue((Object)typeId, (String)"typeId");
                                    redundantLinkTypeNames.add(persistentEntityStoreImpl.getEntityType(persistentStoreTransaction, (int)typeId));
                                }
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, redundantLinksSize + " redundant links found and fixed for [" + this.$entityType + "] and targets: " + redundantLinkTypeNames);
                            }
                            if (deleteLinksSize > 0) {
                                ArrayList<ByteIterable> deletedLinkTypeNames = new ArrayList<ByteIterable>(deletedLinkTypes.size());
                                for (Integer typeId : deletedLinkTypes) {
                                    try {
                                        PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0);
                                        PersistentStoreTransaction persistentStoreTransaction = (PersistentStoreTransaction)this.$txn;
                                        Intrinsics.checkNotNullExpressionValue((Object)typeId, (String)"typeId");
                                        second = persistentEntityStoreImpl.getEntityType(persistentStoreTransaction, (int)typeId);
                                        Intrinsics.checkNotNullExpressionValue((Object)second, (String)"store.getEntityType(txn, typeId)");
                                        Object entityTypeName = second;
                                        deletedLinkTypeNames.add((ByteIterable)entityTypeName);
                                    }
                                    catch (Throwable entityTypeName) {}
                                }
                                ArrayList<String> deletedLinkIdsNames = new ArrayList<String>(deletedLinkIds.size());
                                for (Integer typeId : deletedLinkIds) {
                                    try {
                                        PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0);
                                        PersistentStoreTransaction persistentStoreTransaction = (PersistentStoreTransaction)this.$txn;
                                        Intrinsics.checkNotNullExpressionValue((Object)typeId, (String)"typeId");
                                        String linkName = persistentEntityStoreImpl.getLinkName(persistentStoreTransaction, typeId);
                                        if (linkName == null) continue;
                                        boolean bl = false;
                                        deletedLinkIdsNames.add(linkName);
                                    }
                                    catch (Throwable throwable2) {}
                                }
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, deleteLinksSize + " phantom links found and fixed for [" + this.$entityType + "] and targets: " + deletedLinkTypeNames);
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, Intrinsics.stringPlus((String)"Link types: ", deletedLinkIdsNames));
                            }
                        }
                    }
                    Settings.delete(this.$internalSettings, "Link null-indices present");
                }

                private static final void invoke$lambda-1(ArrayList $redundantLinks, LinksTable $linksTable, Transaction txn) {
                    Intrinsics.checkNotNullParameter((Object)$redundantLinks, (String)"$redundantLinks");
                    Intrinsics.checkNotNullParameter((Object)$linksTable, (String)"$linksTable");
                    Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
                    for (kotlin.Pair badLink : $redundantLinks) {
                        $linksTable.put(txn, (ByteIterable)badLink.getFirst(), (ByteIterable)badLink.getSecond());
                    }
                }

                private static final void invoke$lambda-3(ArrayList $redundantLinks, LinksTable $linksTable, ArrayList $deleteLinks, Transaction txn) {
                    Cursor cursor;
                    Intrinsics.checkNotNullParameter((Object)$redundantLinks, (String)"$redundantLinks");
                    Intrinsics.checkNotNullParameter((Object)$linksTable, (String)"$linksTable");
                    Intrinsics.checkNotNullParameter((Object)$deleteLinks, (String)"$deleteLinks");
                    Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
                    for (kotlin.Pair redundantLink : $redundantLinks) {
                        cursor = $linksTable.getSecondIndexCursor(txn);
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"linksTable.getSecondIndexCursor(txn)");
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$deletePair(PersistentEntityStoreRefactorings.Companion, cursor, (ByteIterable)redundantLink.getFirst(), (ByteIterable)redundantLink.getSecond());
                    }
                    for (kotlin.Pair deleteLink : $deleteLinks) {
                        cursor = $linksTable.getFirstIndexCursor(txn);
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"linksTable.getFirstIndexCursor(txn)");
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$deletePair(PersistentEntityStoreRefactorings.Companion, cursor, (ByteIterable)deleteLink.getFirst(), (ByteIterable)deleteLink.getSecond());
                        cursor = $linksTable.getSecondIndexCursor(txn);
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"linksTable.getSecondIndexCursor(txn)");
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$deletePair(PersistentEntityStoreRefactorings.Companion, cursor, (ByteIterable)deleteLink.getSecond(), (ByteIterable)deleteLink.getFirst());
                    }
                }
            }));
        }
    }

    private static final void refactorMakePropTablesConsistent$lambda-8(PersistentEntityStoreRefactorings this$0, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        for (String entityType : this$0.store.getEntityTypes((PersistentStoreTransaction)txn)) {
            PersistentEntityStoreRefactorings.Companion.logInfo("Refactoring making props' tables consistent for [" + entityType + ']');
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"entityType");
            PersistentEntityStoreRefactorings.Companion.runReadonlyTransactionSafeForEntityType(entityType, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, txn, entityType){
                final /* synthetic */ PersistentEntityStoreRefactorings this$0;
                final /* synthetic */ StoreTransaction $txn;
                final /* synthetic */ String $entityType;
                {
                    this.this$0 = $receiver;
                    this.$txn = $txn;
                    this.$entityType = $entityType;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    Long localId;
                    ByteIterable sortedLocalIdSet;
                    Object object;
                    int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypeId((PersistentStoreTransaction)this.$txn, this.$entityType, false);
                    PropertiesTable propertiesTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getPropertiesTable((PersistentStoreTransaction)this.$txn, entityTypeId);
                    Intrinsics.checkNotNullExpressionValue((Object)propertiesTable, (String)"store.getPropertiesTable(txn, entityTypeId)");
                    PropertiesTable propTable = propertiesTable;
                    Transaction transaction = ((PersistentStoreTransaction)this.$txn).getEnvironmentTransaction();
                    Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
                    Transaction envTxn = transaction;
                    IntHashMap props = new IntHashMap();
                    EntityIdSet entityIdSet = ((EntityIterableBase)this.$txn.getAll(this.$entityType)).toSet((PersistentStoreTransaction)this.$txn);
                    Intrinsics.checkNotNullExpressionValue((Object)entityIdSet, (String)"txn.getAll(entityType) a\u2026yIterableBase).toSet(txn)");
                    EntityIdSet all = entityIdSet;
                    PropertyTypes propertyTypes = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getPropertyTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)propertyTypes, (String)"store.propertyTypes");
                    PropertyTypes propertyTypes2 = propertyTypes;
                    LongHashSet entitiesToDelete = new LongHashSet();
                    Closeable closeable = (Closeable)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getPrimaryPropertyIndexCursor((PersistentStoreTransaction)this.$txn, propTable);
                    Throwable throwable = null;
                    try {
                        Object cursor = (Cursor)closeable;
                        boolean bl = false;
                        while (cursor.getNext()) {
                            Map map;
                            PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                            long localId2 = propertyKey.getEntityLocalId();
                            if (!all.contains(entityTypeId, localId2)) {
                                entitiesToDelete.add(localId2);
                                continue;
                            }
                            PropertyValue propValue = propertyTypes2.entryToPropertyValue(cursor.getValue());
                            int propId = propertyKey.getPropertyId();
                            LongHashMap entitiesToValues = (LongHashMap)props.get(propId);
                            if (entitiesToValues == null) {
                                entitiesToValues = new LongHashMap(0, 0.0f, 3, null);
                                map = (Map)props;
                                object = propId;
                                map.put(object, entitiesToValues);
                            }
                            map = (Map)entitiesToValues;
                            object = localId2;
                            map.put(object, propValue);
                        }
                        cursor = Unit.INSTANCE;
                    }
                    catch (Throwable cursor) {
                        throwable = cursor;
                        throw cursor;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (!entitiesToDelete.isEmpty()) {
                        PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).executeInExclusiveTransaction(arg_0 -> refactorMakePropTablesConsistent.1.1.invoke$lambda-1(entitiesToDelete, this.this$0, entityTypeId, arg_0));
                    }
                    ArrayList<kotlin.Pair> missingPairs = new ArrayList<kotlin.Pair>();
                    IntHashMap allPropsMap = new IntHashMap();
                    for (Integer propId : props.keySet()) {
                        Store store;
                        PersistentStoreTransaction persistentStoreTransaction = (PersistentStoreTransaction)this.$txn;
                        Intrinsics.checkNotNullExpressionValue((Object)propId, (String)"propId");
                        Store store2 = store = propTable.getValueIndex(persistentStoreTransaction, propId, false);
                        Cursor valueCursor = store2 == null ? null : store2.openCursor(envTxn);
                        LongHashMap entitiesToValues = (LongHashMap)props.get(propId.intValue());
                        if (entitiesToValues != null) {
                            Long[] localIds;
                            boolean bl = false;
                            object = entitiesToValues.keySet();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entitiesToValues.keys");
                            Object localIdSet = object;
                            sortedLocalIdSet = new TreeSet((Collection)localIdSet);
                            ((Map)allPropsMap).put(propId, sortedLocalIdSet);
                            Collection $this$toTypedArray$iv232 = (Collection)sortedLocalIdSet;
                            int $i$f$toTypedArray = 0;
                            Collection thisCollection$iv = $this$toTypedArray$iv232;
                            if (thisCollection$iv.toArray(new Long[0]) == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                            }
                            int $this$toTypedArray$iv232 = 0;
                            $i$f$toTypedArray = localIds.length;
                            while ($this$toTypedArray$iv232 < $i$f$toTypedArray) {
                                localId = localIds[$this$toTypedArray$iv232];
                                ++$this$toTypedArray$iv232;
                                Object object2 = entitiesToValues.get((Object)localId);
                                if (object2 == null) {
                                    String string = "Required value was null.";
                                    throw new IllegalStateException(string.toString());
                                }
                                PropertyValue propValue = (PropertyValue)object2;
                                ByteIterable[] byteIterableArray = PropertiesTable.createSecondaryKeys(propertyTypes2, (ByteIterable)PropertyTypes.propertyValueToEntry(propValue), propValue.getType());
                                Intrinsics.checkNotNullExpressionValue((Object)byteIterableArray, (String)"createSecondaryKeys(\n   \u2026opValue), propValue.type)");
                                for (ByteIterable secondaryKey : byteIterableArray) {
                                    Intrinsics.checkNotNullExpressionValue((Object)localId, (String)"localId");
                                    ArrayByteIterable arrayByteIterable = LongBinding.longToCompressedEntry((long)localId);
                                    Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"longToCompressedEntry(localId)");
                                    ByteIterable secondaryValue = (ByteIterable)arrayByteIterable;
                                    if (valueCursor != null && valueCursor.getSearchBoth(secondaryKey, secondaryValue)) continue;
                                    missingPairs.add(TuplesKt.to((Object)propId, (Object)TuplesKt.to((Object)secondaryKey, (Object)secondaryValue)));
                                }
                            }
                        }
                        Cursor cursor = valueCursor;
                        if (cursor == null) continue;
                        cursor.close();
                    }
                    if (!((Collection)missingPairs).isEmpty()) {
                        PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).executeInExclusiveTransaction(arg_0 -> refactorMakePropTablesConsistent.1.1.invoke$lambda-3(missingPairs, propTable, arg_0));
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, missingPairs.size() + " missing secondary keys found and fixed for [" + this.$entityType + ']');
                    }
                    ArrayList<kotlin.Pair> phantomPairs = new ArrayList<kotlin.Pair>();
                    for (Map.Entry<Integer, Store> entry : propTable.getValueIndices()) {
                        Intrinsics.checkNotNullExpressionValue(entry, (String)"propTable.valueIndices");
                        Integer propId = entry.getKey();
                        Store value1 = entry.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)propId, (String)"propId");
                        if ((LongHashMap)props.get(propId.intValue()) == null) continue;
                        Cursor c = value1.openCursor(envTxn);
                        while (c.getNext()) {
                            LongHashMap entitiesToValues;
                            ByteIterable bl = c.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"c.key");
                            ByteIterable keyEntry = bl;
                            sortedLocalIdSet = c.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)sortedLocalIdSet, (String)"c.value");
                            ByteIterable valueEntry = sortedLocalIdSet;
                            PropertyValue propValue = (PropertyValue)entitiesToValues.get((Object)LongBinding.compressedEntryToLong((ByteIterable)valueEntry));
                            if (propValue != null) {
                                Comparable localIds = propValue.getData();
                                Intrinsics.checkNotNullExpressionValue((Object)localIds, (String)"propValue.data");
                                Comparable data = localIds;
                                int typeId = propValue.getType().getTypeId();
                                Class dataClass = null;
                                Long objectBinding = null;
                                if (typeId == 8) {
                                    dataClass = ((ComparableSet)data).getItemClass();
                                    if (dataClass == null) {
                                        phantomPairs.add(TuplesKt.to((Object)propId, (Object)TuplesKt.to((Object)new ArrayByteIterable(keyEntry), (Object)new ArrayByteIterable(valueEntry))));
                                        continue;
                                    }
                                    localId = propertyTypes2.getPropertyType(dataClass).getBinding();
                                    Intrinsics.checkNotNullExpressionValue((Object)localId, (String)"propertyTypes.getPropertyType(dataClass).binding");
                                    objectBinding = localId;
                                } else {
                                    dataClass = data.getClass();
                                    localId = propValue.getBinding();
                                    Intrinsics.checkNotNullExpressionValue((Object)localId, (String)"propValue.binding");
                                    objectBinding = localId;
                                }
                                try {
                                    Comparable value = objectBinding.entryToObject(keyEntry);
                                    if (Intrinsics.areEqual((Object)dataClass, value.getClass()) && (typeId == 8 ? ((ComparableSet)data).containsItem((Object)value) : PropertyTypes.toLowerCase(data).compareTo(value) == 0)) {
                                        continue;
                                    }
                                }
                                catch (Throwable t) {
                                    PersistentEntityStoreRefactorings.Companion.getLogger().error("Error reading property value index ", t);
                                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$throwJVMError(PersistentEntityStoreRefactorings.Companion, t);
                                }
                            }
                            phantomPairs.add(TuplesKt.to((Object)propId, (Object)TuplesKt.to((Object)new ArrayByteIterable(keyEntry), (Object)new ArrayByteIterable(valueEntry))));
                        }
                        c.close();
                    }
                    if (!((Collection)phantomPairs).isEmpty()) {
                        PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).executeInExclusiveTransaction(arg_0 -> refactorMakePropTablesConsistent.1.1.invoke$lambda-4(phantomPairs, propTable, arg_0));
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, phantomPairs.size() + " phantom secondary keys found and fixed for [" + this.$entityType + ']');
                    }
                    ArrayList<kotlin.Pair> phantomIds = new ArrayList<kotlin.Pair>();
                    Iterable<Pair<Integer, Long>> iterable2 = propTable.getAllPropsIndex().iterable(envTxn, 0);
                    boolean $i$f$forEach = false;
                    Iterator<Pair<Integer, Long>> iterator = iterable2.iterator();
                    while (iterator.hasNext()) {
                        Pair<Integer, Long> element$iv;
                        Pair<Integer, Long> pair = element$iv = iterator.next();
                        boolean bl = false;
                        Integer propId = (Integer)pair.getFirst();
                        Long localId3 = (Long)pair.getSecond();
                        Intrinsics.checkNotNullExpressionValue((Object)propId, (String)"propId");
                        Set localIds = (Set)allPropsMap.get(propId.intValue());
                        if (localIds == null || !localIds.remove(localId3)) {
                            phantomIds.add(new kotlin.Pair((Object)propId, (Object)localId3));
                            continue;
                        }
                        if (!localIds.isEmpty()) continue;
                        allPropsMap.remove(propId.intValue());
                    }
                    if (!allPropsMap.isEmpty()) {
                        Integer n = (Integer)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).computeInExclusiveTransaction(arg_0 -> refactorMakePropTablesConsistent.1.1.invoke$lambda-6(propTable, allPropsMap, arg_0));
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, n + " missing id pairs found and fixed for [" + this.$entityType + ']');
                    }
                    if (!((Collection)phantomIds).isEmpty()) {
                        PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).executeInExclusiveTransaction(arg_0 -> refactorMakePropTablesConsistent.1.1.invoke$lambda-8(phantomIds, propTable, arg_0));
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, phantomIds.size() + " phantom id pairs found and fixed for [" + this.$entityType + ']');
                    }
                }

                private static final void invoke$lambda-1(LongHashSet $entitiesToDelete, PersistentEntityStoreRefactorings this$0, int $entityTypeId, StoreTransaction txn) {
                    Intrinsics.checkNotNullParameter((Object)$entitiesToDelete, (String)"$entitiesToDelete");
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
                    PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
                    for (Long localId : $entitiesToDelete) {
                        PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this$0);
                        PersistentStoreTransaction persistentStoreTransaction = (PersistentStoreTransaction)txn;
                        PersistentEntityStoreImpl persistentEntityStoreImpl2 = PersistentEntityStoreRefactorings.access$getStore$p(this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)localId, (String)"localId");
                        persistentEntityStoreImpl.deleteEntity(persistentStoreTransaction, new PersistentEntity(persistentEntityStoreImpl2, new PersistentEntityId($entityTypeId, localId)));
                    }
                }

                private static final void invoke$lambda-3(ArrayList $missingPairs, PropertiesTable $propTable, StoreTransaction tx) {
                    Intrinsics.checkNotNullParameter((Object)$missingPairs, (String)"$missingPairs");
                    Intrinsics.checkNotNullParameter((Object)$propTable, (String)"$propTable");
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                    for (kotlin.Pair pair : $missingPairs) {
                        Store valueIndex = $propTable.getValueIndex(txn, ((Number)pair.getFirst()).intValue(), true);
                        kotlin.Pair missing = (kotlin.Pair)pair.getSecond();
                        if (valueIndex == null) {
                            throw new NullPointerException("Can't be");
                        }
                        valueIndex.put(txn.getEnvironmentTransaction(), (ByteIterable)missing.getFirst(), (ByteIterable)missing.getSecond());
                    }
                }

                private static final void invoke$lambda-4(ArrayList $phantomPairs, PropertiesTable $propTable, StoreTransaction tx) {
                    Intrinsics.checkNotNullParameter((Object)$phantomPairs, (String)"$phantomPairs");
                    Intrinsics.checkNotNullParameter((Object)$propTable, (String)"$propTable");
                    Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
                    PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                    Transaction transaction = txn.getEnvironmentTransaction();
                    Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
                    Transaction envTxn = transaction;
                    for (kotlin.Pair pair : $phantomPairs) {
                        Store valueIndex = $propTable.getValueIndex(txn, ((Number)pair.getFirst()).intValue(), true);
                        kotlin.Pair phantom = (kotlin.Pair)pair.getSecond();
                        if (valueIndex == null) {
                            throw new NullPointerException("Can't be");
                        }
                        Cursor cursor = valueIndex.openCursor(envTxn);
                        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"valueIndex.openCursor(envTxn)");
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$deletePair(PersistentEntityStoreRefactorings.Companion, cursor, (ByteIterable)phantom.getFirst(), (ByteIterable)phantom.getSecond());
                    }
                }

                private static final Integer invoke$lambda-6(PropertiesTable $propTable, IntHashMap $allPropsMap, StoreTransaction txn) {
                    Intrinsics.checkNotNullParameter((Object)$propTable, (String)"$propTable");
                    Intrinsics.checkNotNullParameter((Object)$allPropsMap, (String)"$allPropsMap");
                    Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
                    int count = 0;
                    FieldIndex allPropsIndex = $propTable.getAllPropsIndex();
                    Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
                    Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn as PersistentStoreTr\u2026n).environmentTransaction");
                    Transaction envTxn = transaction;
                    for (Map.Entry entry : ((Map)$allPropsMap).entrySet()) {
                        Integer key = (Integer)entry.getKey();
                        Set value = (Set)entry.getValue();
                        Iterator<E> iterator = value.iterator();
                        while (iterator.hasNext()) {
                            long localId = ((Number)iterator.next()).longValue();
                            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                            allPropsIndex.put(envTxn, key, localId);
                            ++count;
                        }
                    }
                    return count;
                }

                private static final void invoke$lambda-8(ArrayList $phantomIds, PropertiesTable $propTable, StoreTransaction txn) {
                    Intrinsics.checkNotNullParameter((Object)$phantomIds, (String)"$phantomIds");
                    Intrinsics.checkNotNullParameter((Object)$propTable, (String)"$propTable");
                    Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
                    Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
                    Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn as PersistentStoreTr\u2026n).environmentTransaction");
                    Transaction envTxn = transaction;
                    Iterable $this$forEach$iv = $phantomIds;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        kotlin.Pair phantom = (kotlin.Pair)element$iv;
                        boolean bl = false;
                        $propTable.getAllPropsIndex().remove(envTxn, ((Number)phantom.getFirst()).intValue(), ((Number)phantom.getSecond()).longValue());
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void refactorFixNegativeFloatAndDoubleProps$lambda-15$lambda-14(String $entityType, Store $settings, PersistentEntityStoreRefactorings this$0, StoreTransaction t) {
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        PersistentStoreTransaction txn = (PersistentStoreTransaction)t;
        String settingName = "refactorFixNegativeFloatAndDoubleProps(" + $entityType + ") applied";
        if (Intrinsics.areEqual((Object)Settings.get(txn.getEnvironmentTransaction(), $settings, settingName), (Object)"y")) {
            return;
        }
        PersistentEntityStoreRefactorings.Companion.logInfo("Refactoring fixing negative float & double props for [" + $entityType + ']');
        int entityTypeId = this$0.store.getEntityTypeId(txn, $entityType, false);
        PropertiesTable propertiesTable = this$0.store.getPropertiesTable(txn, entityTypeId);
        Intrinsics.checkNotNullExpressionValue((Object)propertiesTable, (String)"store.getPropertiesTable(txn, entityTypeId)");
        PropertiesTable propTable = propertiesTable;
        HashMap props = new HashMap();
        Set set = this$0.store.getPropertyTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"store.propertyTypes");
        PropertyTypes propertyTypes = set;
        set = (Closeable)this$0.store.getPrimaryPropertyIndexCursor(txn, propTable);
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)set;
            boolean bl = false;
            while (cursor.getNext()) {
                try {
                    ArrayByteIterable it = new ArrayByteIterable(cursor.getValue());
                    boolean bl2 = false;
                    ComparableValueType comparableValueType = propertyTypes.getPropertyType((byte)(it.iterator().next() ^ 0xFFFFFF80));
                    Intrinsics.checkNotNullExpressionValue((Object)comparableValueType, (String)"propertyTypes.getPropert\u2026(0x80).toByte()).toInt())");
                    ComparableValueType propertyType = comparableValueType;
                    switch (propertyType.getTypeId()) {
                        case 7: {
                            Map map = props;
                            PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                            Intrinsics.checkNotNullExpressionValue((Object)propertyKey, (String)"entryToPropertyKey(cursor.key)");
                            map.put(propertyKey, TuplesKt.to((Object)propertyTypes.entryToPropertyValue((ByteIterable)it, (ComparableBinding)FloatBinding.BINDING), (Object)it));
                            break;
                        }
                        case 3: {
                            Map map = props;
                            PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                            Intrinsics.checkNotNullExpressionValue((Object)propertyKey, (String)"entryToPropertyKey(cursor.key)");
                            map.put(propertyKey, TuplesKt.to((Object)propertyTypes.entryToPropertyValue((ByteIterable)it, (ComparableBinding)DoubleBinding.BINDING), (Object)it));
                        }
                    }
                }
                catch (Throwable throwable2) {}
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)((Object)set), (Throwable)throwable);
        }
        if (!((Map)props).isEmpty()) {
            void $this$forEach$iv;
            set = props.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"props.keys");
            Iterable $this$sortedBy$iv = set;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PropertyKey it = (PropertyKey)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getEntityLocalId());
                    it = (PropertyKey)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getEntityLocalId()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                kotlin.Pair $dstr$propValue$it;
                PropertyKey key = (PropertyKey)element$iv;
                boolean bl = false;
                if ((kotlin.Pair)props.get(key) == null) continue;
                boolean bl3 = false;
                PropertyValue propValue = (PropertyValue)$dstr$propValue$it.component1();
                ByteIterable it = (ByteIterable)$dstr$propValue$it.component2();
                propTable.put(txn, key.getEntityLocalId(), (ByteIterable)PropertyTypes.propertyValueToEntry(propValue), it, key.getPropertyId(), propValue.getType());
            }
            PersistentEntityStoreRefactorings.Companion.logInfo(props.size() + " negative float & double props fixed.");
        }
        Settings.set(txn.getEnvironmentTransaction(), $settings, settingName, "y");
    }

    private static final void refactorFixNegativeFloatAndDoubleProps$lambda-15(PersistentEntityStoreRefactorings this$0, Store $settings, StoreTransaction tx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        List<String> list = this$0.store.getEntityTypes((PersistentStoreTransaction)tx);
        Intrinsics.checkNotNullExpressionValue(list, (String)"store.getEntityTypes(tx \u2026rsistentStoreTransaction)");
        for (String entityType : CollectionsKt.toList((Iterable)list)) {
            this$0.store.executeInTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorFixNegativeFloatAndDoubleProps$lambda-15$lambda-14(entityType, $settings, this$0, arg_0));
        }
    }

    private static final void refactorBlobsToVersion2Format$dumpInPlaceBlobs$lambda-17(PersistentEntityStoreRefactorings this$0, int $entityTypeId, List $inPlaceBlobs, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$inPlaceBlobs, (String)"$inPlaceBlobs");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        BlobsTable blobsTable = this$0.store.getBlobsTable((PersistentStoreTransaction)txn, $entityTypeId);
        Intrinsics.checkNotNullExpressionValue((Object)blobsTable, (String)"store.getBlobsTable(txn, entityTypeId)");
        BlobsTable blobsTable2 = blobsTable;
        Iterable $this$forEach$iv = $inPlaceBlobs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            kotlin.Pair $dstr$blobKey$it = (kotlin.Pair)element$iv;
            boolean bl = false;
            PropertyKey blobKey = (PropertyKey)$dstr$blobKey$it.component1();
            ArrayByteIterable it = (ArrayByteIterable)$dstr$blobKey$it.component2();
            ByteIterable[] byteIterableArray = new ByteIterable[]{this$0.store.blobHandleToEntry(0x7FFFFFFFFFFFFFFEL), (ByteIterable)it};
            blobsTable2.put(((PersistentStoreTransaction)txn).getEnvironmentTransaction(), blobKey.getEntityLocalId(), blobKey.getPropertyId(), (ByteIterable)new CompoundByteIterable(byteIterableArray));
        }
    }

    private static final void refactorBlobsToVersion2Format$dumpInPlaceBlobs(PersistentEntityStoreRefactorings this$0, int entityTypeId, List<? extends kotlin.Pair<PropertyKey, ? extends ArrayByteIterable>> inPlaceBlobs) {
        this$0.store.executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorBlobsToVersion2Format$dumpInPlaceBlobs$lambda-17(this$0, entityTypeId, inPlaceBlobs, arg_0));
    }

    private static final void refactorBlobsToVersion2Format$lambda-22$lambda-20(PersistentEntityStoreRefactorings this$0, int $entityTypeId, ArrayList $blobHandles, BlobsTable $oldBlobsTable, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$blobHandles, (String)"$blobHandles");
        Intrinsics.checkNotNullParameter((Object)$oldBlobsTable, (String)"$oldBlobsTable");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        Object object = this$0.store.getBlobsTable((PersistentStoreTransaction)txn, $entityTypeId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"store.getBlobsTable(txn, entityTypeId)");
        BlobsTable blobsTable = object;
        Iterable $this$forEach$iv = $blobHandles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            kotlin.Pair $dstr$blobKey$handle = (kotlin.Pair)element$iv;
            boolean bl = false;
            PropertyKey blobKey = (PropertyKey)$dstr$blobKey$handle.component1();
            long handle = ((Number)$dstr$blobKey$handle.component2()).longValue();
            blobsTable.put(((PersistentStoreTransaction)txn).getEnvironmentTransaction(), blobKey.getEntityLocalId(), blobKey.getPropertyId(), this$0.store.blobHandleToEntry(handle));
        }
        object = $oldBlobsTable.getPrimaryIndex().getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"oldBlobsTable.primaryIndex.name");
        Object object2 = object;
        object = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"txn.environmentTransaction");
        this$0.safeRemoveStore((String)object2, (Transaction)object);
        object = $oldBlobsTable.getAllBlobsIndex().getStore().getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"oldBlobsTable.allBlobsIndex.getStore().name");
        Object object3 = object;
        object = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"txn.environmentTransaction");
        this$0.safeRemoveStore((String)object3, (Transaction)object);
    }

    private static final void refactorBlobsToVersion2Format$lambda-22$lambda-21(Store $settings, String $settingName, Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        Intrinsics.checkNotNullParameter((Object)$settingName, (String)"$settingName");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Settings.set(txn, $settings, $settingName, "y");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refactorBlobsToVersion2Format$lambda-22(PersistentEntityStoreRefactorings this$0, Store $settings, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        List<String> list = this$0.store.getEntityTypes((PersistentStoreTransaction)txn);
        Intrinsics.checkNotNullExpressionValue(list, (String)"store.getEntityTypes(txn\u2026rsistentStoreTransaction)");
        for (String entityType : CollectionsKt.toList((Iterable)list)) {
            String settingName = "refactorBlobsToVersion2Format(" + entityType + ')';
            Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
            Transaction envTxn = transaction;
            if (Intrinsics.areEqual((Object)Settings.get(envTxn, $settings, settingName), (Object)"y")) continue;
            int entityTypeId = this$0.store.getEntityTypeId((PersistentStoreTransaction)txn, entityType, false);
            String string = this$0.store.getNamingRules().getBlobsObsoleteTableName(entityTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"store.namingRules.getBlo\u2026teTableName(entityTypeId)");
            String blobsObsoleteTableName = string;
            if (!this$0.store.getEnvironment().storeExists(blobsObsoleteTableName, envTxn)) continue;
            PersistentEntityStoreRefactorings.Companion.logInfo("Refactor blobs to version 2 format for [" + entityType + ']');
            ArrayList<kotlin.Pair> inPlaceBlobs = new ArrayList<kotlin.Pair>();
            ArrayList<kotlin.Pair> blobHandles = new ArrayList<kotlin.Pair>();
            BlobsTable oldBlobsTable = new BlobsTable(this$0.store, (PersistentStoreTransaction)txn, blobsObsoleteTableName, StoreConfig.USE_EXISTING);
            Closeable closeable = (Closeable)oldBlobsTable.getPrimaryIndex().openCursor(envTxn);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                while (cursor.getNext()) {
                    try {
                        PropertyKey blobKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                        ByteIterator it = cursor.getValue().iterator();
                        long blobHandle = LongBinding.readCompressed((ByteIterator)it);
                        if (blobHandle == 0x7FFFFFFFFFFFFFFEL) {
                            inPlaceBlobs.add(TuplesKt.to((Object)blobKey, (Object)new ArrayByteIterable(it)));
                            if (inPlaceBlobs.size() <= 100) continue;
                            PersistentEntityStoreRefactorings.refactorBlobsToVersion2Format$dumpInPlaceBlobs(this$0, entityTypeId, (List<? extends kotlin.Pair<PropertyKey, ? extends ArrayByteIterable>>)inPlaceBlobs);
                            inPlaceBlobs.clear();
                            continue;
                        }
                        blobHandles.add(TuplesKt.to((Object)blobKey, (Object)blobHandle));
                    }
                    catch (Throwable t) {
                        Companion.getLogger().error(Intrinsics.stringPlus((String)settingName, (Object)": error reading blobs"), t);
                        PersistentEntityStoreRefactorings.Companion.throwJVMError(t);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (!((Collection)inPlaceBlobs).isEmpty()) {
                PersistentEntityStoreRefactorings.refactorBlobsToVersion2Format$dumpInPlaceBlobs(this$0, entityTypeId, (List<? extends kotlin.Pair<PropertyKey, ? extends ArrayByteIterable>>)inPlaceBlobs);
            }
            this$0.store.executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorBlobsToVersion2Format$lambda-22$lambda-20(this$0, entityTypeId, blobHandles, oldBlobsTable, arg_0));
            this$0.store.getEnvironment().executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorBlobsToVersion2Format$lambda-22$lambda-21($settings, settingName, arg_0));
        }
    }

    private static final void refactorEntitiesTablesToBitmap$dumpEntitiesAndFlush$lambda-24(PersistentEntityStoreRefactorings this$0, String $tableName, LongArrayList $entityIds, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$tableName, (String)"$tableName");
        Intrinsics.checkNotNullParameter((Object)$entityIds, (String)"$entityIds");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        Bitmap bitmap = this$0.store.getEnvironment().openBitmap($tableName, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, ((PersistentStoreTransaction)txn).getEnvironmentTransaction());
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"store.environment.openBi\u2026saction\n                )");
        Bitmap entityOfTypeBitmap = bitmap;
        SingleColumnTable oldEntitiesTable = new SingleColumnTable((PersistentStoreTransaction)txn, $tableName, StoreConfig.USE_EXISTING);
        Object object = $entityIds.toArray();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entityIds.toArray()");
        long[] $this$forEach$iv = object;
        boolean $i$f$forEach = false;
        for (long element$iv : $this$forEach$iv) {
            long id = element$iv;
            boolean bl = false;
            entityOfTypeBitmap.set(((PersistentStoreTransaction)txn).getEnvironmentTransaction(), id, true);
        }
        object = oldEntitiesTable.getDatabase().getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"oldEntitiesTable.database.name");
        Object object2 = object;
        object = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"txn.environmentTransaction");
        this$0.safeRemoveStore((String)object2, (Transaction)object);
    }

    private static final void refactorEntitiesTablesToBitmap$dumpEntitiesAndFlush(PersistentEntityStoreRefactorings this$0, String tableName, LongArrayList entityIds) {
        this$0.store.executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorEntitiesTablesToBitmap$dumpEntitiesAndFlush$lambda-24(this$0, tableName, entityIds, arg_0));
    }

    private static final void refactorEntitiesTablesToBitmap$lambda-27$lambda-26(Store $settings, String $settingName, Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        Intrinsics.checkNotNullParameter((Object)$settingName, (String)"$settingName");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Settings.set(txn, $settings, $settingName, "y");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refactorEntitiesTablesToBitmap$lambda-27(PersistentEntityStoreRefactorings this$0, Store $settings, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        List<String> list = this$0.store.getEntityTypes((PersistentStoreTransaction)txn);
        Intrinsics.checkNotNullExpressionValue(list, (String)"store.getEntityTypes(txn\u2026rsistentStoreTransaction)");
        for (String entityType : CollectionsKt.toList((Iterable)list)) {
            String settingName = "refactorEntitiesTablesToBitmap(" + entityType + ')';
            Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
            Transaction envTxn = transaction;
            if (Intrinsics.areEqual((Object)Settings.get(envTxn, $settings, settingName), (Object)"y")) continue;
            int entityTypeId = this$0.store.getEntityTypeId((PersistentStoreTransaction)txn, entityType, false);
            String string = this$0.store.getNamingRules().getEntitiesTableName(entityTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"store.namingRules.getEnt\u2026esTableName(entityTypeId)");
            String obsoleteTableName = string;
            if (!this$0.store.getEnvironment().storeExists(obsoleteTableName, envTxn)) continue;
            PersistentEntityStoreRefactorings.Companion.logInfo("Refactor entities of [" + entityType + "] type table to bitmap");
            LongArrayList entityIds = new LongArrayList();
            Closeable closeable = (Closeable)new SingleColumnTable((PersistentStoreTransaction)txn, obsoleteTableName, StoreConfig.USE_EXISTING).getDatabase().openCursor(envTxn);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)closeable;
                boolean bl = false;
                while (cursor.getNext()) {
                    entityIds.add(LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey()));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (!entityIds.isEmpty()) {
                PersistentEntityStoreRefactorings.refactorEntitiesTablesToBitmap$dumpEntitiesAndFlush(this$0, obsoleteTableName, entityIds);
            }
            this$0.store.getEnvironment().executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorEntitiesTablesToBitmap$lambda-27$lambda-26($settings, settingName, arg_0));
        }
    }

    private static final void refactorDeduplicateInPlaceBlobsPeriodically$lambda-28(PersistentEntityStoreRefactorings this$0, Store $settings) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        this$0.refactorDeduplicateInPlaceBlobs($settings);
    }

    private static final Store refactorDeduplicateInPlaceBlobs$lambda-29(Environment $env, Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)$env, (String)"$env");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return $env.openStore("TestSettings", StoreConfig.WITHOUT_DUPLICATES, txn);
    }

    private static final void refactorDeduplicateInPlaceBlobs$lambda-35$lambda-33$lambda-32$lambda-31$lambda-30(PersistentEntityStoreRefactorings this$0, int $entityTypeId, int $streamHash, ByteArraySizedInputStream $stream, int $size, BlobsTable $blobs, PropertyKey $key, PropertyKey $blobKey, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$stream, (String)"$stream");
        Intrinsics.checkNotNullParameter((Object)$blobs, (String)"$blobs");
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        SingleColumnTable singleColumnTable = this$0.store.getBlobHashesTable((PersistentStoreTransaction)txn, $entityTypeId);
        Intrinsics.checkNotNullExpressionValue((Object)singleColumnTable, (String)"store.getBlobHashesTable\u2026                        )");
        SingleColumnTable blobHashes = singleColumnTable;
        ArrayByteIterable hashEntry = IntegerBinding.intToEntry((int)$streamHash);
        Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
        Transaction envTxn = transaction;
        blobHashes.getDatabase().put(envTxn, (ByteIterable)hashEntry, (ByteIterable)new ArrayByteIterable($stream.toByteArray(), $size));
        ByteIterable[] byteIterableArray = new ByteIterable[]{this$0.store.blobHandleToEntry(0x7FFFFFFFFFFFFFFDL), CompressedUnsignedLongByteIterable.getIterable((long)$size), (ByteIterable)hashEntry};
        CompoundByteIterable refValue = new CompoundByteIterable(byteIterableArray);
        $blobs.put(envTxn, $key.getEntityLocalId(), $key.getPropertyId(), (ByteIterable)refValue);
        $blobs.put(envTxn, $blobKey.getEntityLocalId(), $blobKey.getPropertyId(), (ByteIterable)refValue);
    }

    private static final void refactorDeduplicateInPlaceBlobs$lambda-35$lambda-34(Store $settings, String $settingName, Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        Intrinsics.checkNotNullParameter((Object)$settingName, (String)"$settingName");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Settings.set(txn, $settings, $settingName, String.valueOf(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refactorDeduplicateInPlaceBlobs$lambda-35(PersistentEntityStoreRefactorings this$0, Store $settings, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentEntityStoreConfig persistentEntityStoreConfig = this$0.store.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)persistentEntityStoreConfig, (String)"store.config");
        PersistentEntityStoreConfig config = persistentEntityStoreConfig;
        List<String> list = this$0.store.getEntityTypes((PersistentStoreTransaction)txn);
        Intrinsics.checkNotNullExpressionValue(list, (String)"store.getEntityTypes(txn\u2026rsistentStoreTransaction)");
        for (String entityType : CollectionsKt.toList((Iterable)list)) {
            long l;
            String lastApplied;
            String settingName = "refactorDeduplicateInPlaceBlobs(" + entityType + ") applied";
            Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
            Transaction envTxn = transaction;
            String string = lastApplied = Settings.get(envTxn, $settings, settingName);
            if ((string == null ? 0L : (l = Long.parseLong(string))) + (long)config.getRefactoringDeduplicateBlobsEvery() * 24L * 3600L * 1000L > System.currentTimeMillis()) continue;
            PersistentEntityStoreRefactorings.Companion.logInfo("Deduplicate in-place blobs for [" + entityType + ']');
            int entityTypeId = this$0.store.getEntityTypeId((PersistentStoreTransaction)txn, entityType, false);
            IntHashMap inPlaceBlobs = new IntHashMap();
            Object object = this$0.store.getBlobsTable((PersistentStoreTransaction)txn, entityTypeId);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"store.getBlobsTable(txn, entityTypeId)");
            BlobsTable blobs = object;
            object = (Closeable)blobs.getPrimaryIndex().openCursor(envTxn);
            Throwable throwable = null;
            try {
                Cursor cursor = (Cursor)object;
                boolean bl = false;
                while (cursor.getNext()) {
                    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"jetbrains/exodus/entitystore/PersistentEntityStoreRefactorings$refactorDeduplicateInPlaceBlobs$DuplicateFoundException", "Ljetbrains/exodus/ExodusException;", "()V", "xodus-entity-store"})
                    public final class DuplicateFoundException
                    extends ExodusException {
                        public DuplicateFoundException() {
                        }
                    }
                    try {
                        int size;
                        PropertyKey blobKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                        ByteIterator it = cursor.getValue().iterator();
                        long blobHandle = LongBinding.readCompressed((ByteIterator)it);
                        if (blobHandle != 1L || (size = (int)CompressedUnsignedLongByteIterable.getLong((ByteIterator)it)) < config.getRefactoringDeduplicateBlobsMinSize()) continue;
                        ByteArraySizedInputStream stream = new ByteArraySizedInputStream(ByteIterableBase.readIterator((ByteIterator)it, (int)size));
                        int streamHash = stream.hashCode();
                        if ((PropertyKey)inPlaceBlobs.get(streamHash) != null) {
                            PropertyKey key;
                            ByteIterable testValue;
                            boolean bl2 = false;
                            ByteIterable byteIterable = testValue = blobs.get(envTxn, key);
                            if (byteIterable != null && byteIterable.iterator() != null) {
                                ByteIterator testIt;
                                boolean bl3 = false;
                                LongBinding.readCompressed((ByteIterator)testIt);
                                if (size == (int)CompressedUnsignedLongByteIterable.getLong((ByteIterator)testIt) && Intrinsics.areEqual((Object)stream, (Object)new ByteArraySizedInputStream(ByteIterableBase.readIterator((ByteIterator)testIt, (int)size)))) {
                                    this$0.store.executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorDeduplicateInPlaceBlobs$lambda-35$lambda-33$lambda-32$lambda-31$lambda-30(this$0, entityTypeId, streamHash, stream, size, blobs, key, blobKey, arg_0));
                                    throw new DuplicateFoundException();
                                }
                            }
                        }
                        inPlaceBlobs.putIfAbsent((Object)streamHash, (Object)blobKey);
                    }
                    catch (DuplicateFoundException blobKey) {
                    }
                    catch (Throwable t) {
                        Companion.getLogger().error("refactorDeduplicateInPlaceBlobs(): error reading blobs for [" + entityType + ']', t);
                        PersistentEntityStoreRefactorings.Companion.throwJVMError(t);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            this$0.store.getEnvironment().executeInExclusiveTransaction(arg_0 -> PersistentEntityStoreRefactorings.refactorDeduplicateInPlaceBlobs$lambda-35$lambda-34($settings, settingName, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void refactorAllIdxToBitmap$lambda-38$lambda-37(String $obsoleteName, PersistentEntityStoreRefactorings this$0, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)$obsoleteName, (String)"$obsoleteName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
        Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"txn.environmentTransaction");
        Transaction envTxn = transaction;
        Object object = envTxn.getEnvironment().openBitmap($obsoleteName, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, envTxn);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"envTxn.environment.openB\u2026S_WITH_PREFIXING, envTxn)");
        Bitmap allPropsIndexBitmap = object;
        object = (Closeable)envTxn.getEnvironment().openStore($obsoleteName, StoreConfig.USE_EXISTING, envTxn).openCursor(envTxn);
        Throwable throwable = null;
        try {
            Cursor c = (Cursor)object;
            boolean bl = false;
            while (c.getNext()) {
                int propertyId = IntegerBinding.compressedEntryToInt((ByteIterable)c.getKey());
                long localId = LongBinding.compressedEntryToLong((ByteIterable)c.getValue());
                allPropsIndexBitmap.set(envTxn, ((long)propertyId << 32) + localId, true);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        this$0.safeRemoveStore($obsoleteName, envTxn);
    }

    private static final void refactorAllIdxToBitmap$lambda-38(PersistentEntityStoreRefactorings this$0, Function1 $getIndexName, String $indexName, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$getIndexName, (String)"$getIndexName");
        Intrinsics.checkNotNullParameter((Object)$indexName, (String)"$indexName");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        for (String entityType : this$0.store.getEntityTypes((PersistentStoreTransaction)txn)) {
            int entityTypeId = this$0.store.getEntityTypeId((PersistentStoreTransaction)txn, entityType, false);
            String obsoleteName = (String)$getIndexName.invoke((Object)entityTypeId);
            if (!this$0.store.getEnvironment().storeExists(obsoleteName, ((PersistentStoreTransaction)txn).getEnvironmentTransaction())) continue;
            PersistentEntityStoreRefactorings.Companion.logInfo("Refactoring " + $indexName + " to bitmaps for [" + entityType + ']');
            Intrinsics.checkNotNullExpressionValue((Object)entityType, (String)"entityType");
            this$0.safeExecuteRefactoringForEntityType(entityType, arg_0 -> PersistentEntityStoreRefactorings.refactorAllIdxToBitmap$lambda-38$lambda-37(obsoleteName, this$0, arg_0));
        }
    }

    private static final List safeExecuteRefactoringForEachEntityType$lambda-39(PersistentEntityStoreRefactorings this$0, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return this$0.store.getEntityTypes((PersistentStoreTransaction)txn);
    }

    private static final void safeExecuteRefactoringForEachEntityType$lambda-40(Function2 $executable, String $entityType, StoreTransaction txn) {
        Intrinsics.checkNotNullParameter((Object)$executable, (String)"$executable");
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Intrinsics.checkNotNullExpressionValue((Object)$entityType, (String)"entityType");
        $executable.invoke((Object)$entityType, (Object)((PersistentStoreTransaction)txn));
    }

    public static final /* synthetic */ PersistentEntityStoreImpl access$getStore$p(PersistentEntityStoreRefactorings $this) {
        return $this.store;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/entitystore/PersistentEntityStoreRefactorings$Companion;", "Lmu/KLogging;", "()V", "deletePair", "", "c", "Ljetbrains/exodus/env/Cursor;", "key", "Ljetbrains/exodus/ByteIterable;", "value", "logInfo", "message", "", "runReadonlyTransactionSafeForEntityType", "entityType", "action", "Lkotlin/Function0;", "throwJVMError", "t", "", "xodus-entity-store"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        private final void runReadonlyTransactionSafeForEntityType(String entityType, Function0<Unit> action) {
            try {
                action.invoke();
            }
            catch (ReadonlyTransactionException readonlyTransactionException) {
            }
            catch (Throwable t) {
                this.getLogger().error(Intrinsics.stringPlus((String)"Failed to execute refactoring for entity type: ", (Object)entityType), t);
                this.throwJVMError(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void deletePair(Cursor c, ByteIterable key, ByteIterable value) {
            Closeable closeable = (Closeable)c;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl = false;
                if (c.getSearchBoth(key, value)) {
                    c.deleteCurrent();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final void throwJVMError(Throwable t) {
            if (t instanceof VirtualMachineError) {
                throw new EntityStoreException(t);
            }
        }

        private final void logInfo(String message) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(message);
            }
        }

        public static final /* synthetic */ void access$deletePair(Companion $this, Cursor c, ByteIterable key, ByteIterable value) {
            $this.deletePair(c, key, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

