/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.index;

import java.util.ArrayList;
import v14.h2.command.dml.AllColumnsForPlan;
import v14.h2.engine.Session;
import v14.h2.index.Cursor;
import v14.h2.index.Index;
import v14.h2.index.IndexLookupBatch;
import v14.h2.index.IndexType;
import v14.h2.message.DbException;
import v14.h2.result.Row;
import v14.h2.result.SearchRow;
import v14.h2.result.SortOrder;
import v14.h2.schema.SchemaObjectBase;
import v14.h2.table.Column;
import v14.h2.table.IndexColumn;
import v14.h2.table.Table;
import v14.h2.table.TableFilter;
import v14.h2.util.StringUtils;
import v14.h2.value.DataType;
import v14.h2.value.Value;
import v14.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected final Table table;
    protected final IndexType indexType;

    protected BaseIndex(Table table, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(table.getSchema(), n, string, 5);
        this.indexType = indexType;
        this.table = table;
        if (indexColumnArray != null) {
            this.indexColumns = indexColumnArray;
            this.columns = new Column[indexColumnArray.length];
            int n2 = this.columns.length;
            this.columnIds = new int[n2];
            for (int i = 0; i < n2; ++i) {
                Column column;
                this.columns[i] = column = indexColumnArray[i].column;
                this.columnIds[i] = column.getColumnId();
            }
        }
    }

    protected static void checkIndexColumnTypes(IndexColumn[] indexColumnArray) {
        for (IndexColumn indexColumn : indexColumnArray) {
            if (!DataType.isLargeObject(indexColumn.column.getType().getValueType())) continue;
            throw DbException.getUnsupportedException("Index on BLOB or CLOB column: " + indexColumn.column.getCreateSQL());
        }
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    public DbException getDuplicateKeyException(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getSQL(stringBuilder, false).append(" ON ");
        this.table.getSQL(stringBuilder, false).append('(');
        stringBuilder.append(this.getColumnListSQL(false));
        stringBuilder.append(')');
        if (string != null) {
            stringBuilder.append(" VALUES ").append(string);
        }
        DbException dbException = DbException.get(23505, stringBuilder.toString());
        dbException.setSource(this);
        return dbException;
    }

    protected StringBuilder getDuplicatePrimaryKeyMessage(int n) {
        StringBuilder stringBuilder = new StringBuilder("PRIMARY KEY ON ");
        this.table.getSQL(stringBuilder, false);
        if (n >= 0 && n < this.indexColumns.length) {
            stringBuilder.append('(');
            this.indexColumns[n].getSQL(stringBuilder, false).append(')');
        }
        return stringBuilder;
    }

    @Override
    public String getPlanSQL() {
        return this.getSQL(false);
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public boolean isFindUsingFullTableScan() {
        return false;
    }

    @Override
    public Cursor find(TableFilter tableFilter, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(tableFilter.getSession(), searchRow, searchRow2);
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError(this.toString());
    }

    protected final long getCostRangeIndex(int[] nArray, long l, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, boolean bl, AllColumnsForPlan allColumnsForPlan) {
        int n2;
        boolean bl2;
        int n3 = 0;
        long l2 = l += 1000L;
        if (nArray != null) {
            int n4 = 0;
            int n5 = this.columns.length;
            bl2 = false;
            while (n4 < n5) {
                Column column;
                int n6;
                int n7;
                if (((n7 = nArray[n6 = (column = this.columns[n4++]).getColumnId()]) & 1) == 1) {
                    if (n4 == n5 && this.getIndexType().isUnique()) {
                        l2 = 3L;
                        break;
                    }
                    long l3 = l * (long)(n3 = 100 - (100 - n3) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (l3 <= 0L) {
                        l3 = 1L;
                    }
                    l2 = 2L + Math.max(l / l3, 1L);
                    continue;
                }
                if ((n7 & 6) == 6) {
                    l2 = 2L + l2 / 4L;
                    bl2 = true;
                    break;
                }
                if ((n7 & 2) == 2) {
                    l2 = 2L + l2 / 3L;
                    bl2 = true;
                    break;
                }
                if ((n7 & 4) == 4) {
                    l2 /= 3L;
                    bl2 = true;
                    break;
                }
                if (n7 != 0) break;
                --n4;
                break;
            }
            if (bl2) {
                while (n4 < n5 && nArray[this.columns[n4].getColumnId()] != 0) {
                    ++n4;
                    --l2;
                }
            }
            l2 += (long)(n5 - n4);
        }
        long l4 = 0L;
        if (sortOrder != null) {
            l4 = 100L + l / 10L;
        }
        if (sortOrder != null && !bl) {
            bl2 = true;
            int n8 = 0;
            int[] nArray2 = sortOrder.getSortTypes();
            TableFilter tableFilter = tableFilterArray == null ? null : tableFilterArray[n];
            n2 = nArray2.length;
            for (int i = 0; i < n2 && i < this.indexColumns.length; ++i) {
                Column column = sortOrder.getColumn(i, tableFilter);
                if (column == null) {
                    bl2 = false;
                    break;
                }
                IndexColumn indexColumn = this.indexColumns[i];
                if (!column.equals(indexColumn.column)) {
                    bl2 = false;
                    break;
                }
                int n9 = nArray2[i];
                if (n9 != indexColumn.sortType) {
                    bl2 = false;
                    break;
                }
                ++n8;
            }
            if (bl2) {
                l4 = 100 - n8;
            }
        }
        bl2 = true;
        if (!bl && allColumnsForPlan != null) {
            boolean bl3 = true;
            ArrayList<Column> arrayList = allColumnsForPlan.get(this.getTable());
            if (arrayList != null) {
                for (Column column : arrayList) {
                    n2 = 0;
                    for (Column column2 : this.columns) {
                        if (column != column2) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) continue;
                    bl3 = false;
                    break;
                }
            }
            if (bl3) {
                bl2 = false;
            }
        }
        long l5 = bl ? l2 + l4 + 20L : (bl2 ? l2 + l2 + l4 + 20L : l2 + l4 + (long)this.columns.length);
        return l5;
    }

    @Override
    public int compareRows(SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == searchRow2) {
            return 0;
        }
        int n = this.indexColumns.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnIds[i];
            Value value = searchRow.getValue(n2);
            Value value2 = searchRow2.getValue(n2);
            if (value == null || value2 == null) {
                return 0;
            }
            int n3 = this.compareValues(value, value2, this.indexColumns[i].sortType);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    public boolean mayHaveNullDuplicates(SearchRow searchRow) {
        switch (this.database.getMode().uniqueIndexNullsHandling) {
            case ALLOW_DUPLICATES_WITH_ANY_NULL: {
                for (int n : this.columnIds) {
                    if (searchRow.getValue(n) != ValueNull.INSTANCE) continue;
                    return true;
                }
                return false;
            }
            case ALLOW_DUPLICATES_WITH_ALL_NULLS: {
                for (int n : this.columnIds) {
                    if (searchRow.getValue(n) == ValueNull.INSTANCE) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int compareKeys(SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2 = searchRow.getKey();
        if (l2 == (l = searchRow2.getKey())) {
            return 0;
        }
        return l2 > l ? 1 : -1;
    }

    private int compareValues(Value value, Value value2, int n) {
        boolean bl;
        if (value == value2) {
            return 0;
        }
        boolean bl2 = value == ValueNull.INSTANCE;
        boolean bl3 = bl = value2 == ValueNull.INSTANCE;
        if (bl2 || bl) {
            return SortOrder.compareNull(bl2, n);
        }
        int n2 = this.table.compareValues(value, value2);
        if ((n & 1) != 0) {
            n2 = -n2;
        }
        return n2;
    }

    @Override
    public int getColumnIndex(Column column) {
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (!this.columns[i].equals(column)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return column.equals(this.columns[0]);
    }

    private String getColumnListSQL(boolean bl) {
        return IndexColumn.writeColumns(new StringBuilder(), this.indexColumns, bl).toString();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        stringBuilder.append(this.indexType.getSQL());
        stringBuilder.append(' ');
        if (this.table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        stringBuilder.append(" ON ");
        table.getSQL(stringBuilder, true);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        stringBuilder.append('(').append(this.getColumnListSQL(true)).append(')');
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true));
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Row getRow(Session session, long l) {
        throw DbException.getUnsupportedException(this.toString());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return false;
    }

    @Override
    public boolean canScan() {
        return true;
    }

    @Override
    public void setSortedInsertMode(boolean bl) {
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] tableFilterArray, int n) {
        return null;
    }

    @Override
    public void update(Session session, Row row, Row row2) {
        this.remove(session, row);
        this.add(session, row2);
    }
}

