/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import jetbrains.exodus.ByteBufferByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.FixedLengthByteIterable;
import jetbrains.exodus.util.ByteIterableUtil;
import org.jetbrains.annotations.NotNull;

public class FileByteIterable
implements ByteIterable {
    private final File file;
    private final long offset;
    private final int length;

    public FileByteIterable(@NotNull File file) {
        this(file, 0L, (int)file.length());
    }

    public FileByteIterable(@NotNull File file, long offset, int len) {
        this.file = file;
        this.offset = offset;
        this.length = len;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteIterator iterator() {
        try (FileChannel channel = this.openChannel();){
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, this.offset, this.length);
            ByteIterator byteIterator = new ByteBufferByteIterable(buffer).iterator();
            return byteIterator;
        }
        catch (IOException e) {
            throw ExodusException.toExodusException(e);
        }
    }

    @Override
    public byte[] getBytesUnsafe() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public ByteIterable subIterable(int offset, int length) {
        return new FixedLengthByteIterable(this, offset, length);
    }

    @Override
    public int compareTo(@NotNull ByteIterable right) {
        return ByteIterableUtil.compare(this, right);
    }

    public InputStream asStream() throws IOException {
        return Channels.newInputStream(this.openChannel());
    }

    private FileChannel openChannel() throws IOException {
        return FileChannel.open(this.file.toPath(), StandardOpenOption.READ);
    }
}

