/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.jetty;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.nifi.jetty.configuration.connector.StandardServerConnectorFactory;
import org.apache.nifi.minifi.c2.api.properties.C2Properties;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServer {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private static final String C2_SERVER_HOME = System.getenv("C2_SERVER_HOME");
    private static final String WEB_DEFAULTS_XML = "webdefault.xml";

    public static void main(String[] args) throws Exception {
        Server server;
        C2Properties properties = C2Properties.getInstance();
        HandlerCollection handlers = new HandlerCollection();
        try (Stream<Path> files = Files.list(Paths.get(C2_SERVER_HOME, "webapps"));){
            files.forEach(path -> handlers.addHandler((Handler)JettyServer.loadWar(path.toFile(), "/c2", JettyServer.class.getClassLoader())));
        }
        int port = Integer.parseInt(properties.getProperty("minifi.c2.server.port", "10090"));
        if (properties.isSecure()) {
            server = new Server();
            StandardServerConnectorFactory serverConnectorFactory = new StandardServerConnectorFactory(server, port);
            serverConnectorFactory.setSslContext(JettyServer.buildSSLContext(properties));
            serverConnectorFactory.setWantClientAuth(true);
            ServerConnector https = serverConnectorFactory.getServerConnector();
            https.setPort(port);
            server.addConnector((Connector)https);
        } else {
            server = new Server(port);
        }
        server.setHandler((Handler)handlers);
        server.start();
        for (Handler handler : server.getChildHandlers()) {
            WebAppContext context;
            if (!(handler instanceof WebAppContext) || (context = (WebAppContext)handler).getUnavailableException() == null) continue;
            System.err.println("Failed to start web server: " + context.getUnavailableException().getMessage());
            System.err.println("Shutting down...");
            logger.warn("Failed to start web server... shutting down.", context.getUnavailableException());
            server.stop();
            System.exit(1);
        }
        server.dumpStdErr();
        server.join();
    }

    private static SSLContext buildSSLContext(C2Properties properties) {
        KeyStore truststore;
        KeyStore keyStore;
        File keyStoreFile = Paths.get(C2_SERVER_HOME, new String[0]).resolve(properties.getProperty("minifi.c2.server.keystore")).toFile();
        logger.debug("Loading Key Store [{}]", (Object)keyStoreFile.getPath());
        try (FileInputStream keyStoreStream = new FileInputStream(keyStoreFile);){
            keyStore = new StandardKeyStoreBuilder().type(properties.getProperty("minifi.c2.server.keystoreType")).inputStream((InputStream)keyStoreStream).password(properties.getProperty("minifi.c2.server.keystorePasswd").toCharArray()).build();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Key Store loading failed", ioe);
        }
        File trustStoreFile = Paths.get(C2_SERVER_HOME, new String[0]).resolve(properties.getProperty("minifi.c2.server.truststore")).toFile();
        logger.debug("Loading Trust Store [{}]", (Object)trustStoreFile.getPath());
        try (FileInputStream trustStoreStream = new FileInputStream(trustStoreFile);){
            truststore = new StandardKeyStoreBuilder().type(properties.getProperty("minifi.c2.server.truststoreType")).inputStream((InputStream)trustStoreStream).password(properties.getProperty("minifi.c2.server.truststorePasswd").toCharArray()).build();
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Trust Store loading failed", ioe);
        }
        return new StandardSslContextBuilder().keyStore(keyStore).keyPassword(properties.getProperty("minifi.c2.server.keyPasswd").toCharArray()).trustStore(truststore).build();
    }

    private static WebAppContext loadWar(File warFile, String contextPath, ClassLoader parentClassLoader) {
        boolean made;
        WebAppContext webappContext = new WebAppContext(warFile.getPath(), contextPath);
        webappContext.setContextPath(contextPath);
        webappContext.setDisplayName(contextPath);
        webappContext.setErrorHandler((ErrorHandler)JettyServer.getErrorHandler());
        webappContext.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\\\.jar$|.*/[^/]*taglibs.*\\.jar$");
        ArrayList<String> serverClasses = new ArrayList<String>(Arrays.asList(webappContext.getServerClasses()));
        serverClasses.remove("org.slf4j.");
        webappContext.setServerClasses(serverClasses.toArray(new String[0]));
        webappContext.setDefaultsDescriptor(WEB_DEFAULTS_XML);
        File tempDir = Paths.get(C2_SERVER_HOME, "tmp", warFile.getName()).toFile();
        if (tempDir.exists() && !tempDir.isDirectory()) {
            throw new RuntimeException(tempDir.getAbsolutePath() + " is not a directory");
        }
        if (!tempDir.exists() && !(made = tempDir.mkdirs())) {
            throw new RuntimeException(tempDir.getAbsolutePath() + " could not be created");
        }
        if (!tempDir.canRead() || !tempDir.canWrite()) {
            throw new RuntimeException(tempDir.getAbsolutePath() + " directory does not have read/write privilege");
        }
        webappContext.setTempDirectory(tempDir);
        webappContext.setMaxFormContentSize(600000);
        try {
            webappContext.setClassLoader((ClassLoader)new WebAppClassLoader(parentClassLoader, (WebAppClassLoader.Context)webappContext));
        }
        catch (IOException e) {
            throw new UncheckedIOException("ClassLoader initialization failed", e);
        }
        logger.info("Loading WAR: " + warFile.getAbsolutePath() + " with context path set to " + contextPath);
        return webappContext;
    }

    private static ErrorPageErrorHandler getErrorHandler() {
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.setShowServlet(false);
        errorHandler.setShowStacks(false);
        errorHandler.setShowMessageInTitle(false);
        return errorHandler;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

