/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.persistence;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;

public class TemplateDeserializer {
    private static final JAXBContext jaxbContext;

    public static TemplateDTO deserialize(InputStream inStream) {
        return TemplateDeserializer.deserialize(new StreamSource(inStream));
    }

    public static TemplateDTO deserialize(StreamSource source) {
        StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
        try {
            XMLStreamReader xsr = provider.getStreamReader(source);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement templateElement = unmarshaller.unmarshal(xsr, TemplateDTO.class);
            TemplateDTO templateDto = (TemplateDTO)templateElement.getValue();
            return templateDto;
        }
        catch (JAXBException | ProcessingException e) {
            throw new FlowSerializationException(e);
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TemplateDTO.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Cannot create JAXBContext for serializing templates", e);
        }
    }
}

