/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.map.CompactMap;
import io.questdb.cairo.map.FastMap;
import io.questdb.cairo.map.Map;
import io.questdb.griffin.EmptyRecordMetadata;
import io.questdb.std.Chars;
import org.jetbrains.annotations.NotNull;

public class MapFactory {
    public static Map createMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @NotNull ColumnTypes valueTypes) {
        return MapFactory.createMap(false, configuration, keyTypes, valueTypes);
    }

    public static Map createMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes) {
        return MapFactory.createMap(false, configuration, keyTypes);
    }

    public static Map createSmallMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes) {
        return MapFactory.createMap(true, configuration, keyTypes);
    }

    public static Map createSmallMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @NotNull ColumnTypes valueTypes) {
        return MapFactory.createMap(true, configuration, keyTypes, valueTypes);
    }

    private static Map createMap(boolean smallMap, CairoConfiguration configuration, @NotNull ColumnTypes keyTypes) {
        int keyCapacity = smallMap ? configuration.getSqlSmallMapKeyCapacity() : configuration.getSqlMapKeyCapacity();
        int pageSize = smallMap ? configuration.getSqlSmallMapPageSize() : configuration.getSqlMapPageSize();
        CharSequence mapType = configuration.getDefaultMapType();
        if (Chars.equalsLowerCaseAscii(mapType, "fast")) {
            return new FastMap(pageSize, keyTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
        }
        if (Chars.equalsLowerCaseAscii(mapType, "compact")) {
            return new CompactMap(pageSize, keyTypes, EmptyRecordMetadata.INSTANCE, keyCapacity, configuration.getSqlCompactMapLoadFactor(), configuration.getSqlMapMaxResizes(), configuration.getSqlMapMaxPages());
        }
        throw CairoException.critical(0).put("unknown map type: ").put(mapType);
    }

    private static Map createMap(boolean smallMap, CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @NotNull ColumnTypes valueTypes) {
        int keyCapacity = smallMap ? configuration.getSqlSmallMapKeyCapacity() : configuration.getSqlMapKeyCapacity();
        int pageSize = smallMap ? configuration.getSqlSmallMapPageSize() : configuration.getSqlMapPageSize();
        CharSequence mapType = configuration.getDefaultMapType();
        if (Chars.equalsLowerCaseAscii(mapType, "fast")) {
            return new FastMap(pageSize, keyTypes, valueTypes, keyCapacity, configuration.getSqlFastMapLoadFactor(), configuration.getSqlMapMaxResizes());
        }
        if (Chars.equalsLowerCaseAscii(mapType, "compact")) {
            return new CompactMap(pageSize, keyTypes, valueTypes, keyCapacity, configuration.getSqlCompactMapLoadFactor(), configuration.getSqlMapMaxResizes(), configuration.getSqlMapMaxPages());
        }
        throw CairoException.critical(0).put("unknown map type: ").put(mapType);
    }
}

