/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.ColumnFilter;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.RecordToRowCopier;
import io.questdb.griffin.SqlUtil;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.str.StringSink;

public class RecordToRowCopierUtils {
    private RecordToRowCopierUtils() {
    }

    public static RecordToRowCopier generateCopier(BytecodeAssembler asm, ColumnTypes from, RecordMetadata to, ColumnFilter toColumnFilter) {
        int timestampIndex = to.getTimestampIndex();
        asm.init(RecordToRowCopier.class);
        asm.setupPool();
        int thisClassIndex = asm.poolClass(asm.poolUtf8("io/questdb/griffin/rowcopier"));
        int interfaceClassIndex = asm.poolClass(RecordToRowCopier.class);
        int rGetInt = asm.poolInterfaceMethod(Record.class, "getInt", "(I)I");
        int rGetGeoInt = asm.poolInterfaceMethod(Record.class, "getGeoInt", "(I)I");
        int rGetLong = asm.poolInterfaceMethod(Record.class, "getLong", "(I)J");
        int rGetGeoLong = asm.poolInterfaceMethod(Record.class, "getGeoLong", "(I)J");
        int rGetLong256 = asm.poolInterfaceMethod(Record.class, "getLong256A", "(I)Lio/questdb/std/Long256;");
        int rGetLong128Lo = asm.poolInterfaceMethod(Record.class, "getLong128Lo", "(I)J");
        int rGetLong128Hi = asm.poolInterfaceMethod(Record.class, "getLong128Hi", "(I)J");
        int rGetDate = asm.poolInterfaceMethod(Record.class, "getDate", "(I)J");
        int rGetTimestamp = asm.poolInterfaceMethod(Record.class, "getTimestamp", "(I)J");
        int rGetByte = asm.poolInterfaceMethod(Record.class, "getByte", "(I)B");
        int rGetGeoByte = asm.poolInterfaceMethod(Record.class, "getGeoByte", "(I)B");
        int rGetShort = asm.poolInterfaceMethod(Record.class, "getShort", "(I)S");
        int rGetGeoShort = asm.poolInterfaceMethod(Record.class, "getGeoShort", "(I)S");
        int rGetChar = asm.poolInterfaceMethod(Record.class, "getChar", "(I)C");
        int rGetBool = asm.poolInterfaceMethod(Record.class, "getBool", "(I)Z");
        int rGetFloat = asm.poolInterfaceMethod(Record.class, "getFloat", "(I)F");
        int rGetDouble = asm.poolInterfaceMethod(Record.class, "getDouble", "(I)D");
        int rGetSym = asm.poolInterfaceMethod(Record.class, "getSym", "(I)Ljava/lang/CharSequence;");
        int rGetStr = asm.poolInterfaceMethod(Record.class, "getStr", "(I)Ljava/lang/CharSequence;");
        int rGetBin = asm.poolInterfaceMethod(Record.class, "getBin", "(I)Lio/questdb/std/BinarySequence;");
        int wPutInt = asm.poolInterfaceMethod(TableWriter.Row.class, "putInt", "(II)V");
        int wPutLong = asm.poolInterfaceMethod(TableWriter.Row.class, "putLong", "(IJ)V");
        int wPutLong256 = asm.poolInterfaceMethod(TableWriter.Row.class, "putLong256", "(ILio/questdb/std/Long256;)V");
        int wPutLong128 = asm.poolInterfaceMethod(TableWriter.Row.class, "putLong128", "(IJJ)V");
        int wPutUuidStr = asm.poolInterfaceMethod(TableWriter.Row.class, "putUuid", "(ILjava/lang/CharSequence;)V");
        int wPutDate = asm.poolInterfaceMethod(TableWriter.Row.class, "putDate", "(IJ)V");
        int wPutTimestamp = asm.poolInterfaceMethod(TableWriter.Row.class, "putTimestamp", "(IJ)V");
        int wPutByte = asm.poolInterfaceMethod(TableWriter.Row.class, "putByte", "(IB)V");
        int wPutShort = asm.poolInterfaceMethod(TableWriter.Row.class, "putShort", "(IS)V");
        int wPutBool = asm.poolInterfaceMethod(TableWriter.Row.class, "putBool", "(IZ)V");
        int wPutFloat = asm.poolInterfaceMethod(TableWriter.Row.class, "putFloat", "(IF)V");
        int wPutDouble = asm.poolInterfaceMethod(TableWriter.Row.class, "putDouble", "(ID)V");
        int wPutSym = asm.poolInterfaceMethod(TableWriter.Row.class, "putSym", "(ILjava/lang/CharSequence;)V");
        int wPutSymChar = asm.poolInterfaceMethod(TableWriter.Row.class, "putSym", "(IC)V");
        int wPutStr = asm.poolInterfaceMethod(TableWriter.Row.class, "putStr", "(ILjava/lang/CharSequence;)V");
        int wPutGeoStr = asm.poolInterfaceMethod(TableWriter.Row.class, "putGeoStr", "(ILjava/lang/CharSequence;)V");
        int implicitCastCharAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastCharAsByte", (CharSequence)"(CI)B");
        int implicitCastCharAsGeoHash = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastCharAsGeoHash", (CharSequence)"(CI)B");
        int implicitCastStrAsFloat = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsFloat", (CharSequence)"(Ljava/lang/CharSequence;)F");
        int implicitCastStrAsDouble = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsDouble", (CharSequence)"(Ljava/lang/CharSequence;)D");
        int implicitCastStrAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsByte", (CharSequence)"(Ljava/lang/CharSequence;)B");
        int implicitCastStrAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsShort", (CharSequence)"(Ljava/lang/CharSequence;)S");
        int implicitCastStrAsChar = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsChar", (CharSequence)"(Ljava/lang/CharSequence;)C");
        int implicitCastStrAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsInt", (CharSequence)"(Ljava/lang/CharSequence;)I");
        int implicitCastStrAsLong = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsLong", (CharSequence)"(Ljava/lang/CharSequence;)J");
        int implicitCastStrAsDate = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsDate", (CharSequence)"(Ljava/lang/CharSequence;)J");
        int implicitCastStrAsTimestamp = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastStrAsTimestamp", (CharSequence)"(Ljava/lang/CharSequence;)J");
        int implicitCastDateAsTimestamp = asm.poolMethod(SqlUtil.class, (CharSequence)"dateToTimestamp", (CharSequence)"(J)J");
        int implicitCastShortAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastShortAsByte", (CharSequence)"(S)B");
        int implicitCastIntAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastIntAsByte", (CharSequence)"(I)B");
        int implicitCastLongAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastLongAsByte", (CharSequence)"(J)B");
        int implicitCastFloatAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastFloatAsByte", (CharSequence)"(F)B");
        int implicitCastDoubleAsByte = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsByte", (CharSequence)"(D)B");
        int implicitCastIntAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastIntAsShort", (CharSequence)"(I)S");
        int implicitCastLongAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastLongAsShort", (CharSequence)"(J)S");
        int implicitCastFloatAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastFloatAsShort", (CharSequence)"(F)S");
        int implicitCastDoubleAsShort = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsShort", (CharSequence)"(D)S");
        int implicitCastLongAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastLongAsInt", (CharSequence)"(J)I");
        int implicitCastFloatAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastFloatAsInt", (CharSequence)"(F)I");
        int implicitCastDoubleAsInt = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsInt", (CharSequence)"(D)I");
        int implicitCastFloatAsLong = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastFloatAsLong", (CharSequence)"(F)J");
        int implicitCastDoubleAsLong = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsLong", (CharSequence)"(D)J");
        int implicitCastDoubleAsFloat = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastDoubleAsFloat", (CharSequence)"(D)F");
        int wPutStrChar = asm.poolInterfaceMethod(TableWriter.Row.class, "putStr", "(IC)V");
        int wPutChar = asm.poolInterfaceMethod(TableWriter.Row.class, "putChar", "(IC)V");
        int wPutBin = asm.poolInterfaceMethod(TableWriter.Row.class, "putBin", "(ILio/questdb/std/BinarySequence;)V");
        int implicitCastGeoHashAsGeoHash = asm.poolMethod(SqlUtil.class, (CharSequence)"implicitCastGeoHashAsGeoHash", (CharSequence)"(JII)J");
        int transferUuidToStrCol = asm.poolMethod(RecordToRowCopierUtils.class, (CharSequence)"transferUuidToStrCol", (CharSequence)"(Lio/questdb/cairo/TableWriter$Row;IJJ)V");
        int n = toColumnFilter.getColumnCount();
        int toColumnType_0 = asm.getPoolCount();
        int fromColumnType_0 = toColumnType_0 + 1;
        for (int i = 0; i < n; ++i) {
            asm.poolIntConst(to.getColumnType(toColumnFilter.getColumnIndexFactored(i)));
            asm.poolIntConst(from.getColumnType(i));
        }
        int copyNameIndex = asm.poolUtf8("copy");
        int copySigIndex = asm.poolUtf8("(Lio/questdb/cairo/sql/Record;Lio/questdb/cairo/TableWriter$Row;)V");
        asm.finishPool();
        asm.defineClass(thisClassIndex);
        asm.interfaceCount(1);
        asm.putShort(interfaceClassIndex);
        asm.fieldCount(0);
        asm.methodCount(2);
        asm.defineDefaultConstructor();
        asm.startMethod(copyNameIndex, copySigIndex, 15, 5);
        block150: for (int i = 0; i < n; ++i) {
            int toColumnIndex = toColumnFilter.getColumnIndexFactored(i);
            if (toColumnIndex == timestampIndex) continue;
            int toColumnType = to.getColumnType(toColumnIndex);
            int fromColumnType = from.getColumnType(i);
            short toColumnTypeTag = ColumnType.tagOf(toColumnType);
            int toColumnWriterIndex = to.getWriterIndex(toColumnIndex);
            asm.aload(2);
            asm.iconst(toColumnWriterIndex);
            asm.aload(1);
            asm.iconst(i);
            short fromColumnTypeTag = ColumnType.tagOf(fromColumnType);
            if (fromColumnTypeTag == 29) {
                fromColumnTypeTag = toColumnTypeTag;
            }
            switch (fromColumnTypeTag) {
                case 5: {
                    asm.invokeInterface(rGetInt);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastIntAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastIntAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.i2l();
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.i2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.i2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 6: {
                    asm.invokeInterface(rGetLong);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastLongAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastLongAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastLongAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.l2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.l2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 7: {
                    asm.invokeInterface(rGetDate);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastLongAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastLongAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastLongAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.invokeStatic(implicitCastDateAsTimestamp);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.l2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.l2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 8: {
                    asm.invokeInterface(rGetTimestamp);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastLongAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastLongAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastLongAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.l2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.l2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 2: {
                    asm.invokeInterface(rGetByte);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.i2s();
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.i2l();
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.i2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.i2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 3: {
                    asm.invokeInterface(rGetShort);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastShortAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.i2l();
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.i2l();
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.i2l();
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.i2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.i2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 1: {
                    assert (toColumnType == 1);
                    asm.invokeInterface(rGetBool);
                    asm.invokeInterface(wPutBool, 2);
                    continue block150;
                }
                case 9: {
                    asm.invokeInterface(rGetFloat);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastFloatAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastFloatAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastFloatAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.invokeStatic(implicitCastFloatAsLong);
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.invokeStatic(implicitCastFloatAsLong);
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.invokeStatic(implicitCastFloatAsLong);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.f2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 10: {
                    asm.invokeInterface(rGetDouble);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastDoubleAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastDoubleAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastDoubleAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.invokeStatic(implicitCastDoubleAsLong);
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.invokeStatic(implicitCastDoubleAsLong);
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.invokeStatic(implicitCastDoubleAsLong);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.invokeStatic(implicitCastDoubleAsFloat);
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 4: {
                    asm.invokeInterface(rGetChar);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2s();
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 4: {
                            asm.invokeInterface(wPutChar, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2l();
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 7: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2l();
                            asm.invokeInterface(wPutDate, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2l();
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2f();
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.iconst(toColumnType);
                            asm.invokeStatic(implicitCastCharAsByte);
                            asm.i2d();
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                        case 11: {
                            asm.invokeInterface(wPutStrChar, 2);
                            continue block150;
                        }
                        case 12: {
                            asm.invokeInterface(wPutSymChar, 2);
                            continue block150;
                        }
                        case 14: {
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastCharAsGeoHash);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 12: {
                    asm.invokeInterface(rGetSym);
                    switch (toColumnTypeTag) {
                        case 12: {
                            asm.invokeInterface(wPutSym, 2);
                            continue block150;
                        }
                        case 11: {
                            asm.invokeInterface(wPutStr, 2);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 11: {
                    asm.invokeInterface(rGetStr);
                    switch (toColumnTypeTag) {
                        case 2: {
                            asm.invokeStatic(implicitCastStrAsByte);
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 3: {
                            asm.invokeStatic(implicitCastStrAsShort);
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 4: {
                            asm.invokeStatic(implicitCastStrAsChar);
                            asm.invokeInterface(wPutChar, 2);
                            continue block150;
                        }
                        case 5: {
                            asm.invokeStatic(implicitCastStrAsInt);
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 6: {
                            asm.invokeStatic(implicitCastStrAsLong);
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                        case 9: {
                            asm.invokeStatic(implicitCastStrAsFloat);
                            asm.invokeInterface(wPutFloat, 2);
                            continue block150;
                        }
                        case 10: {
                            asm.invokeStatic(implicitCastStrAsDouble);
                            asm.invokeInterface(wPutDouble, 3);
                            continue block150;
                        }
                        case 12: {
                            asm.invokeInterface(wPutSym, 2);
                            continue block150;
                        }
                        case 7: {
                            asm.invokeStatic(implicitCastStrAsDate);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 8: {
                            asm.invokeStatic(implicitCastStrAsTimestamp);
                            asm.invokeInterface(wPutTimestamp, 3);
                            continue block150;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            asm.invokeInterface(wPutGeoStr, 2);
                            continue block150;
                        }
                        case 11: {
                            asm.invokeInterface(wPutStr, 2);
                            continue block150;
                        }
                        case 19: {
                            asm.invokeInterface(wPutUuidStr, 2);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 18: {
                    assert (toColumnTypeTag == 18);
                    asm.invokeInterface(rGetBin);
                    asm.invokeInterface(wPutBin, 2);
                    continue block150;
                }
                case 13: {
                    assert (toColumnTypeTag == 13);
                    asm.invokeInterface(rGetLong256);
                    asm.invokeInterface(wPutLong256, 2);
                    continue block150;
                }
                case 14: {
                    asm.invokeInterface(rGetGeoByte, 1);
                    if (fromColumnType != toColumnType && fromColumnType != 29 && fromColumnType != 14) {
                        asm.i2l();
                        asm.ldc(fromColumnType_0 + i * 2);
                        asm.ldc(toColumnType_0 + i * 2);
                        asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                        asm.l2i();
                        asm.i2b();
                    }
                    asm.invokeInterface(wPutByte, 2);
                    continue block150;
                }
                case 15: {
                    asm.invokeInterface(rGetGeoShort, 1);
                    if (ColumnType.tagOf(toColumnType) == 14) {
                        asm.i2l();
                        asm.ldc(fromColumnType_0 + i * 2);
                        asm.ldc(toColumnType_0 + i * 2);
                        asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                        asm.l2i();
                        asm.i2b();
                        asm.invokeInterface(wPutByte, 2);
                        continue block150;
                    }
                    if (fromColumnType != toColumnType && fromColumnType != 29 && fromColumnType != 15) {
                        asm.i2l();
                        asm.ldc(fromColumnType_0 + i * 2);
                        asm.ldc(toColumnType_0 + i * 2);
                        asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                        asm.l2i();
                        asm.i2s();
                        asm.invokeInterface(wPutShort, 2);
                        continue block150;
                    }
                    asm.invokeInterface(wPutShort, 2);
                    continue block150;
                }
                case 16: {
                    asm.invokeInterface(rGetGeoInt, 1);
                    switch (ColumnType.tagOf(toColumnType)) {
                        case 14: {
                            asm.i2l();
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.i2b();
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 15: {
                            asm.i2l();
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.i2s();
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 16: {
                            if (fromColumnType != toColumnType && fromColumnType != 29 && fromColumnType != 16) {
                                asm.i2l();
                                asm.ldc(fromColumnType_0 + i * 2);
                                asm.ldc(toColumnType_0 + i * 2);
                                asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                                asm.l2i();
                            }
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 17: {
                    asm.invokeInterface(rGetGeoLong, 1);
                    switch (ColumnType.tagOf(toColumnType)) {
                        case 14: {
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.i2b();
                            asm.invokeInterface(wPutByte, 2);
                            continue block150;
                        }
                        case 15: {
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.i2s();
                            asm.invokeInterface(wPutShort, 2);
                            continue block150;
                        }
                        case 16: {
                            asm.ldc(fromColumnType_0 + i * 2);
                            asm.ldc(toColumnType_0 + i * 2);
                            asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            asm.l2i();
                            asm.invokeInterface(wPutInt, 2);
                            continue block150;
                        }
                        case 17: {
                            if (fromColumnType != toColumnType && fromColumnType != 29 && fromColumnType != 17) {
                                asm.ldc(fromColumnType_0 + i * 2);
                                asm.ldc(toColumnType_0 + i * 2);
                                asm.invokeStatic(implicitCastGeoHashAsGeoHash);
                            }
                            asm.invokeInterface(wPutLong, 3);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                case 19: 
                case 24: {
                    switch (ColumnType.tagOf(toColumnType)) {
                        case 19: 
                        case 24: {
                            asm.invokeInterface(rGetLong128Lo, 1);
                            asm.aload(1);
                            asm.iconst(i);
                            asm.invokeInterface(rGetLong128Hi, 1);
                            asm.invokeInterface(wPutLong128, 5);
                            continue block150;
                        }
                        case 11: {
                            assert (fromColumnType == 19);
                            asm.invokeInterface(rGetLong128Lo, 1);
                            asm.aload(1);
                            asm.iconst(i);
                            asm.invokeInterface(rGetLong128Hi, 1);
                            asm.invokeStatic(transferUuidToStrCol);
                            continue block150;
                        }
                    }
                    assert (false);
                    continue block150;
                }
                default: {
                    assert (fromColumnType == 29);
                    continue block150;
                }
            }
        }
        asm.return_();
        asm.endMethodCode();
        asm.putShort(0);
        asm.putShort(0);
        asm.endMethod();
        asm.putShort(0);
        return (RecordToRowCopier)asm.newInstance();
    }

    public static void transferUuidToStrCol(TableWriter.Row row, int col, long lo, long hi) {
        StringSink threadLocalBuilder = Misc.getThreadLocalBuilder();
        if (SqlUtil.implicitCastUuidAsStr(lo, hi, threadLocalBuilder)) {
            row.putStr(col, threadLocalBuilder);
        }
    }
}

