/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.UuidFunction;
import io.questdb.griffin.engine.functions.constants.UuidConstant;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Uuid;

public final class CastStrToUuidFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Sz)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        if (args.getQuick(0).isConstant()) {
            CharSequence value = args.getQuick(0).getStr(null);
            if (value == null || value.length() == 0) {
                return UuidConstant.NULL;
            }
            Uuid uuid = new Uuid();
            try {
                uuid.of(value);
            }
            catch (NumericException e) {
                throw SqlException.$(argPositions.getQuick(0), "invalid UUID constant");
            }
            return new UuidConstant(uuid);
        }
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends UuidFunction
    implements UnaryFunction {
        private final Function arg;

        public Func(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getLong128Hi(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            if (value == null) {
                return Long.MIN_VALUE;
            }
            try {
                Uuid.checkDashesAndLength(value);
                return Uuid.parseHi(value);
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }

        @Override
        public long getLong128Lo(Record rec) {
            CharSequence value = this.arg.getStr(rec);
            if (value == null) {
                return Long.MIN_VALUE;
            }
            try {
                Uuid.checkDashesAndLength(value);
                return Uuid.parseLo(value);
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getArg()).val("::uuid");
        }
    }
}

