/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.TimestampFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.TimestampConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;

public class TimestampAddFunctionFactory
implements FunctionFactory {
    private static final ObjList<LongAddIntFunction> addFunctions = new ObjList();
    private static final int addFunctionsMax;

    @Override
    public String getSignature() {
        return "dateadd(AIN)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function period = args.getQuick(0);
        Function interval = args.getQuick(1);
        if (period.isConstant()) {
            LongAddIntFunction func;
            char periodValue = period.getChar(null);
            if (periodValue < addFunctionsMax && (func = addFunctions.getQuick(periodValue)) != null) {
                if (interval.isConstant()) {
                    if (interval.getInt(null) != Integer.MIN_VALUE) {
                        return new AddLongIntVarConstFunction(args.getQuick(2), interval.getInt(null), func, periodValue);
                    }
                    return TimestampConstant.NULL;
                }
                return new AddLongIntVarVarFunction(args.getQuick(2), args.getQuick(1), func, periodValue);
            }
            return TimestampConstant.NULL;
        }
        return new DateAddFunc(args.getQuick(2), args.getQuick(0), args.getQuick(1));
    }

    static {
        addFunctions.extendAndSet(115, Timestamps::addSeconds);
        addFunctions.extendAndSet(109, Timestamps::addMinutes);
        addFunctions.extendAndSet(104, Timestamps::addHours);
        addFunctions.extendAndSet(100, Timestamps::addDays);
        addFunctions.extendAndSet(119, Timestamps::addWeeks);
        addFunctions.extendAndSet(77, Timestamps::addMonths);
        addFunctions.extendAndSet(121, Timestamps::addYear);
        addFunctionsMax = addFunctions.size();
    }

    private static class DateAddFunc
    extends TimestampFunction
    implements TernaryFunction {
        final Function center;
        final Function left;
        final Function right;

        public DateAddFunc(Function left, Function center, Function right) {
            this.left = left;
            this.center = center;
            this.right = right;
        }

        @Override
        public Function getCenter() {
            return this.center;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public String getName() {
            return "dateadd";
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getTimestamp(Record rec) {
            long l = this.left.getTimestamp(rec);
            char c = this.center.getChar(rec);
            int r = this.right.getInt(rec);
            if (l == Long.MIN_VALUE || r == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return Timestamps.addPeriod(l, c, r);
        }
    }

    private static class AddLongIntVarVarFunction
    extends TimestampFunction
    implements BinaryFunction {
        private final LongAddIntFunction func;
        private final Function left;
        private final char periodSymbol;
        private final Function right;

        public AddLongIntVarVarFunction(Function left, Function right, LongAddIntFunction func, char periodSymbol) {
            this.left = left;
            this.right = right;
            this.func = func;
            this.periodSymbol = periodSymbol;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public long getTimestamp(Record rec) {
            long l = this.left.getTimestamp(rec);
            int r = this.right.getInt(rec);
            if (l == Long.MIN_VALUE || r == Integer.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.func.add(l, r);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("dateadd('").val(this.periodSymbol).val("',").val(this.left).val(',').val(this.right).val(')');
        }
    }

    private static class AddLongIntVarConstFunction
    extends TimestampFunction
    implements UnaryFunction {
        private final Function arg;
        private final LongAddIntFunction func;
        private final int interval;
        private final char periodSymbol;

        public AddLongIntVarConstFunction(Function left, int right, LongAddIntFunction func, char periodSymbol) {
            this.arg = left;
            this.interval = right;
            this.func = func;
            this.periodSymbol = periodSymbol;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public long getTimestamp(Record rec) {
            long l = this.arg.getTimestamp(rec);
            if (l == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            return this.func.add(l, this.interval);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("dateadd('").val(this.periodSymbol).val("',").val(this.interval).val(',').val(this.arg).val(')');
        }
    }

    @FunctionalInterface
    private static interface LongAddIntFunction {
        public long add(long var1, int var3);
    }
}

