/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public abstract class AbstractSampleByRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final RecordCursorFactory base;
    protected final ObjList<Function> recordFunctions;

    public AbstractSampleByRecordCursorFactory(RecordCursorFactory base, RecordMetadata metadata, ObjList<Function> recordFunctions) {
        super(metadata);
        this.base = base;
        this.recordFunctions = recordFunctions;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.recordFunctions);
        Misc.free(this.base);
    }

    protected abstract AbstractNoRecordSampleByCursor getRawCursor();

    protected RecordCursor initFunctionsAndCursor(SqlExecutionContext executionContext, RecordCursor baseCursor) throws SqlException {
        try {
            AbstractNoRecordSampleByCursor cursor = this.getRawCursor();
            cursor.of(baseCursor, executionContext);
            Function.init(this.recordFunctions, baseCursor, executionContext);
            return cursor;
        }
        catch (Throwable ex) {
            Misc.free(baseCursor);
            throw ex;
        }
    }
}

