/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.function.DoubleBinaryOperator;

public class MinDoubleVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    public static final DoubleBinaryOperator MIN = Math::min;
    private final int columnIndex;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private final DoubleAccumulator min = new DoubleAccumulator(MIN, Double.POSITIVE_INFINITY);
    private int valueOffset;

    public MinDoubleVectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        this.columnIndex = columnIndex;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourMinDouble;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntMinDouble;
        }
    }

    @Override
    public void aggregate(long address, long addressSize, int columnSizeHint, int workerId) {
        double value;
        if (address != 0L && (value = Vect.minDouble(address, addressSize / 8L)) == value) {
            this.min.accumulate(value);
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int columnSizeShr, int workerId) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, valueAddressSize / 8L);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, valueAddressSize / 8L, this.valueOffset);
    }

    @Override
    public void clear() {
        this.min.reset();
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public double getDouble(Record rec) {
        double min = this.min.get();
        if (Double.isInfinite(min)) {
            return Double.NaN;
        }
        return min;
    }

    @Override
    public String getName() {
        return "min";
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset), Double.POSITIVE_INFINITY);
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntMinDoubleMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(10);
    }

    @Override
    public boolean wrapUp(long pRosti) {
        return Rosti.keyedIntMinDoubleWrapUp(pRosti, this.valueOffset, this.min.get());
    }
}

