/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.LongFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.concurrent.atomic.LongAdder;

public class SumIntVectorAggregateFunction
extends LongFunction
implements VectorAggregateFunction {
    private final int columnIndex;
    private final LongAdder count = new LongAdder();
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private final LongAdder sum = new LongAdder();
    private int valueOffset;

    public SumIntVectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourSumInt;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntSumInt;
        }
        this.columnIndex = columnIndex;
    }

    @Override
    public void aggregate(long address, long addressSize, int columnSizeHint, int workerId) {
        long value;
        if (address != 0L && (value = Vect.sumInt(address, addressSize / 4L)) != Long.MIN_VALUE) {
            this.sum.add(value);
            this.count.increment();
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long valueAddressSize, int columnSizeShr, int workerId) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, valueAddressSize / 4L);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, valueAddressSize / 4L, this.valueOffset);
    }

    @Override
    public void clear() {
        this.sum.reset();
        this.count.reset();
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public long getLong(Record rec) {
        return this.count.sum() > 0L ? this.sum.sum() : Long.MIN_VALUE;
    }

    @Override
    public String getName() {
        return "sum";
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0L);
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 1), 0L);
    }

    @Override
    public boolean isReadThreadSafe() {
        return false;
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntSumIntMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(6);
        types.add(6);
    }

    @Override
    public boolean wrapUp(long pRosti) {
        return Rosti.keyedIntSumLongWrapUp(pRosti, this.valueOffset, this.sum.sum(), this.count.sum());
    }
}

