/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.Metrics;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.IDGenerator;
import io.questdb.cairo.TableNameRegistry;
import io.questdb.cairo.TableNameRegistryRO;
import io.questdb.cairo.TableNameRegistryRW;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.mig.EngineMigration;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.MetadataPool;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.pool.WalWriterPool;
import io.questdb.cairo.pool.WriterPool;
import io.questdb.cairo.pool.WriterSource;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cairo.wal.WalReader;
import io.questdb.cairo.wal.WalWriter;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cutlass.text.TextImportExecutionContext;
import io.questdb.griffin.DatabaseSnapshotAgent;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.Job;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.Sequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.tasks.TelemetryTask;
import io.questdb.tasks.WalTxnNotificationTask;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CairoEngine
implements Closeable,
WriterSource {
    public static final String BUSY_READER = "busyReader";
    private static final Log LOG = LogFactory.getLog(CairoEngine.class);
    private final AtomicLong asyncCommandCorrelationId = new AtomicLong();
    private final CairoConfiguration configuration;
    private final EngineMaintenanceJob engineMaintenanceJob;
    private final MessageBusImpl messageBus;
    private final MetadataPool metadataPool;
    private final Metrics metrics;
    private final ReaderPool readerPool;
    private final IDGenerator tableIdGenerator;
    private final TableNameRegistry tableNameRegistry;
    private final TableSequencerAPI tableSequencerAPI;
    private final MPSequence telemetryPubSeq;
    private final RingQueue<TelemetryTask> telemetryQueue;
    private final SCSequence telemetrySubSeq;
    private final TextImportExecutionContext textImportExecutionContext;
    private final AtomicLong unpublishedWalTxnCount = new AtomicLong(1L);
    private final WalWriterPool walWriterPool;
    private final WriterPool writerPool;

    public CairoEngine(CairoConfiguration configuration) {
        this(configuration, Metrics.disabled());
    }

    public CairoEngine(CairoConfiguration configuration, Metrics metrics) {
        this.configuration = configuration;
        this.textImportExecutionContext = new TextImportExecutionContext(configuration);
        this.metrics = metrics;
        this.tableSequencerAPI = new TableSequencerAPI(this, configuration);
        this.messageBus = new MessageBusImpl(configuration);
        this.writerPool = new WriterPool(this.getConfiguration(), this.getMessageBus(), metrics);
        this.readerPool = new ReaderPool(configuration, this.messageBus);
        this.metadataPool = new MetadataPool(configuration, this);
        this.walWriterPool = new WalWriterPool(configuration, this);
        this.engineMaintenanceJob = new EngineMaintenanceJob(configuration);
        if (configuration.getTelemetryConfiguration().getEnabled()) {
            this.telemetryQueue = new RingQueue<TelemetryTask>(TelemetryTask::new, configuration.getTelemetryConfiguration().getQueueCapacity());
            this.telemetryPubSeq = new MPSequence(this.telemetryQueue.getCycle());
            this.telemetrySubSeq = new SCSequence();
            this.telemetryPubSeq.then(this.telemetrySubSeq).then(this.telemetryPubSeq);
        } else {
            this.telemetryQueue = null;
            this.telemetryPubSeq = null;
            this.telemetrySubSeq = null;
        }
        this.tableIdGenerator = new IDGenerator(configuration, "_tab_index.d");
        try {
            this.tableIdGenerator.open();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            DatabaseSnapshotAgent.recoverSnapshot(this);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            EngineMigration.migrateEngineTo(this, 426, false);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
        try {
            this.tableNameRegistry = configuration.isReadOnlyInstance() ? new TableNameRegistryRO(configuration) : new TableNameRegistryRW(configuration);
            this.tableNameRegistry.reloadTableNameCache();
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    public boolean clear() {
        boolean b1 = this.readerPool.releaseAll();
        boolean b2 = this.writerPool.releaseAll();
        boolean b3 = this.tableSequencerAPI.releaseAll();
        boolean b4 = this.metadataPool.releaseAll();
        boolean b5 = this.walWriterPool.releaseAll();
        this.messageBus.reset();
        return b1 & b2 & b3 & b4 & b5;
    }

    @Override
    public void close() {
        Misc.free(this.writerPool);
        Misc.free(this.readerPool);
        Misc.free(this.metadataPool);
        Misc.free(this.walWriterPool);
        Misc.free(this.tableIdGenerator);
        Misc.free(this.messageBus);
        Misc.free(this.tableSequencerAPI);
        Misc.free(this.telemetryQueue);
        Misc.free(this.tableNameRegistry);
    }

    public void closeNameRegistry() {
        this.tableNameRegistry.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableToken createTable(CairoSecurityContext securityContext, MemoryMARW mem, Path path, boolean ifNotExists, TableStructure struct, boolean keepLock) {
        TableToken tableToken;
        block16: {
            securityContext.checkWritePermission();
            CharSequence tableName = struct.getTableName();
            this.validNameOrThrow(tableName);
            int tableId = (int)this.tableIdGenerator.getNextId();
            tableToken = this.lockTableName(tableName, tableId, struct.isWalEnabled());
            if (tableToken == null) {
                if (ifNotExists) {
                    return null;
                }
                throw EntryUnavailableException.instance("table exists");
            }
            try {
                String lockedReason = this.lock(securityContext, tableToken, "createTable");
                if (null == lockedReason) {
                    boolean tableCreated = false;
                    try {
                        int status = TableUtils.exists(this.configuration.getFilesFacade(), path, this.configuration.getRoot(), tableToken.getDirName());
                        if (status != 1) {
                            throw CairoException.nonCritical().put("name is reserved [table=").put(tableName).put(']');
                        }
                        this.createTableUnsafe(securityContext, mem, path, struct, tableToken, tableId);
                        tableCreated = true;
                    }
                    finally {
                        if (!keepLock) {
                            this.unlockTableUnsafe(tableToken, null, tableCreated);
                            LOG.info().$("unlocked [table=`").$(tableToken).$("`]").$();
                        }
                    }
                    this.tableNameRegistry.registerName(tableToken);
                    break block16;
                }
                if (!ifNotExists) {
                    throw EntryUnavailableException.instance(lockedReason);
                }
            }
            catch (Throwable th) {
                if (struct.isWalEnabled()) {
                    this.tableSequencerAPI.dropTable(tableToken, true);
                }
                throw th;
            }
            finally {
                this.tableNameRegistry.unlockTableName(tableToken);
            }
        }
        return tableToken;
    }

    public void createTableUnsafe(CairoSecurityContext securityContext, MemoryMARW mem, Path path, TableStructure struct, TableToken tableToken, int tableId) {
        securityContext.checkWritePermission();
        FilesFacade ff = this.configuration.getFilesFacade();
        CharSequence root = this.configuration.getRoot();
        int mkDirMode = this.configuration.getMkDirMode();
        TableUtils.createTable(ff, root, mkDirMode, mem, path, tableToken.getDirName(), struct, 426, tableId);
        if (struct.isWalEnabled()) {
            this.tableSequencerAPI.registerTable(tableId, struct, tableToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(CairoSecurityContext securityContext, Path path, TableToken tableToken) {
        securityContext.checkWritePermission();
        this.verifyTableToken(tableToken);
        if (tableToken.isWal()) {
            if (this.tableNameRegistry.dropTable(tableToken)) {
                this.tableSequencerAPI.dropTable(tableToken, false);
            } else {
                LOG.info().$("table is already dropped [table=").$(tableToken).$(", dirName=").$(tableToken.getDirName()).I$();
            }
        } else {
            String lockedReason = this.lock(securityContext, tableToken, "removeTable");
            if (null == lockedReason) {
                try {
                    path.of(this.configuration.getRoot()).concat(tableToken).$();
                    int errno = this.configuration.getFilesFacade().rmdir(path);
                    if (errno != 0) {
                        LOG.error().$("drop failed [tableName='").$(tableToken).$("', error=").$(errno).I$();
                        throw CairoException.critical(errno).put("could not remove table [name=").put(tableToken).put(", dirName=").put(tableToken.getDirName()).put(']');
                    }
                }
                finally {
                    this.unlockTableUnsafe(tableToken, null, false);
                }
                this.tableNameRegistry.dropTable(tableToken);
                return;
            }
            throw CairoException.nonCritical().put("Could not lock '").put(tableToken).put("' [reason='").put(lockedReason).put("']");
        }
    }

    public TableWriter getBackupWriter(CairoSecurityContext securityContext, TableToken tableToken, CharSequence backupDirName) {
        securityContext.checkWritePermission();
        this.verifyTableToken(tableToken);
        return new TableWriter(this.configuration, tableToken, this.messageBus, null, true, DefaultLifecycleManager.INSTANCE, backupDirName, Metrics.disabled());
    }

    public int getBusyReaderCount() {
        return this.readerPool.getBusyCount();
    }

    public int getBusyWriterCount() {
        return this.writerPool.getBusyCount();
    }

    public long getCommandCorrelationId() {
        return this.asyncCommandCorrelationId.incrementAndGet();
    }

    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    public Job getEngineMaintenanceJob() {
        return this.engineMaintenanceJob;
    }

    public MessageBus getMessageBus() {
        return this.messageBus;
    }

    public TableRecordMetadata getMetadata(CairoSecurityContext securityContext, TableToken tableToken) {
        this.verifyTableToken(tableToken);
        try {
            return (TableRecordMetadata)this.metadataPool.get(tableToken);
        }
        catch (CairoException e) {
            this.tryRepairTable(securityContext, tableToken, e);
            return (TableRecordMetadata)this.metadataPool.get(tableToken);
        }
    }

    public TableRecordMetadata getMetadata(CairoSecurityContext securityContext, TableToken tableToken, long structureVersion) {
        this.verifyTableToken(tableToken);
        try {
            TableRecordMetadata metadata = (TableRecordMetadata)this.metadataPool.get(tableToken);
            if (structureVersion != -1L && metadata.getStructureVersion() != structureVersion) {
                TableReferenceOutOfDateException ex = TableReferenceOutOfDateException.of(tableToken, metadata.getTableId(), metadata.getTableId(), structureVersion, metadata.getStructureVersion());
                metadata.close();
                throw ex;
            }
            return metadata;
        }
        catch (CairoException e) {
            this.tryRepairTable(securityContext, tableToken, e);
            return (TableRecordMetadata)this.metadataPool.get(tableToken);
        }
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public PoolListener getPoolListener() {
        return this.writerPool.getPoolListener();
    }

    public TableReader getReader(CairoSecurityContext securityContext, TableToken tableToken) {
        this.verifyTableToken(tableToken);
        return (TableReader)this.readerPool.get(tableToken);
    }

    public TableReader getReader(CairoSecurityContext securityContext, TableToken tableToken, long version) {
        TableToken newTableToken = this.tableNameRegistry.getTableToken(tableToken.getTableName());
        if (newTableToken == null) {
            throw CairoException.tableDoesNotExist(tableToken.getTableName());
        }
        int tableId = tableToken.getTableId();
        if (tableId > -1 && newTableToken.getTableId() != tableId) {
            throw TableReferenceOutOfDateException.of(tableToken, tableId, newTableToken.getTableId(), version, -1L);
        }
        TableReader reader = (TableReader)this.readerPool.get(tableToken);
        if (version > -1L && reader.getVersion() != version || tableId > -1 && reader.getMetadata().getTableId() != tableId) {
            TableReferenceOutOfDateException ex = TableReferenceOutOfDateException.of(tableToken, tableId, reader.getMetadata().getTableId(), version, reader.getVersion());
            reader.close();
            throw ex;
        }
        return reader;
    }

    public Map<CharSequence, AbstractMultiTenantPool.Entry<ReaderPool.R>> getReaderPoolEntries() {
        return this.readerPool.entries();
    }

    public TableReader getReaderWithRepair(CairoSecurityContext securityContext, TableToken tableToken) {
        try {
            return this.getReader(securityContext, tableToken);
        }
        catch (CairoException e) {
            this.tryRepairTable(securityContext, tableToken, e);
            try {
                return this.getReader(securityContext, tableToken);
            }
            catch (CairoException e2) {
                LOG.critical().$("could not open reader [table=").$(tableToken).$(", errno=").$(e2.getErrno()).$(", error=").$(e2.getMessage()).I$();
                throw e2;
            }
        }
    }

    public int getStatus(CairoSecurityContext securityContext, Path path, TableToken tableToken) {
        if (tableToken == TableNameRegistry.LOCKED_TOKEN) {
            return 2;
        }
        if (tableToken == null || !tableToken.equals(this.tableNameRegistry.getTableToken(tableToken.getTableName()))) {
            return 1;
        }
        return TableUtils.exists(this.configuration.getFilesFacade(), path, this.configuration.getRoot(), tableToken.getDirName());
    }

    public IDGenerator getTableIdGenerator() {
        return this.tableIdGenerator;
    }

    public TableSequencerAPI getTableSequencerAPI() {
        return this.tableSequencerAPI;
    }

    public TableToken getTableToken(CharSequence tableName) {
        TableToken tableToken = this.tableNameRegistry.getTableToken(tableName);
        if (tableToken == null) {
            throw CairoException.tableDoesNotExist(tableName);
        }
        if (tableToken == TableNameRegistry.LOCKED_TOKEN) {
            throw CairoException.nonCritical().put("table name is reserved [table=").put(tableName).put("]");
        }
        return tableToken;
    }

    public TableToken getTableToken(CharSequence tableName, int lo, int hi) {
        StringSink sink = Misc.getThreadLocalBuilder();
        sink.put(tableName, lo, hi);
        return this.getTableToken(sink);
    }

    public TableToken getTableTokenByDirName(String dirName, int tableId) {
        return this.tableNameRegistry.getTableToken(dirName, tableId);
    }

    public TableToken getTableTokenByDirName(CharSequence dirName) {
        return this.tableNameRegistry.getTokenByDirName(dirName);
    }

    public TableToken getTableTokenIfExists(CharSequence tableName) {
        return this.tableNameRegistry.getTableToken(tableName);
    }

    public TableToken getTableTokenIfExists(CharSequence tableName, int lo, int hi) {
        StringSink sink = Misc.getThreadLocalBuilder();
        sink.put(tableName, lo, hi);
        return this.tableNameRegistry.getTableToken(sink);
    }

    public void getTableTokens(ObjList<TableToken> bucket, boolean includeDropped) {
        this.tableNameRegistry.getTableTokens(bucket, includeDropped);
    }

    @Override
    public TableWriterAPI getTableWriterAPI(CairoSecurityContext securityContext, TableToken tableToken, @Nullable String lockReason) {
        securityContext.checkWritePermission();
        this.verifyTableToken(tableToken);
        if (!tableToken.isWal()) {
            return this.writerPool.get(tableToken, lockReason);
        }
        return (TableWriterAPI)this.walWriterPool.get(tableToken);
    }

    public Sequence getTelemetryPubSequence() {
        return this.telemetryPubSeq;
    }

    public RingQueue<TelemetryTask> getTelemetryQueue() {
        return this.telemetryQueue;
    }

    public SCSequence getTelemetrySubSequence() {
        return this.telemetrySubSeq;
    }

    public TextImportExecutionContext getTextImportExecutionContext() {
        return this.textImportExecutionContext;
    }

    public long getUnpublishedWalTxnCount() {
        return this.unpublishedWalTxnCount.get();
    }

    public TableToken getUpdatedTableToken(TableToken tableToken) {
        return this.tableNameRegistry.getTokenByDirName(tableToken.getDirName());
    }

    public WalReader getWalReader(CairoSecurityContext securityContext, TableToken tableToken, CharSequence walName, int segmentId, long walRowCount) {
        if (tableToken.isWal()) {
            return new WalReader(this.configuration, tableToken, walName, segmentId, walRowCount);
        }
        throw CairoException.nonCritical().put("WAL reader is not supported for table ").put(tableToken);
    }

    @NotNull
    public WalWriter getWalWriter(CairoSecurityContext securityContext, TableToken tableToken) {
        securityContext.checkWritePermission();
        this.verifyTableToken(tableToken);
        return (WalWriter)this.walWriterPool.get(tableToken);
    }

    public TableWriter getWriter(CairoSecurityContext securityContext, TableToken tableToken, String lockReason) {
        securityContext.checkWritePermission();
        this.verifyTableToken(tableToken);
        return this.writerPool.get(tableToken, lockReason);
    }

    public TableWriter getWriterOrPublishCommand(CairoSecurityContext securityContext, TableToken tableToken, @NotNull AsyncWriterCommand asyncWriterCommand) {
        securityContext.checkWritePermission();
        this.verifyTableToken(tableToken);
        return this.writerPool.getWriterOrPublishCommand(tableToken, asyncWriterCommand.getCommandName(), asyncWriterCommand);
    }

    public TableWriter getWriterUnsafe(TableToken tableToken, String lockReason) {
        return this.writerPool.get(tableToken, lockReason);
    }

    public boolean isTableDropped(TableToken tableToken) {
        return this.tableNameRegistry.isTableDropped(tableToken);
    }

    public boolean isWalTable(TableToken tableToken) {
        return tableToken.isWal();
    }

    public String lock(CairoSecurityContext securityContext, TableToken tableToken, String lockReason) {
        assert (null != lockReason);
        securityContext.checkWritePermission();
        String lockedReason = BUSY_READER;
        if (this.metadataPool.lock(tableToken)) {
            lockedReason = this.writerPool.lock(tableToken, lockReason);
            if (lockedReason == null) {
                if (this.readerPool.lock(tableToken)) {
                    LOG.info().$("locked [table=`").utf8(tableToken.getDirName()).$("`, thread=").$(Thread.currentThread().getId()).I$();
                    return null;
                }
                this.writerPool.unlock(tableToken);
                lockedReason = BUSY_READER;
            }
            this.metadataPool.unlock(tableToken);
        }
        return lockedReason;
    }

    public boolean lockReaders(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        return this.readerPool.lock(tableToken);
    }

    public boolean lockReadersByTableToken(TableToken tableToken) {
        return this.readerPool.lock(tableToken);
    }

    public TableToken lockTableName(CharSequence tableName, boolean isWal) {
        this.validNameOrThrow(tableName);
        int tableId = (int)this.getTableIdGenerator().getNextId();
        return this.lockTableName(tableName, tableId, isWal);
    }

    @Nullable
    public TableToken lockTableName(CharSequence tableName, int tableId, boolean isWal) {
        String tableNameStr = Chars.toString(tableName);
        String dirName = TableUtils.getTableDir(this.configuration.mangleTableDirNames(), tableNameStr, tableId, isWal);
        return this.tableNameRegistry.lockTableName(tableNameStr, dirName, tableId, isWal);
    }

    public CharSequence lockWriter(CairoSecurityContext securityContext, TableToken tableToken, String lockReason) {
        securityContext.checkWritePermission();
        this.verifyTableToken(tableToken);
        return this.writerPool.lock(tableToken, lockReason);
    }

    public void notifyWalTxnCommitted(TableToken tableToken, long txn) {
        long cursor;
        Sequence pubSeq = this.messageBus.getWalTxnNotificationPubSequence();
        do {
            if ((cursor = pubSeq.next()) <= -1L) continue;
            WalTxnNotificationTask task = this.messageBus.getWalTxnNotificationQueue().get(cursor);
            task.of(tableToken, txn);
            pubSeq.done(cursor);
            return;
        } while (cursor != -1L);
        LOG.info().$("cannot publish WAL notifications, queue is full [current=").$(pubSeq.current()).$(", table=").utf8(tableToken.getDirName()).I$();
        this.notifyWalTxnRepublisher();
    }

    public void notifyWalTxnRepublisher() {
        this.unpublishedWalTxnCount.incrementAndGet();
    }

    public void registerTableToken(TableToken tableToken) {
        this.tableNameRegistry.registerName(tableToken);
    }

    public boolean releaseAllReaders() {
        boolean b1 = this.metadataPool.releaseAll();
        return this.readerPool.releaseAll() & b1;
    }

    public void releaseAllWriters() {
        this.writerPool.releaseAll();
    }

    public boolean releaseInactive() {
        boolean useful = this.writerPool.releaseInactive();
        useful |= this.readerPool.releaseInactive();
        useful |= this.tableSequencerAPI.releaseInactive();
        useful |= this.metadataPool.releaseInactive();
        return useful |= this.walWriterPool.releaseInactive();
    }

    public void releaseInactiveTableSequencers() {
        this.walWriterPool.releaseInactive();
        this.tableSequencerAPI.releaseInactive();
    }

    public void releaseReadersByTableToken(TableToken tableToken) {
        this.readerPool.unlock(tableToken);
    }

    public void reloadTableNames() {
        this.tableNameRegistry.reloadTableNameCache();
    }

    public int removeDirectory(Path path, CharSequence dir) {
        path.of(this.configuration.getRoot()).concat(dir);
        FilesFacade ff = this.configuration.getFilesFacade();
        return ff.rmdir(path.slash$());
    }

    public void removeTableToken(TableToken tableName) {
        this.tableNameRegistry.purgeToken(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableToken rename(CairoSecurityContext securityContext, Path path, MemoryMARW memory, CharSequence tableName, Path otherPath, CharSequence newName) {
        securityContext.checkWritePermission();
        this.validNameOrThrow(tableName);
        this.validNameOrThrow(newName);
        TableToken tableToken = this.getTableToken(tableName);
        if (tableToken != null) {
            TableToken newTableToken;
            if (tableToken.isWal()) {
                TableToken newTableToken2 = this.tableNameRegistry.rename(tableName, newName, tableToken);
                TableUtils.overwriteTableNameFile(path.of(this.configuration.getRoot()).concat(newTableToken2), memory, this.configuration.getFilesFacade(), newTableToken2);
                this.tableSequencerAPI.renameWalTable(tableToken, newTableToken2);
                return newTableToken2;
            }
            String lockedReason = this.lock(securityContext, tableToken, "renameTable");
            if (null == lockedReason) {
                try {
                    newTableToken = this.rename0(path, tableToken, tableName, otherPath, newName);
                    TableUtils.overwriteTableNameFile(path.of(this.configuration.getRoot()).concat(newTableToken), memory, this.configuration.getFilesFacade(), newTableToken);
                }
                finally {
                    this.unlock(securityContext, tableToken, null, false);
                }
            } else {
                LOG.error().$("cannot lock and rename [from='").$(tableName).$("', to='").$(newName).$("', reason='").$(lockedReason).$("']").$();
                throw EntryUnavailableException.instance(lockedReason);
            }
            this.tableNameRegistry.dropTable(tableToken);
            return newTableToken;
        }
        LOG.error().$('\'').utf8(tableName).$("' does not exist. Rename failed.").$();
        throw CairoException.nonCritical().put("Rename failed. Table '").put(tableName).put("' does not exist");
    }

    public void resetNameRegistryMemory() {
        this.tableNameRegistry.resetMemory();
    }

    public void setPoolListener(PoolListener poolListener) {
        this.metadataPool.setPoolListener(poolListener);
        this.writerPool.setPoolListener(poolListener);
        this.readerPool.setPoolListener(poolListener);
        this.walWriterPool.setPoolListener(poolListener);
    }

    public void unlock(CairoSecurityContext securityContext, TableToken tableToken, @Nullable TableWriter writer, boolean newTable) {
        this.verifyTableToken(tableToken);
        this.unlockTableUnsafe(tableToken, writer, newTable);
        LOG.info().$("unlocked [table=`").$(tableToken).$("`]").$();
    }

    public void unlockReaders(TableToken tableToken) {
        this.verifyTableToken(tableToken);
        this.readerPool.unlock(tableToken);
    }

    public void unlockTableName(TableToken tableToken) {
        this.tableNameRegistry.unlockTableName(tableToken);
    }

    public void unlockWriter(CairoSecurityContext securityContext, TableToken tableToken) {
        securityContext.checkWritePermission();
        this.verifyTableToken(tableToken);
        this.writerPool.unlock(tableToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableToken rename0(Path path, TableToken srcTableToken, CharSequence tableName, Path otherPath, CharSequence to) {
        FilesFacade ff = this.configuration.getFilesFacade();
        CharSequence root = this.configuration.getRoot();
        path.of(root).concat(srcTableToken).$();
        TableToken dstTableToken = this.lockTableName(to, srcTableToken.getTableId(), false);
        if (dstTableToken == null || ff.exists(otherPath.of(root).concat(dstTableToken).$())) {
            if (dstTableToken != null) {
                this.tableNameRegistry.unlockTableName(dstTableToken);
            }
            LOG.error().$("rename target exists [from='").utf8(tableName).$("', to='").utf8(otherPath.$()).I$();
            throw CairoException.nonCritical().put("Rename target exists");
        }
        try {
            if (ff.rename(path, otherPath) != 0) {
                int error = ff.errno();
                LOG.error().$("could not rename [from='").utf8(path).$("', to='").utf8(otherPath).$("', error=").$(error).I$();
                throw CairoException.critical(error).put("could not rename [from='").put(path).put("', to='").put(otherPath).put("', error=").put(error);
            }
            this.tableNameRegistry.registerName(dstTableToken);
            TableToken tableToken = dstTableToken;
            return tableToken;
        }
        finally {
            this.tableNameRegistry.unlockTableName(dstTableToken);
        }
    }

    private void tryRepairTable(CairoSecurityContext securityContext, TableToken tableToken, RuntimeException rethrow) {
        try {
            securityContext.checkWritePermission();
            this.writerPool.get(tableToken, "repair").close();
        }
        catch (EntryUnavailableException e) {
            throw rethrow;
        }
        catch (Throwable th) {
            LOG.critical().$("could not repair before reading [dirName=").utf8(tableToken.getDirName()).$(" ,error=").$(th.getMessage()).I$();
            throw rethrow;
        }
    }

    private void unlockTableUnsafe(TableToken tableToken, TableWriter writer, boolean newTable) {
        this.readerPool.unlock(tableToken);
        this.writerPool.unlock(tableToken, writer, newTable);
        this.metadataPool.unlock(tableToken);
    }

    private void validNameOrThrow(CharSequence tableName) {
        if (!TableUtils.isValidTableName(tableName, this.configuration.getMaxFileNameLength())) {
            throw CairoException.nonCritical().put("invalid table name [table=").putAsPrintable(tableName).put(']');
        }
    }

    private void verifyTableToken(TableToken tableToken) {
        TableToken newTableToken = this.tableNameRegistry.getTableToken(tableToken.getTableName());
        if (newTableToken == null) {
            throw CairoException.tableDoesNotExist(tableToken.getTableName());
        }
        if (!newTableToken.equals(tableToken)) {
            throw TableReferenceOutOfDateException.of(tableToken, tableToken.getTableId(), newTableToken.getTableId(), newTableToken.getTableId(), -1L);
        }
    }

    private class EngineMaintenanceJob
    extends SynchronizedJob {
        private final long checkInterval;
        private final MicrosecondClock clock;
        private long last = 0L;

        public EngineMaintenanceJob(CairoConfiguration configuration) {
            this.clock = configuration.getMicrosecondClock();
            this.checkInterval = configuration.getIdleCheckInterval() * 1000L;
        }

        @Override
        protected boolean runSerially() {
            long t = this.clock.getTicks();
            if (this.last + this.checkInterval < t) {
                this.last = t;
                return CairoEngine.this.releaseInactive();
            }
            return false;
        }
    }
}

