/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text.types;

import io.questdb.cairo.TableWriter;
import io.questdb.cutlass.text.TextUtil;
import io.questdb.cutlass.text.types.AbstractTypeAdapter;
import io.questdb.std.Mutable;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.DirectCharSink;

public class DateUtf8Adapter
extends AbstractTypeAdapter
implements Mutable {
    private final DirectCharSink utf8Sink;
    private DateFormat format;
    private DateLocale locale;

    public DateUtf8Adapter(DirectCharSink utf8Sink) {
        this.utf8Sink = utf8Sink;
    }

    @Override
    public void clear() {
        this.format = null;
        this.locale = null;
    }

    @Override
    public int getType() {
        return 7;
    }

    public DateUtf8Adapter of(DateFormat format, DateLocale locale) {
        this.format = format;
        this.locale = locale;
        return this;
    }

    @Override
    public boolean probe(DirectByteCharSequence text) {
        try {
            this.format.parse(text, this.locale);
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value, DirectCharSink utf8Sink) throws Exception {
        utf8Sink.clear();
        TextUtil.utf8DecodeEscConsecutiveQuotes(value.getLo(), value.getHi(), utf8Sink);
        row.putDate(column, this.format.parse(utf8Sink, this.locale));
    }

    @Override
    public void write(TableWriter.Row row, int column, DirectByteCharSequence value) throws Exception {
        this.write(row, column, value, this.utf8Sink);
    }
}

