/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.VirtualRecordNoRowid;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdater;
import io.questdb.griffin.engine.groupby.GroupByFunctionsUpdaterFactory;
import io.questdb.griffin.engine.groupby.GroupByUtils;
import io.questdb.griffin.engine.groupby.SimpleMapValue;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class GroupByNotKeyedRecordCursorFactory
extends AbstractRecordCursorFactory {
    protected final RecordCursorFactory base;
    private final GroupByNotKeyedRecordCursor cursor;
    private final ObjList<GroupByFunction> groupByFunctions;
    private final SimpleMapValue simpleMapValue;
    private final VirtualRecord virtualRecordA;

    public GroupByNotKeyedRecordCursorFactory(@NotNull BytecodeAssembler asm, RecordCursorFactory base, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions, int valueCount) {
        super(groupByMetadata);
        this.simpleMapValue = new SimpleMapValue(valueCount);
        this.base = base;
        this.groupByFunctions = groupByFunctions;
        this.virtualRecordA = new VirtualRecordNoRowid(recordFunctions);
        this.virtualRecordA.of(this.simpleMapValue);
        GroupByFunctionsUpdater updater = GroupByFunctionsUpdaterFactory.getInstance(asm, groupByFunctions);
        this.cursor = new GroupByNotKeyedRecordCursor(updater);
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            return this.cursor.of(baseCursor, executionContext);
        }
        catch (Throwable e) {
            Misc.free(baseCursor);
            throw e;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("GroupBy");
        sink.meta("vectorized").val(false);
        sink.optAttr("values", this.groupByFunctions, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    protected void _close() {
        Misc.freeObjList(this.groupByFunctions);
        Misc.free(this.base);
    }

    private class GroupByNotKeyedRecordCursor
    implements NoRandomAccessRecordCursor {
        private final GroupByFunctionsUpdater groupByFunctionsUpdater;
        private RecordCursor baseCursor;
        private int recordsRemaining = 1;

        public GroupByNotKeyedRecordCursor(GroupByFunctionsUpdater groupByFunctionsUpdater) {
            this.groupByFunctionsUpdater = groupByFunctionsUpdater;
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
            Misc.clearObjList(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions);
        }

        @Override
        public Record getRecord() {
            return GroupByNotKeyedRecordCursorFactory.this.virtualRecordA;
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return (SymbolTable)GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.getQuick(columnIndex);
        }

        @Override
        public boolean hasNext() {
            return this.recordsRemaining-- > 0;
        }

        @Override
        public SymbolTable newSymbolTable(int columnIndex) {
            return ((SymbolFunction)GroupByNotKeyedRecordCursorFactory.this.groupByFunctions.getQuick(columnIndex)).newSymbolTable();
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public void toTop() {
            this.recordsRemaining = 1;
            GroupByUtils.toTop(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions);
        }

        RecordCursor of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
            this.baseCursor = baseCursor;
            SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
            Record baseRecord = baseCursor.getRecord();
            Function.init(GroupByNotKeyedRecordCursorFactory.this.groupByFunctions, baseCursor, executionContext);
            if (baseCursor.hasNext()) {
                this.groupByFunctionsUpdater.updateNew(GroupByNotKeyedRecordCursorFactory.this.simpleMapValue, baseRecord);
                while (baseCursor.hasNext()) {
                    circuitBreaker.statefulThrowExceptionIfTripped();
                    this.groupByFunctionsUpdater.updateExisting(GroupByNotKeyedRecordCursorFactory.this.simpleMapValue, baseRecord);
                }
            } else {
                this.groupByFunctionsUpdater.updateEmpty(GroupByNotKeyedRecordCursorFactory.this.simpleMapValue);
            }
            this.toTop();
            return this;
        }
    }
}

