/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.Log;
import io.questdb.log.LogRecord;
import io.questdb.log.LogRecordSink;
import io.questdb.log.NullLogRecord;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.network.Net;
import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.str.StringSink;
import java.io.File;

public final class SyncLogger
implements LogRecord,
Log {
    private static final ThreadLocal<StringSink> line = new ThreadLocal<StringSink>(StringSink::new);
    private final RingQueue<LogRecordSink> advisoryRing;
    private final Sequence advisorySeq;
    private final MicrosecondClock clock;
    private final RingQueue<LogRecordSink> criticalRing;
    private final Sequence criticalSeq;
    private final RingQueue<LogRecordSink> debugRing;
    private final Sequence debugSeq;
    private final RingQueue<LogRecordSink> errorRing;
    private final Sequence errorSeq;
    private final RingQueue<LogRecordSink> infoRing;
    private final Sequence infoSeq;
    private final CharSequence name;

    SyncLogger(MicrosecondClock clock, CharSequence name, RingQueue<LogRecordSink> debugRing, Sequence debugSeq, RingQueue<LogRecordSink> infoRing, Sequence infoSeq, RingQueue<LogRecordSink> errorRing, Sequence errorSeq, RingQueue<LogRecordSink> criticalRing, Sequence criticalSeq, RingQueue<LogRecordSink> advisoryRing, Sequence advisorySeq) {
        this.clock = clock;
        this.name = name;
        this.debugRing = debugRing;
        this.debugSeq = debugSeq;
        this.infoRing = infoRing;
        this.infoSeq = infoSeq;
        this.errorRing = errorRing;
        this.errorSeq = errorSeq;
        this.criticalRing = criticalRing;
        this.criticalSeq = criticalSeq;
        this.advisoryRing = advisoryRing;
        this.advisorySeq = advisorySeq;
    }

    @Override
    public void $() {
        StringSink sink = line.get();
        System.out.println(sink);
        sink.clear();
    }

    @Override
    public LogRecord $(CharSequence sequence) {
        if (sequence == null) {
            this.sink().put("null");
        } else {
            this.sink().put(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $(CharSequence sequence, int lo, int hi) {
        this.sink().put(sequence, lo, hi);
        return this;
    }

    @Override
    public LogRecord $(int x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(double x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(long l) {
        this.sink().put(l);
        return this;
    }

    @Override
    public LogRecord $(boolean x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(char c) {
        this.sink().put(c);
        return this;
    }

    @Override
    public LogRecord $(Throwable e) {
        if (e != null) {
            this.sink().put("\r\n").put(e);
        }
        return this;
    }

    @Override
    public LogRecord $(File x) {
        this.sink().put(x == null ? "null" : x.getAbsolutePath());
        return this;
    }

    @Override
    public LogRecord $(Object x) {
        this.sink().put(x == null ? "null" : x.toString());
        return this;
    }

    @Override
    public LogRecord $(Sinkable x) {
        if (x == null) {
            this.sink().put("null");
        } else {
            x.toSink(this.sink());
        }
        return this;
    }

    @Override
    public LogRecord $256(long a, long b, long c, long d) {
        Numbers.appendLong256(a, b, c, d, this.sink());
        return this;
    }

    @Override
    public LogRecord $hex(long value) {
        Numbers.appendHex(this.sink(), value, false);
        return this;
    }

    @Override
    public LogRecord $hexPadded(long value) {
        Numbers.appendHex(this.sink(), value, true);
        return this;
    }

    @Override
    public LogRecord $ip(long ip) {
        Net.appendIP4(this.sink(), ip);
        return this;
    }

    @Override
    public LogRecord $ts(long x) {
        this.sink().putISODate(x);
        return this;
    }

    @Override
    public LogRecord $utf8(long lo, long hi) {
        Chars.utf8Decode(lo, hi, this);
        return this;
    }

    @Override
    public LogRecord advisory() {
        return this.addTimestamp(this.xadvisory(), " A ");
    }

    @Override
    public LogRecord advisoryW() {
        return this.addTimestamp(this.xAdvisoryW(), " A ");
    }

    @Override
    public LogRecord critical() {
        return this.addTimestamp(this.xcritical(), " C ");
    }

    @Override
    public LogRecord criticalW() {
        return this.addTimestamp(this.xCriticalW(), " C ");
    }

    @Override
    public LogRecord debug() {
        return this.addTimestamp(this.xdebug(), " D ");
    }

    @Override
    public LogRecord debugW() {
        return this.addTimestamp(this.xDebugW(), " D ");
    }

    @Override
    public LogRecord error() {
        return this.addTimestamp(this.xerror(), " E ");
    }

    @Override
    public LogRecord errorW() {
        return this.addTimestamp(this.xErrorW(), " E ");
    }

    @Override
    public LogRecord info() {
        return this.addTimestamp(this.xinfo(), " I ");
    }

    @Override
    public LogRecord infoW() {
        return this.addTimestamp(this.xInfoW(), " I ");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public LogRecord microTime(long x) {
        TimestampFormatUtils.appendDateTimeUSec(this.sink(), x);
        return this;
    }

    @Override
    public LogRecord put(char c) {
        this.sink().put(c);
        return this;
    }

    @Override
    public LogRecord ts() {
        this.sink().putISODate(this.clock.getTicks());
        return this;
    }

    @Override
    public LogRecord utf8(CharSequence sequence) {
        if (sequence == null) {
            this.sink().put("null");
        } else {
            this.sink().encodeUtf8(sequence);
        }
        return this;
    }

    public LogRecord xAdvisoryW() {
        return this.next(this.advisorySeq, this.advisoryRing, 16);
    }

    public LogRecord xCriticalW() {
        return this.next(this.criticalSeq, this.criticalRing, 8);
    }

    @Override
    public LogRecord xDebugW() {
        return this.next(this.debugSeq, this.debugRing, 1);
    }

    public LogRecord xErrorW() {
        return this.next(this.errorSeq, this.errorRing, 4);
    }

    @Override
    public LogRecord xInfoW() {
        return this.next(this.infoSeq, this.infoRing, 2);
    }

    @Override
    public LogRecord xadvisory() {
        return this.next(this.advisorySeq, this.advisoryRing, 16);
    }

    @Override
    public LogRecord xcritical() {
        return this.next(this.criticalSeq, this.criticalRing, 8);
    }

    @Override
    public LogRecord xdebug() {
        return this.next(this.debugSeq, this.debugRing, 1);
    }

    @Override
    public LogRecord xerror() {
        return this.next(this.errorSeq, this.errorRing, 4);
    }

    @Override
    public LogRecord xinfo() {
        return this.next(this.infoSeq, this.infoRing, 2);
    }

    private LogRecord addTimestamp(LogRecord rec, String level) {
        return rec.ts().$(level).$(this.name);
    }

    private LogRecord next(Sequence seq, RingQueue<LogRecordSink> ring, int level) {
        if (seq == null) {
            return NullLogRecord.INSTANCE;
        }
        return this;
    }

    private StringSink sink() {
        return line.get();
    }
}

