/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.tasks;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.std.Chars;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public class TableWriterTask
implements Closeable {
    public static final int CMD_ALTER_TABLE = 2;
    public static final int CMD_UNUSED = 1;
    public static final int CMD_UPDATE_TABLE = 3;
    public static final int TSK_BEGIN = 64;
    public static final int TSK_COMPLETE = 65;
    private final long data;
    private final long dataSize;
    private long appendLim;
    private long appendPtr;
    private AsyncWriterCommand cmd;
    private long instance;
    private long ip;
    private long tableId;
    private TableToken tableToken;
    private int type;

    public TableWriterTask(long data, long dataSize) {
        this.data = data;
        this.dataSize = dataSize;
        this.reset();
    }

    @Override
    public void close() {
        this.appendPtr = 0L;
        this.appendLim = 0L;
    }

    public AsyncWriterCommand getAsyncWriterCommand() {
        return this.cmd;
    }

    public long getData() {
        return this.data;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getInstance() {
        return this.instance;
    }

    public long getIp() {
        return this.ip;
    }

    public long getTableId() {
        return this.tableId;
    }

    public TableToken getTableToken() {
        return this.tableToken;
    }

    public int getType() {
        return this.type;
    }

    public void of(int type, long tableId, TableToken tableToken) {
        this.tableId = tableId;
        this.tableToken = tableToken;
        this.type = type;
        this.appendPtr = this.data;
        this.ip = 0L;
    }

    public void putByte(byte c) {
        this.checkCapacity(1L);
        Unsafe.getUnsafe().putByte(this.appendPtr++, c);
    }

    public void putInt(int value) {
        this.checkCapacity(4L);
        Unsafe.getUnsafe().putInt(this.appendPtr, value);
        this.appendPtr += 4L;
    }

    public void putLong(long value) {
        this.checkCapacity(8L);
        Unsafe.getUnsafe().putLong(this.appendPtr, value);
        this.appendPtr += 8L;
    }

    public void putShort(short value) {
        this.checkCapacity(2L);
        Unsafe.getUnsafe().putShort(this.appendPtr, value);
        this.appendPtr += 2L;
    }

    public void putStr(CharSequence value) {
        int len = value.length();
        int byteLen = len * 2 + 4;
        this.checkCapacity(byteLen);
        Unsafe.getUnsafe().putInt(this.appendPtr, len);
        Chars.copyStrChars(value, 0, len, this.appendPtr + 4L);
        this.appendPtr += (long)byteLen;
    }

    public void setAsyncWriterCommand(AsyncWriterCommand cmd) {
        this.cmd = cmd;
    }

    public void setInstance(long instance) {
        this.instance = instance;
    }

    public void setIp(long ip) {
        this.ip = ip;
    }

    public void setTableId(long tableId) {
        this.tableId = tableId;
    }

    private void checkCapacity(long byteCount) {
        if (this.appendPtr + byteCount > this.appendLim) {
            throw CairoException.critical(0).put("async command/event queue buffer overflow");
        }
    }

    private void reset() {
        this.appendPtr = this.data;
        this.appendLim = this.data + this.dataSize;
    }
}

