/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.registry;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.minifi.commons.schema.ConfigSchema;
import org.apache.nifi.minifi.commons.schema.ConnectionSchema;
import org.apache.nifi.minifi.commons.schema.ControllerServiceSchema;
import org.apache.nifi.minifi.commons.schema.ProcessorSchema;
import org.apache.nifi.minifi.commons.schema.RemoteProcessGroupSchema;
import org.apache.nifi.minifi.commons.schema.common.BaseSchemaWithId;
import org.apache.nifi.minifi.commons.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.commons.schema.common.CollectionUtil;
import org.apache.nifi.minifi.commons.schema.common.StringUtil;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegConnectionSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegControllerServiceSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegFlowControllerSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegFunnelSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegPortSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegProcessorSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegRemotePortSchemaFunction;
import org.apache.nifi.minifi.toolkit.configuration.registry.NiFiRegRemoteProcessGroupSchemaFunction;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;

public class NiFiRegConfigSchemaFunction
implements Function<VersionedFlowSnapshot, ConfigSchema> {
    private final NiFiRegFlowControllerSchemaFunction flowControllerSchemaFunction;
    private final NiFiRegProcessorSchemaFunction processorSchemaFunction;
    private final NiFiRegControllerServiceSchemaFunction controllerServiceSchemaFunction;
    private final NiFiRegConnectionSchemaFunction connectionSchemaFunction;
    private final NiFiRegFunnelSchemaFunction funnelSchemaFunction;
    private final NiFiRegRemoteProcessGroupSchemaFunction remoteProcessGroupSchemaFunction;
    private final NiFiRegPortSchemaFunction inputPortSchemaFunction;
    private final NiFiRegPortSchemaFunction outputPortSchemaFunction;

    public NiFiRegConfigSchemaFunction() {
        this(new NiFiRegFlowControllerSchemaFunction(), new NiFiRegProcessorSchemaFunction(), new NiFiRegControllerServiceSchemaFunction(), new NiFiRegConnectionSchemaFunction(), new NiFiRegFunnelSchemaFunction(), new NiFiRegRemoteProcessGroupSchemaFunction(new NiFiRegRemotePortSchemaFunction()), new NiFiRegPortSchemaFunction("Input Ports"), new NiFiRegPortSchemaFunction("Output Ports"));
    }

    public NiFiRegConfigSchemaFunction(NiFiRegFlowControllerSchemaFunction flowControllerSchemaFunction, NiFiRegProcessorSchemaFunction processorSchemaFunction, NiFiRegControllerServiceSchemaFunction controllerServiceSchemaFunction, NiFiRegConnectionSchemaFunction connectionSchemaFunction, NiFiRegFunnelSchemaFunction funnelSchemaFunction, NiFiRegRemoteProcessGroupSchemaFunction remoteProcessGroupSchemaFunction, NiFiRegPortSchemaFunction inputPortSchemaFunction, NiFiRegPortSchemaFunction outputPortSchemaFunction) {
        this.flowControllerSchemaFunction = flowControllerSchemaFunction;
        this.processorSchemaFunction = processorSchemaFunction;
        this.controllerServiceSchemaFunction = controllerServiceSchemaFunction;
        this.connectionSchemaFunction = connectionSchemaFunction;
        this.funnelSchemaFunction = funnelSchemaFunction;
        this.remoteProcessGroupSchemaFunction = remoteProcessGroupSchemaFunction;
        this.inputPortSchemaFunction = inputPortSchemaFunction;
        this.outputPortSchemaFunction = outputPortSchemaFunction;
    }

    @Override
    public ConfigSchema apply(VersionedFlowSnapshot versionedFlowSnapshot) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Flow Controller", this.flowControllerSchemaFunction.apply(versionedFlowSnapshot).toMap());
        VersionedProcessGroup versionedProcessGroup = versionedFlowSnapshot.getFlowContents();
        this.addVersionedProcessGroup(map, versionedProcessGroup);
        return new ConfigSchema(map);
    }

    protected void addVersionedProcessGroup(Map<String, Object> map, VersionedProcessGroup versionedProcessGroup) {
        this.addVersionedProcessGroup(map, null, null, versionedProcessGroup);
    }

    protected Map<String, Object> addVersionedProcessGroup(Map<String, Object> map, String id, String name, VersionedProcessGroup versionedProcessGroup) {
        if (!StringUtil.isNullOrEmpty((String)id)) {
            map.put("id", id);
        }
        if (!StringUtil.isNullOrEmpty((String)name)) {
            map.put("name", name);
        }
        map.put("Processors", CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getProcessors()).stream().map(this.processorSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(ProcessorSchema::toMap).collect(Collectors.toList()));
        map.put("Controller Services", CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getControllerServices()).stream().map(this.controllerServiceSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(ControllerServiceSchema::toMap).collect(Collectors.toList()));
        map.put("Connections", CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getConnections()).stream().map(this.connectionSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(ConnectionSchema::toMap).collect(Collectors.toList()));
        map.put("Funnels", CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getFunnels()).stream().map(this.funnelSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithId::getId)).map(BaseSchemaWithId::toMap).collect(Collectors.toList()));
        map.put("Remote Process Groups", CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getRemoteProcessGroups()).stream().map(this.remoteProcessGroupSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(RemoteProcessGroupSchema::toMap).collect(Collectors.toList()));
        map.put("Input Ports", CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getInputPorts()).stream().map(this.inputPortSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(BaseSchemaWithIdAndName::toMap).collect(Collectors.toList()));
        map.put("Output Ports", CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getOutputPorts()).stream().map(this.outputPortSchemaFunction).sorted(Comparator.comparing(BaseSchemaWithIdAndName::getName)).map(BaseSchemaWithIdAndName::toMap).collect(Collectors.toList()));
        map.put("Process Groups", CollectionUtil.nullToEmpty((Set)versionedProcessGroup.getProcessGroups()).stream().map(p -> this.addVersionedProcessGroup((Map<String, Object>)new HashMap<String, Object>(), p.getIdentifier(), p.getName(), (VersionedProcessGroup)p)).collect(Collectors.toList()));
        return map;
    }
}

