/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.analytics.models;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.regression.RegressionResults;
import org.apache.nifi.controller.status.analytics.models.BivariateStatusAnalyticsModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRegression
extends BivariateStatusAnalyticsModel {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRegression.class);
    private final org.apache.commons.math3.stat.regression.SimpleRegression regression = new org.apache.commons.math3.stat.regression.SimpleRegression();
    private final Boolean supportOnlineLearning;
    private RegressionResults results;

    public SimpleRegression() {
        this(true);
    }

    public SimpleRegression(Boolean supportOnlineLearning) {
        this.supportOnlineLearning = supportOnlineLearning;
    }

    @Override
    public void learn(Stream<Double[]> features, Stream<Double> labels) {
        double[] labelArray = ArrayUtils.toPrimitive((Double[])((Double[])labels.toArray(Double[]::new)));
        double[][] featuresMatrix = (double[][])features.map(feature -> ArrayUtils.toPrimitive((Double[])feature)).toArray(x$0 -> new double[x$0][]);
        if (!this.supportOnlineLearning.booleanValue()) {
            this.regression.clear();
        }
        this.regression.addObservations(featuresMatrix, labelArray);
        this.results = this.regression.regress();
        LOG.debug("Model is using equation: y = {}x + {}, with R-squared {}, RMSE {}", new Object[]{this.regression.getSlope(), this.regression.getIntercept(), this.results.getRSquared(), Math.sqrt(this.results.getMeanSquareError())});
    }

    @Override
    public Double predictX(Double y) {
        return (y - this.regression.getIntercept()) / this.regression.getSlope();
    }

    @Override
    public Double predictY(Double x) {
        return this.regression.getSlope() * x + this.regression.getIntercept();
    }

    @Override
    public Map<String, Double> getScores() {
        if (this.results == null) {
            return null;
        }
        HashMap<String, Double> scores = new HashMap<String, Double>();
        scores.put("rSquared", this.results.getRSquared());
        scores.put("adjustedRSquared", this.results.getAdjustedRSquared());
        scores.put("residualSumSquares", this.results.getErrorSumSquares());
        scores.put("meanSquareError", this.results.getMeanSquareError());
        return scores;
    }

    @Override
    public void clear() {
        this.results = null;
        this.regression.clear();
    }

    @Override
    public Boolean supportsOnlineLearning() {
        return this.supportOnlineLearning;
    }
}

