/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.resource;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.nifi.flow.resource.ExternalResourceProviderException;
import org.apache.nifi.flow.resource.ExternalResourceProviderService;
import org.apache.nifi.flow.resource.ExternalResourceProviderWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CompositeExternalResourceProviderService
implements ExternalResourceProviderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeExternalResourceProviderService.class);
    private final String name;
    private final Set<ExternalResourceProviderWorker> workers = new HashSet<ExternalResourceProviderWorker>();
    private final CountDownLatch restrainStartupLatch;
    private volatile boolean started = false;

    CompositeExternalResourceProviderService(String name, Set<ExternalResourceProviderWorker> workers, CountDownLatch restrainStartupLatch) {
        this.name = name;
        this.workers.addAll(workers);
        this.restrainStartupLatch = restrainStartupLatch;
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        LOGGER.info("Starting External Resource Provider Service ...");
        for (ExternalResourceProviderWorker worker : this.workers) {
            Thread workerThread = this.createThread(worker);
            workerThread.start();
        }
        try {
            if (this.restrainStartupLatch.getCount() > 0L) {
                LOGGER.info("Restrain startup until all providers execute the first fetch");
            }
            this.restrainStartupLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExternalResourceProviderException("Starting External Resource Provider Service is interrupted");
        }
        LOGGER.info("External Resource Provider Service is started successfully");
    }

    @Override
    public synchronized void stop() {
        this.started = false;
        if (this.workers != null) {
            this.workers.forEach(ExternalResourceProviderWorker::stop);
            this.workers.clear();
        }
        LOGGER.info("External Resource Provider Service is stopped");
    }

    private Thread createThread(ExternalResourceProviderWorker worker) {
        Thread thread = new Thread(worker);
        thread.setName("External Resource Provider Service -  " + this.name + " - " + worker.getName());
        thread.setDaemon(true);
        thread.setContextClassLoader(worker.getProvider().getClass().getClassLoader());
        return thread;
    }
}

