/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import org.apache.nifi.flow.VersionedFlowCoordinates;

public final class FlowDifferenceUtil {
    private FlowDifferenceUtil() {
    }

    public static boolean areRegistryStrictlyEqual(VersionedFlowCoordinates coordinatesA, VersionedFlowCoordinates coordinatesB) {
        String registryUrlA = coordinatesA.getRegistryUrl();
        String registryUrlB = coordinatesB.getRegistryUrl();
        return registryUrlA != null && registryUrlB != null && registryUrlA.equals(registryUrlB);
    }

    public static boolean areRegistryUrlsEqual(VersionedFlowCoordinates coordinatesA, VersionedFlowCoordinates coordinatesB) {
        String registryUrlA = coordinatesA.getRegistryUrl();
        String registryUrlB = coordinatesB.getRegistryUrl();
        if (registryUrlA != null && registryUrlB != null) {
            if (registryUrlA.equals(registryUrlB)) {
                return true;
            }
            String normalizedRegistryUrlA = registryUrlA.endsWith("/") ? registryUrlA.substring(0, registryUrlA.length() - 1) : registryUrlA;
            String normalizedRegistryUrlB = registryUrlB.endsWith("/") ? registryUrlB.substring(0, registryUrlB.length() - 1) : registryUrlB;
            return normalizedRegistryUrlA.equals(normalizedRegistryUrlB);
        }
        return false;
    }
}

