/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.protocol.http;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.nifi.remote.HttpRemoteSiteListener;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.Transaction;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.cluster.ClusterNodeInformation;
import org.apache.nifi.remote.cluster.NodeInformation;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.codec.StandardFlowFileCodec;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.io.http.HttpServerCommunicationsSession;
import org.apache.nifi.remote.protocol.AbstractFlowFileServerProtocol;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.FlowFileTransaction;
import org.apache.nifi.remote.protocol.HandshakeProperties;
import org.apache.nifi.remote.protocol.RequestType;
import org.apache.nifi.remote.protocol.Response;
import org.apache.nifi.remote.protocol.ResponseCode;
import org.apache.nifi.remote.protocol.http.HttpFlowFileServerProtocol;
import org.apache.nifi.stream.io.ByteArrayInputStream;
import org.apache.nifi.stream.io.ByteArrayOutputStream;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.StringUtils;

public class StandardHttpFlowFileServerProtocol
extends AbstractFlowFileServerProtocol
implements HttpFlowFileServerProtocol {
    public static final String RESOURCE_NAME = "HttpFlowFileProtocol";
    private final FlowFileCodec codec = new StandardFlowFileCodec();
    private final VersionNegotiator versionNegotiator;
    private final HttpRemoteSiteListener transactionManager;

    public StandardHttpFlowFileServerProtocol(VersionNegotiator versionNegotiator, NiFiProperties nifiProperties) {
        this.versionNegotiator = versionNegotiator;
        this.transactionManager = HttpRemoteSiteListener.getInstance(nifiProperties);
    }

    public FlowFileCodec negotiateCodec(Peer peer) throws IOException {
        return this.codec;
    }

    @Override
    public FlowFileCodec getPreNegotiatedCodec() {
        return this.codec;
    }

    @Override
    protected HandshakeProperties doHandshake(Peer peer) throws IOException, HandshakeException {
        HttpServerCommunicationsSession commsSession = (HttpServerCommunicationsSession)peer.getCommunicationsSession();
        String transactionId = commsSession.getTransactionId();
        HandshakeProperties confirmed = null;
        if (!StringUtils.isEmpty((String)transactionId)) {
            confirmed = this.transactionManager.getHandshakenProperties(transactionId);
        }
        if (confirmed == null) {
            confirmed = new HandshakeProperties();
            confirmed.setCommsIdentifier(transactionId);
            this.validateHandshakeRequest(confirmed, peer, commsSession.getHandshakeParams());
        }
        this.logger.debug("{} Done handshake, confirmed={}", (Object)this, (Object)confirmed);
        return confirmed;
    }

    @Override
    protected void writeTransactionResponse(boolean isTransfer, ResponseCode response, CommunicationsSession commsSession, String explanation) throws IOException {
        HttpServerCommunicationsSession commSession = (HttpServerCommunicationsSession)commsSession;
        commSession.setResponseCode(response);
        if (isTransfer) {
            switch (response) {
                case NO_MORE_DATA: {
                    this.logger.debug("{} There's no data to send.", (Object)this);
                    break;
                }
                case CONTINUE_TRANSACTION: {
                    this.logger.debug("{} Continue transaction... expecting more flow files.", (Object)this);
                    commSession.setStatus(Transaction.TransactionState.DATA_EXCHANGED);
                    break;
                }
                case BAD_CHECKSUM: {
                    this.logger.debug("{} Received BAD_CHECKSUM.", (Object)this);
                    commSession.setStatus(Transaction.TransactionState.ERROR);
                    break;
                }
                case CONFIRM_TRANSACTION: {
                    this.logger.debug("{} Transaction is confirmed.", (Object)this);
                    commSession.setStatus(Transaction.TransactionState.TRANSACTION_CONFIRMED);
                    break;
                }
                case FINISH_TRANSACTION: {
                    this.logger.debug("{} transaction is completed.", (Object)this);
                    commSession.setStatus(Transaction.TransactionState.TRANSACTION_COMPLETED);
                }
            }
        } else {
            switch (response) {
                case CONFIRM_TRANSACTION: {
                    this.logger.debug("{} Confirming transaction. checksum={}", (Object)this, (Object)explanation);
                    commSession.setChecksum(explanation);
                    commSession.setStatus(Transaction.TransactionState.DATA_EXCHANGED);
                    break;
                }
                case TRANSACTION_FINISHED: 
                case TRANSACTION_FINISHED_BUT_DESTINATION_FULL: {
                    this.logger.debug("{} Transaction is completed. responseCode={}", (Object)this, (Object)response);
                    commSession.setStatus(Transaction.TransactionState.TRANSACTION_COMPLETED);
                }
            }
        }
    }

    @Override
    protected Response readTransactionResponse(boolean isTransfer, CommunicationsSession commsSession) throws IOException {
        HttpServerCommunicationsSession commSession = (HttpServerCommunicationsSession)commsSession;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Transaction.TransactionState currentStatus = commSession.getStatus();
        if (isTransfer) {
            switch (currentStatus) {
                case DATA_EXCHANGED: {
                    String clientChecksum = commSession.getChecksum();
                    this.logger.debug("readTransactionResponse. clientChecksum={}", (Object)clientChecksum);
                    ResponseCode.CONFIRM_TRANSACTION.writeResponse(new DataOutputStream((OutputStream)bos), clientChecksum);
                    break;
                }
                case TRANSACTION_CONFIRMED: {
                    this.logger.debug("readTransactionResponse. finishing.");
                    ResponseCode.TRANSACTION_FINISHED.writeResponse(new DataOutputStream((OutputStream)bos));
                }
            }
        } else {
            switch (currentStatus) {
                case TRANSACTION_STARTED: {
                    this.logger.debug("readTransactionResponse. returning CONTINUE_TRANSACTION.");
                    ResponseCode.CONTINUE_TRANSACTION.writeResponse(new DataOutputStream((OutputStream)bos));
                    break;
                }
                case TRANSACTION_CONFIRMED: {
                    ResponseCode responseCode = commSession.getResponseCode();
                    this.logger.debug("readTransactionResponse. responseCode={}", (Object)responseCode);
                    if (responseCode.containsMessage()) {
                        responseCode.writeResponse(new DataOutputStream((OutputStream)bos), "");
                        break;
                    }
                    responseCode.writeResponse(new DataOutputStream((OutputStream)bos));
                }
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        return Response.read((DataInputStream)new DataInputStream((InputStream)bis));
    }

    private int holdTransaction(Peer peer, FlowFileTransaction transaction) {
        HttpServerCommunicationsSession commSession = (HttpServerCommunicationsSession)peer.getCommunicationsSession();
        String transactionId = commSession.getTransactionId();
        this.logger.debug("{} Holding transaction. transactionId={}", (Object)this, (Object)transactionId);
        this.transactionManager.holdTransaction(transactionId, transaction, this.handshakeProperties);
        return transaction.getFlowFilesSent().size();
    }

    @Override
    protected int commitTransferTransaction(Peer peer, FlowFileTransaction transaction) throws IOException {
        return this.holdTransaction(peer, transaction);
    }

    @Override
    public int commitTransferTransaction(Peer peer, String clientChecksum) throws IOException, IllegalStateException {
        this.logger.debug("{} Committing the transfer transaction. peer={} clientChecksum={}", new Object[]{this, peer, clientChecksum});
        HttpServerCommunicationsSession commSession = (HttpServerCommunicationsSession)peer.getCommunicationsSession();
        String transactionId = commSession.getTransactionId();
        FlowFileTransaction transaction = this.transactionManager.finalizeTransaction(transactionId);
        commSession.setChecksum(clientChecksum);
        commSession.setStatus(Transaction.TransactionState.DATA_EXCHANGED);
        return super.commitTransferTransaction(peer, transaction);
    }

    @Override
    protected int commitReceiveTransaction(Peer peer, FlowFileTransaction transaction) throws IOException {
        return this.holdTransaction(peer, transaction);
    }

    @Override
    public int commitReceiveTransaction(Peer peer) throws IOException, IllegalStateException {
        this.logger.debug("{} Committing the receive transaction. peer={}", (Object)this, (Object)peer);
        HttpServerCommunicationsSession commSession = (HttpServerCommunicationsSession)peer.getCommunicationsSession();
        String transactionId = commSession.getTransactionId();
        FlowFileTransaction transaction = this.transactionManager.finalizeTransaction(transactionId);
        commSession.setStatus(Transaction.TransactionState.TRANSACTION_CONFIRMED);
        return super.commitReceiveTransaction(peer, transaction);
    }

    public RequestType getRequestType(Peer peer) throws IOException {
        return null;
    }

    public VersionNegotiator getVersionNegotiator() {
        return this.versionNegotiator;
    }

    public void sendPeerList(Peer peer, Optional<ClusterNodeInformation> clusterNodeInfo, NodeInformation self) throws IOException {
    }

    public String getResourceName() {
        return RESOURCE_NAME;
    }
}

