/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.AccessPolicyProviderFactory;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.nar.NarCloseable;

public class AuthorizerInvocationHandler
implements InvocationHandler {
    private static final Method getAccessPolicyProviderMethod;
    private final Authorizer authorizer;
    private final ClassLoader classLoader;

    public AuthorizerInvocationHandler(Authorizer authorizer, ClassLoader classLoader) {
        this.authorizer = authorizer;
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            if (getAccessPolicyProviderMethod.equals(method)) {
                AccessPolicyProvider accessPolicyProvider = (AccessPolicyProvider)method.invoke((Object)this.authorizer, args);
                if (accessPolicyProvider == null) {
                    AccessPolicyProvider accessPolicyProvider2 = accessPolicyProvider;
                    return accessPolicyProvider2;
                }
                AccessPolicyProvider accessPolicyProvider3 = AccessPolicyProviderFactory.withNarLoader(accessPolicyProvider, this.classLoader);
                return accessPolicyProvider3;
            }
            Object object = method.invoke((Object)this.authorizer, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        try {
            getAccessPolicyProviderMethod = ManagedAuthorizer.class.getMethod("getAccessPolicyProvider", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain necessary class information for AccessPolicyProvider", e);
        }
    }
}

