/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.IOException;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.authorization.AccessPolicy;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.PoliciesClient;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractCRUDJerseyClient;

public class JerseyPoliciesClient
extends AbstractCRUDJerseyClient
implements PoliciesClient {
    public static final String ACCESS_POLICY = "Access policy";
    public static final String POLICIES_PATH = "policies";

    public JerseyPoliciesClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyPoliciesClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(baseTarget, requestConfig);
    }

    @Override
    public AccessPolicy getAccessPolicy(String action, String resource) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)resource) || StringUtils.isBlank((CharSequence)action)) {
            throw new IllegalArgumentException("Resource and action cannot be null");
        }
        return this.executeAction("Error retrieving access policy", () -> {
            WebTarget target = this.baseTarget.path(POLICIES_PATH).path(action).path(resource);
            return (AccessPolicy)this.getRequestBuilder(target).get(AccessPolicy.class);
        });
    }

    @Override
    public AccessPolicy createAccessPolicy(AccessPolicy policy) throws NiFiRegistryException, IOException {
        return this.create(policy, AccessPolicy.class, ACCESS_POLICY, POLICIES_PATH);
    }

    @Override
    public AccessPolicy updateAccessPolicy(AccessPolicy policy) throws NiFiRegistryException, IOException {
        return this.update(policy, policy.getIdentifier(), AccessPolicy.class, ACCESS_POLICY, POLICIES_PATH);
    }
}

