/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.Updatable;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UpdatableCachedInstanceIterable
extends CachedInstanceIterable
implements Updatable {
    protected UpdatableCachedInstanceIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        super(txn, source);
    }

    @Override
    protected CachedInstanceIterable orderById() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public Updatable beginUpdate(@NotNull PersistentStoreTransaction txn) {
        UpdatableCachedInstanceIterable result = this.beginUpdate();
        txn.registerMutatedHandle(this.getHandle(), result);
        return result;
    }

    public abstract UpdatableCachedInstanceIterable beginUpdate();

    @Override
    public abstract boolean isMutated();

    @Override
    public void endUpdate(@NotNull PersistentStoreTransaction txn) {
        this.endUpdate();
        txn.getStore().getEntityIterableCache().setCachedCount(this.getHandle(), this.size());
    }

    public abstract void endUpdate();
}

