/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;

public class FileUtils {
    public static final long TRANSFER_CHUNK_SIZE_BYTES = 0x800000L;
    public static final long MILLIS_BETWEEN_ATTEMPTS = 50L;
    private static final int[] INVALID_CHARS = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47, 32};

    public static void closeQuietly(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void releaseQuietly(FileLock lock) {
        if (null != lock) {
            try {
                lock.release();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public static void ensureDirectoryExistAndCanAccess(File dir) throws IOException {
        FileUtils.ensureDirectoryExistAndCanReadAndWrite(dir);
    }

    public static void ensureDirectoryExistAndCanReadAndWrite(File dir) throws IOException {
        boolean made;
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException(dir.getAbsolutePath() + " is not a directory");
        }
        if (!dir.exists() && !(made = dir.mkdirs())) {
            throw new IOException(dir.getAbsolutePath() + " could not be created");
        }
        if (!dir.canRead() || !dir.canWrite()) {
            throw new IOException(dir.getAbsolutePath() + " directory does not have read/write privilege");
        }
    }

    public static void ensureDirectoryExistAndCanRead(File dir) throws IOException {
        boolean made;
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException(dir.getAbsolutePath() + " is not a directory");
        }
        if (!dir.exists() && !(made = dir.mkdirs())) {
            throw new IOException(dir.getAbsolutePath() + " could not be created");
        }
        if (!dir.canRead()) {
            throw new IOException(dir.getAbsolutePath() + " directory does not have read privilege");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long copyFile(File source, File destination, boolean lockInputFile, boolean lockOutputFile, boolean move, Logger logger) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileLock inLock = null;
        FileLock outLock = null;
        long fileSize = 0L;
        if (!source.canRead()) {
            throw new IOException("Must at least have read permission");
        }
        if (move && source.renameTo(destination)) {
            return destination.length();
        }
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(destination);
            FileChannel in = fis.getChannel();
            FileChannel out = fos.getChannel();
            if (lockInputFile && null == (inLock = in.tryLock(0L, Long.MAX_VALUE, true))) {
                throw new IOException("Unable to obtain shared file lock for: " + source.getAbsolutePath());
            }
            if (lockOutputFile && null == (outLock = out.tryLock(0L, Long.MAX_VALUE, false))) {
                throw new IOException("Unable to obtain exclusive file lock for: " + destination.getAbsolutePath());
            }
            long bytesWritten = 0L;
            while ((bytesWritten += out.transferFrom(in, bytesWritten, 0x800000L)) < (fileSize = in.size())) {
            }
            out.force(false);
            FileUtils.closeQuietly(fos);
            FileUtils.closeQuietly(fis);
            fos = null;
            fis = null;
            if (move && !FileUtils.deleteFile(source, null, 5)) {
                if (logger == null) {
                    FileUtils.deleteFile(destination, null, 5);
                    throw new IOException("Could not remove file " + source.getAbsolutePath());
                }
                logger.warn("Configured to delete source file when renaming/move not successful.  However, unable to delete file at: " + source.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            FileUtils.releaseQuietly(inLock);
            FileUtils.releaseQuietly(outLock);
            FileUtils.closeQuietly(fos);
            FileUtils.closeQuietly(fis);
            throw throwable;
        }
        FileUtils.releaseQuietly(inLock);
        FileUtils.releaseQuietly(outLock);
        FileUtils.closeQuietly(fos);
        FileUtils.closeQuietly(fis);
        return fileSize;
    }

    public static long copyFile(File source, File destination, boolean lockInputFile, boolean lockOutputFile, Logger logger) throws FileNotFoundException, IOException {
        return FileUtils.copyFile(source, destination, lockInputFile, lockOutputFile, false, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(File source, OutputStream stream, boolean closeOutputStream, boolean lockInputFile) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        FileLock inLock = null;
        long fileSize = 0L;
        try {
            fis = new FileInputStream(source);
            FileChannel in = fis.getChannel();
            if (lockInputFile && (inLock = in.tryLock(0L, Long.MAX_VALUE, true)) == null) {
                throw new IOException("Unable to obtain exclusive file lock for: " + source.getAbsolutePath());
            }
            byte[] buffer = new byte[262144];
            int bytesRead = -1;
            while ((bytesRead = fis.read(buffer)) != -1) {
                stream.write(buffer, 0, bytesRead);
            }
            in.force(false);
            stream.flush();
            fileSize = in.size();
        }
        catch (Throwable throwable) {
            FileUtils.releaseQuietly(inLock);
            FileUtils.closeQuietly(fis);
            if (closeOutputStream) {
                FileUtils.closeQuietly(stream);
            }
            throw throwable;
        }
        FileUtils.releaseQuietly(inLock);
        FileUtils.closeQuietly(fis);
        if (closeOutputStream) {
            FileUtils.closeQuietly(stream);
        }
        return fileSize;
    }

    public static long copyFile(InputStream stream, File destination, boolean closeInputStream, boolean lockOutputFile) throws FileNotFoundException, IOException {
        Path destPath = destination.toPath();
        long size = Files.copy(stream, destPath, new CopyOption[0]);
        if (closeInputStream) {
            stream.close();
        }
        return size;
    }

    public static boolean deleteFile(File file, Logger logger) {
        return FileUtils.deleteFile(file, logger, 1);
    }

    public static boolean deleteFile(File file, Logger logger, int attempts) {
        boolean isGone;
        block6: {
            if (file == null) {
                return false;
            }
            isGone = false;
            try {
                if (file.exists()) {
                    int effectiveAttempts = Math.max(1, attempts);
                    for (int i = 0; i < effectiveAttempts && !isGone; ++i) {
                        boolean bl = isGone = file.delete() || !file.exists();
                        if (isGone || effectiveAttempts - i <= 1) continue;
                        FileUtils.sleepQuietly(50L);
                    }
                    if (!isGone && logger != null) {
                        logger.warn("File appears to exist but unable to delete file: " + file.getAbsolutePath());
                    }
                }
            }
            catch (Throwable t) {
                if (logger == null) break block6;
                logger.warn("Unable to delete file: '" + file.getAbsolutePath() + "' due to " + t);
            }
        }
        return isGone;
    }

    public static void deleteFilesInDirectory(File directory, FilenameFilter filter, Logger logger) throws IOException {
        FileUtils.deleteFilesInDirectory(directory, filter, logger, false);
    }

    public static void deleteFilesInDirectory(File directory, FilenameFilter filter, Logger logger, boolean recurse) throws IOException {
        FileUtils.deleteFilesInDirectory(directory, filter, logger, recurse, false);
    }

    public static void deleteFilesInDirectory(File directory, FilenameFilter filter, Logger logger, boolean recurse, boolean deleteEmptyDirectories) throws IOException {
        if (null != directory && directory.isDirectory()) {
            File[] ingestFiles = directory.listFiles();
            if (ingestFiles == null) {
                throw new IOException("Unable to list directory content in: " + directory.getAbsolutePath());
            }
            for (File ingestFile : ingestFiles) {
                boolean process;
                boolean bl = process = filter == null ? true : filter.accept(directory, ingestFile.getName());
                if (ingestFile.isFile() && process) {
                    FileUtils.deleteFile(ingestFile, logger, 3);
                }
                if (!ingestFile.isDirectory() || !recurse) continue;
                FileUtils.deleteFilesInDirectory(ingestFile, filter, logger, recurse, deleteEmptyDirectories);
                if (!deleteEmptyDirectories || ingestFile.list().length != 0) continue;
                FileUtils.deleteFile(ingestFile, logger, 3);
            }
        }
    }

    public static void deleteFiles(Collection<File> files, boolean recurse) throws IOException {
        for (File file : files) {
            FileUtils.deleteFile(file, recurse);
        }
    }

    public static void deleteFile(File file, boolean recurse) throws IOException {
        File[] list = file.listFiles();
        if (file.isDirectory() && recurse && list != null) {
            FileUtils.deleteFiles(Arrays.asList(list), recurse);
        }
        if (!FileUtils.deleteFile(file, null, 5)) {
            throw new IOException("Unable to delete " + file.getAbsolutePath());
        }
    }

    public static void sleepQuietly(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String sanitizeFilename(String filename) {
        if (filename == null || filename.isEmpty()) {
            return filename;
        }
        int codePointCount = filename.codePointCount(0, filename.length());
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < codePointCount; ++i) {
            int c = filename.codePointAt(i);
            if (Arrays.binarySearch(INVALID_CHARS, c) < 0) {
                cleanName.appendCodePoint(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString();
    }

    static {
        Arrays.sort(INVALID_CHARS);
    }
}

