/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties.scheme;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import org.apache.nifi.properties.scheme.PropertyProtectionScheme;
import org.apache.nifi.properties.scheme.ProtectionScheme;
import org.apache.nifi.properties.scheme.ProtectionSchemeResolver;

public class StandardProtectionSchemeResolver
implements ProtectionSchemeResolver {
    public ProtectionScheme getProtectionScheme(String scheme) {
        Objects.requireNonNull(scheme, "Scheme required");
        return Arrays.stream(PropertyProtectionScheme.values()).filter(propertyProtectionScheme -> propertyProtectionScheme.name().equals(scheme) || scheme.startsWith(propertyProtectionScheme.getPath())).findFirst().orElseThrow(() -> new SensitivePropertyProtectionException(String.format("Protection Scheme [%s] not supported", scheme)));
    }

    public List<String> getSupportedProtectionSchemes() {
        return Arrays.stream(PropertyProtectionScheme.values()).map(Enum::name).collect(Collectors.toList());
    }
}

