/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.registry.params.SortOrder;
import org.apache.nifi.registry.params.SortParameter;

public class QueryParameters {
    public static final QueryParameters EMPTY_PARAMETERS = new Builder().build();
    private final Integer pageNum;
    private final Integer numRows;
    private final List<SortParameter> sortParameters;

    private QueryParameters(Builder builder) {
        this.pageNum = builder.pageNum;
        this.numRows = builder.numRows;
        this.sortParameters = Collections.unmodifiableList(new ArrayList(builder.sortParameters));
        if (this.pageNum != null && this.numRows != null) {
            if (this.pageNum < 0) {
                throw new IllegalStateException("Offset cannot be negative");
            }
            if (this.numRows < 0) {
                throw new IllegalStateException("Number of rows cannot be negative");
            }
        }
    }

    public Integer getPageNum() {
        return this.pageNum;
    }

    public Integer getNumRows() {
        return this.numRows;
    }

    public List<SortParameter> getSortParameters() {
        return this.sortParameters;
    }

    public static class Builder {
        private Integer pageNum;
        private Integer numRows;
        private List<SortParameter> sortParameters = new ArrayList<SortParameter>();

        public Builder pageNum(Integer pageNum) {
            this.pageNum = pageNum;
            return this;
        }

        public Builder numRows(Integer numRows) {
            this.numRows = numRows;
            return this;
        }

        public Builder addSort(SortParameter sort) {
            this.sortParameters.add(sort);
            return this;
        }

        public Builder addSort(String fieldName, SortOrder order) {
            this.sortParameters.add(new SortParameter(fieldName, order));
            return this;
        }

        public Builder addSorts(Collection<SortParameter> sorts) {
            if (sorts != null) {
                this.sortParameters.addAll(sorts);
            }
            return this;
        }

        public Builder clearSorts() {
            this.sortParameters.clear();
            return this;
        }

        public QueryParameters build() {
            return new QueryParameters(this);
        }
    }
}

