/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.core.dataStructures.persistent.PersistentHashSet;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionBase;
import jetbrains.exodus.env.TransactionalExecutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TransactionSet {
    private final AtomicReference<MinMaxAwareSnapshotSet> snapshots = new AtomicReference<MinMaxAwareSnapshotSet>(new MinMaxAwareSnapshotSet());

    TransactionSet() {
    }

    void forEach(@NotNull TransactionalExecutable executable) {
        for (Snapshot snapshot : this.getCurrent()) {
            executable.execute(snapshot.txn);
        }
    }

    void add(@NotNull TransactionBase txn) {
        Snapshot prevMax;
        Snapshot newMax;
        Snapshot prevMin;
        Snapshot newMin;
        PersistentHashSet newSet;
        MinMaxAwareSnapshotSet prevSet;
        Snapshot snapshot = new Snapshot(txn, txn.getRoot());
        do {
            prevSet = this.snapshots.get();
            newSet = prevSet.set.getClone();
            if (newSet.contains((Object)snapshot)) continue;
            PersistentHashSet.MutablePersistentHashSet mutableSet = newSet.beginWrite();
            mutableSet.add((Object)snapshot);
            mutableSet.endWrite();
        } while (!this.snapshots.compareAndSet(prevSet, new MinMaxAwareSnapshotSet((PersistentHashSet<Snapshot>)newSet, newMin = (prevMin = prevSet.min) != null && prevMin.root > snapshot.root ? snapshot : prevMin, newMax = (prevMax = prevSet.max) != null && prevMax.root < snapshot.root ? snapshot : prevMax)));
    }

    boolean contains(@NotNull TransactionBase txn) {
        return this.getCurrent().contains((Object)new Snapshot(txn, 0L));
    }

    void remove(@NotNull TransactionBase txn) {
        Snapshot prevMax;
        Snapshot newMax;
        Snapshot prevMin;
        Snapshot newMin;
        PersistentHashSet newSet;
        MinMaxAwareSnapshotSet prevSet;
        Snapshot snapshot = new Snapshot(txn, 0L);
        do {
            prevSet = this.snapshots.get();
            newSet = prevSet.set.getClone();
            PersistentHashSet.MutablePersistentHashSet mutableSet = newSet.beginWrite();
            if (!mutableSet.remove((Object)snapshot)) break;
            mutableSet.endWrite();
            prevMin = prevSet.min;
            prevMax = prevSet.max;
        } while (!this.snapshots.compareAndSet(prevSet, new MinMaxAwareSnapshotSet((PersistentHashSet<Snapshot>)newSet, newMin = Objects.equals(prevMin, snapshot) ? null : prevMin, newMax = Objects.equals(prevMax, snapshot) ? null : prevMax)));
    }

    boolean isEmpty() {
        return this.getCurrent().isEmpty();
    }

    int size() {
        return this.getCurrent().size();
    }

    long getOldestTxnRootAddress() {
        Snapshot oldestSnapshot = this.snapshots.get().getMin();
        return oldestSnapshot == null ? Long.MAX_VALUE : oldestSnapshot.root;
    }

    long getNewestTxnRootAddress() {
        Snapshot newestSnapshot = this.snapshots.get().getMax();
        return newestSnapshot == null ? Long.MIN_VALUE : newestSnapshot.root;
    }

    @NotNull
    private PersistentHashSet<Snapshot> getCurrent() {
        return this.snapshots.get().set;
    }

    private static class Snapshot {
        @NotNull
        final Transaction txn;
        final long root;

        Snapshot(@NotNull Transaction txn, long root) {
            this.txn = txn;
            this.root = root;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Snapshot && this.txn.equals(((Snapshot)other).txn);
        }

        public int hashCode() {
            return this.txn.hashCode();
        }
    }

    private static class MinMaxAwareSnapshotSet {
        @NotNull
        final PersistentHashSet<Snapshot> set;
        @Nullable
        volatile Snapshot min;
        @Nullable
        volatile Snapshot max;

        MinMaxAwareSnapshotSet(@NotNull PersistentHashSet<Snapshot> set, @Nullable Snapshot min, @Nullable Snapshot max) {
            this.set = set;
            this.min = min;
            this.max = max;
        }

        MinMaxAwareSnapshotSet() {
            this((PersistentHashSet<Snapshot>)new PersistentHashSet(), null, null);
        }

        @Nullable
        Snapshot getMin() {
            if (this.min == null) {
                Snapshot min = null;
                for (Snapshot snapshot : this.set) {
                    if (min != null && snapshot.root >= min.root) continue;
                    min = snapshot;
                }
                this.min = min;
            }
            return this.min;
        }

        @Nullable
        Snapshot getMax() {
            if (this.max == null) {
                Snapshot max = null;
                for (Snapshot snapshot : this.set) {
                    if (max != null && snapshot.root <= max.root) continue;
                    max = snapshot;
                }
                this.max = max;
            }
            return this.max;
        }
    }
}

