/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import v14.h2.constraint.Constraint;
import v14.h2.constraint.ConstraintActionType;
import v14.h2.constraint.ConstraintCheck;
import v14.h2.constraint.ConstraintReferential;
import v14.h2.constraint.ConstraintUnique;
import v14.h2.engine.Constants;
import v14.h2.engine.Database;
import v14.h2.engine.DbObject;
import v14.h2.engine.Domain;
import v14.h2.engine.FunctionAlias;
import v14.h2.engine.Mode;
import v14.h2.engine.QueryStatisticsData;
import v14.h2.engine.Right;
import v14.h2.engine.Role;
import v14.h2.engine.Session;
import v14.h2.engine.User;
import v14.h2.index.Index;
import v14.h2.index.IndexType;
import v14.h2.index.MetaIndex;
import v14.h2.message.DbException;
import v14.h2.result.Row;
import v14.h2.result.SearchRow;
import v14.h2.schema.Constant;
import v14.h2.schema.Schema;
import v14.h2.schema.SchemaObject;
import v14.h2.schema.Sequence;
import v14.h2.schema.TriggerObject;
import v14.h2.store.InDoubtTransaction;
import v14.h2.table.Column;
import v14.h2.table.IndexColumn;
import v14.h2.table.Table;
import v14.h2.table.TableSynonym;
import v14.h2.table.TableType;
import v14.h2.table.TableView;
import v14.h2.tools.Csv;
import v14.h2.util.DateTimeUtils;
import v14.h2.util.MathUtils;
import v14.h2.util.StringUtils;
import v14.h2.util.Utils;
import v14.h2.value.CompareMode;
import v14.h2.value.DataType;
import v14.h2.value.Value;
import v14.h2.value.ValueBoolean;
import v14.h2.value.ValueDouble;
import v14.h2.value.ValueInt;
import v14.h2.value.ValueLong;
import v14.h2.value.ValueNull;
import v14.h2.value.ValueShort;
import v14.h2.value.ValueString;
import v14.h2.value.ValueStringIgnoreCase;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int SYNONYMS = 29;
    private static final int TABLE_CONSTRAINTS = 30;
    private static final int KEY_COLUMN_USAGE = 31;
    private static final int REFERENTIAL_CONSTRAINTS = 32;
    private static final int META_TABLE_TYPE_COUNT = 33;
    private final int type;
    private final int indexColumn;
    private final MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string = null;
        switch (n2) {
            case 0: {
                this.setMetaTableName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS", "ROW_COUNT_ESTIMATE BIGINT");
                string = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setMetaTableName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "DATETIME_PRECISION INT", "INTERVAL_TYPE", "INTERVAL_PRECISION INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT", "COLUMN_TYPE", "COLUMN_ON_UPDATE", "IS_VISIBLE");
                string = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setMetaTableName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS", "AFFINITY BIT");
                string = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setMetaTableName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setMetaTableName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setMetaTableName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setMetaTableName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setMetaTableName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setMetaTableName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "MIN_VALUE BIGINT", "MAX_VALUE BIGINT", "IS_CYCLE BIT", "ID INT");
                break;
            }
            case 9: {
                this.setMetaTableName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setMetaTableName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setMetaTableName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setMetaTableName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "TYPE_NAME", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setMetaTableName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setMetaTableName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setMetaTableName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setMetaTableName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setMetaTableName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setMetaTableName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setMetaTableName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setMetaTableName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setMetaTableName("CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setMetaTableName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setMetaTableName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setMetaTableName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setMetaTableName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SERVER", "CLIENT_ADDR", "CLIENT_INFO", "SESSION_START TIMESTAMP WITH TIME ZONE", "ISOLATION_LEVEL", "STATEMENT", "STATEMENT_START TIMESTAMP WITH TIME ZONE", "CONTAINS_UNCOMMITTED BIT", "STATE", "BLOCKER_ID INT");
                break;
            }
            case 26: {
                this.setMetaTableName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setMetaTableName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            case 28: {
                this.setMetaTableName("QUERY_STATISTICS");
                columnArray = this.createColumns("SQL_STATEMENT", "EXECUTION_COUNT INT", "MIN_EXECUTION_TIME DOUBLE", "MAX_EXECUTION_TIME DOUBLE", "CUMULATIVE_EXECUTION_TIME DOUBLE", "AVERAGE_EXECUTION_TIME DOUBLE", "STD_DEV_EXECUTION_TIME DOUBLE", "MIN_ROW_COUNT INT", "MAX_ROW_COUNT INT", "CUMULATIVE_ROW_COUNT LONG", "AVERAGE_ROW_COUNT DOUBLE", "STD_DEV_ROW_COUNT DOUBLE");
                break;
            }
            case 29: {
                this.setMetaTableName("SYNONYMS");
                columnArray = this.createColumns("SYNONYM_CATALOG", "SYNONYM_SCHEMA", "SYNONYM_NAME", "SYNONYM_FOR", "SYNONYM_FOR_SCHEMA", "TYPE_NAME", "STATUS", "REMARKS", "ID INT");
                string = "SYNONYM_NAME";
                break;
            }
            case 30: {
                this.setMetaTableName("TABLE_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "IS_DEFERRABLE", "INITIALLY_DEFERRED");
                string = "TABLE_NAME";
                break;
            }
            case 31: {
                this.setMetaTableName("KEY_COLUMN_USAGE");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "POSITION_IN_UNIQUE_CONSTRAINT INT");
                string = "TABLE_NAME";
                break;
            }
            case 32: {
                this.setMetaTableName("REFERENTIAL_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "UNIQUE_CONSTRAINT_CATALOG", "UNIQUE_CONSTRAINT_SCHEMA", "UNIQUE_CONSTRAINT_NAME", "MATCH_OPTION", "UPDATE_RULE", "DELETE_RULE");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(this.database.sysIdentifier(string)).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private void setMetaTableName(String string) {
        this.setObjectName(this.database.sysIdentifier(string));
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        int n = this.database.getSettings().caseInsensitiveIdentifiers ? 14 : 13;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n2;
            String string2 = stringArray[i];
            int n3 = string2.indexOf(32);
            if (n3 < 0) {
                n2 = n;
                string = string2;
            } else {
                n2 = DataType.getTypeByName((String)string2.substring((int)(n3 + 1)), (Mode)this.database.getMode()).type;
                string = string2.substring(0, n3);
            }
            columnArray[i] = new Column(this.database.sysIdentifier(string), n2);
        }
        return columnArray;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string) {
        if (this.database.getSettings().databaseToLower) {
            string = string == null ? null : StringUtils.toLowerEnglish(string);
        }
        return string;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> arrayList = this.database.getAllTablesAndViews(true);
        ArrayList<Table> arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private ArrayList<Table> getTablesByName(Session session, String string) {
        ArrayList<Table> arrayList = this.database.getTableOrViewByName(string);
        for (Table table : session.getLocalTempTables()) {
            if (!table.getName().equals(string)) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private boolean checkIndex(Session session, String string, Value value, Value value2) {
        if (string == null || value == null && value2 == null) {
            return true;
        }
        Database database = session.getDatabase();
        Value value3 = this.database.getSettings().caseInsensitiveIdentifiers ? ValueStringIgnoreCase.get(string) : ValueString.get(string);
        if (value != null && database.compare(value3, value) < 0) {
            return false;
        }
        return value2 == null || database.compare(value3, value2) <= 0;
    }

    private static String replaceNullWithEmpty(String string) {
        return string == null ? "" : string;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public ArrayList<Row> generateRows(Session var1_1, SearchRow var2_2, SearchRow var3_3) {
        var4_4 = null;
        var5_5 = null;
        if (this.indexColumn >= 0) {
            if (var2_2 != null) {
                var4_4 = var2_2.getValue(this.indexColumn);
            }
            if (var3_3 != null) {
                var5_5 = var3_3.getValue(this.indexColumn);
            }
        }
        var6_6 = Utils.newSmallArrayList();
        var7_7 = this.database.getShortName();
        var8_8 = var1_1.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table var10_40 : this.getAllTables(var1_1)) {
                    var11_77 = var10_40.getName();
                    if (!this.checkIndex(var1_1, var11_77, var4_4, var5_5) || this.hideTable(var10_40, var1_1)) continue;
                    var12_107 = var10_40.isTemporary() ? (var10_40.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (var10_40.isPersistIndexes() != false ? "CACHED" : "MEMORY");
                    var13_133 = var10_40.getCreateSQL();
                    if (!var8_8 && var13_133 != null && var13_133.contains("--hide--")) {
                        var13_133 = "-";
                    }
                    this.add(var6_6, new Object[]{var7_7, var10_40.getSchema().getName(), var11_77, var10_40.getTableType().toString(), var12_107, var13_133, MetaTable.replaceNullWithEmpty(var10_40.getComment()), ValueLong.get(var10_40.getMaxDataModificationId()), ValueInt.get(var10_40.getId()), null, var10_40.getClass().getName(), ValueLong.get(var10_40.getRowCountApproximation())});
                }
                break;
            }
            case 1: {
                if (var4_4 != null && var4_4.equals(var5_5)) {
                    var10_41 = var4_4.getString();
                    if (var10_41 == null) break;
                    var9_10 = this.getTablesByName(var1_1, var10_41);
                } else {
                    var9_10 = this.getAllTables(var1_1);
                }
                for (Table var11_78 : var9_10) {
                    var12_108 = var11_78.getName();
                    if (!this.checkIndex(var1_1, var12_108, var4_4, var5_5) || this.hideTable(var11_78, var1_1)) continue;
                    var13_134 = var11_78.getColumns();
                    var14_154 = this.database.getCompareMode().getName();
                    for (var15_168 = 0; var15_168 < var13_134.length; ++var15_168) {
                        var16_180 = var13_134[var15_168];
                        var17_190 = var16_180.getDomain();
                        var18_198 = var16_180.getDataType();
                        var19_207 = ValueInt.get(var16_180.getPrecisionAsInt());
                        var20_214 = ValueInt.get(var16_180.getType().getScale());
                        var21_220 = var16_180.getSequence();
                        var23_229 = var18_198.type;
                        switch (var23_229) {
                            case 9: 
                            case 10: 
                            case 11: 
                            case 24: 
                            case 31: 
                            case 35: 
                            case 37: 
                            case 38: 
                            case 41: {
                                var22_225 = true;
                                break;
                            }
                            default: {
                                var22_225 = false;
                            }
                        }
                        var24_231 = DataType.isIntervalType(var23_229);
                        var25_232 = var16_180.getCreateSQLWithoutName();
                        this.add(var6_6, new Object[]{var7_7, var11_78.getSchema().getName(), var12_108, var16_180.getName(), ValueInt.get(var15_168 + 1), var17_190 != null ? var7_7 : null, var17_190 != null ? this.database.getMainSchema().getName() : null, var17_190 != null ? var17_190.getName() : null, var16_180.getDefaultSQL(), var16_180.isNullable() != false ? "YES" : "NO", ValueInt.get(var18_198.sqlType), var19_207, var19_207, var19_207, ValueInt.get(10), var20_214, var22_225 != false ? var20_214 : null, var24_231 != false ? var25_232.substring(9) : null, var24_231 != false ? var19_207 : null, "Unicode", var14_154, this.identifier(var24_231 != false ? "INTERVAL" : var18_198.name), ValueInt.get(var16_180.isNullable() != false ? 1 : 0), ValueBoolean.get(var16_180.getComputed()), ValueInt.get(var16_180.getSelectivity()), var16_180.getCheckConstraintSQL(var1_1, var16_180.getName()), var21_220 == null ? null : var21_220.getName(), MetaTable.replaceNullWithEmpty(var16_180.getComment()), null, var25_232, var16_180.getOnUpdateSQL(), ValueBoolean.get(var16_180.getVisible())});
                    }
                }
                break;
            }
            case 2: {
                if (var4_4 != null && var4_4.equals(var5_5)) {
                    var10_42 = var4_4.getString();
                    if (var10_42 == null) break;
                    var9_11 = this.getTablesByName(var1_1, var10_42);
                } else {
                    var9_11 = this.getAllTables(var1_1);
                }
                for (Table var11_79 : var9_11) {
                    var12_109 = var11_79.getName();
                    if (!this.checkIndex(var1_1, var12_109, var4_4, var5_5) || this.hideTable(var11_79, var1_1)) continue;
                    var13_135 = var11_79.getIndexes();
                    var14_155 = var11_79.getConstraints();
                    for (var15_169 = 0; var13_135 != null && var15_169 < var13_135.size(); ++var15_169) {
                        var16_181 = var13_135.get(var15_169);
                        if (var16_181.getCreateSQL() == null) continue;
                        var17_191 = null;
                        for (var18_200 = 0; var14_155 != null && var18_200 < var14_155.size(); ++var18_200) {
                            var19_208 = var14_155.get(var18_200);
                            if (!var19_208.usesIndex(var16_181)) continue;
                            if (var16_181.getIndexType().isPrimaryKey()) {
                                if (var19_208.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                var17_191 = var19_208.getName();
                                continue;
                            }
                            var17_191 = var19_208.getName();
                        }
                        var18_199 = var16_181.getIndexColumns();
                        var19_208 = var16_181.getClass().getName();
                        for (var20_215 = 0; var20_215 < var18_199.length; ++var20_215) {
                            var21_221 = var18_199[var20_215];
                            var22_226 = var21_221.column;
                            this.add(var6_6, new Object[]{var7_7, var11_79.getSchema().getName(), var12_109, ValueBoolean.get(var16_181.getIndexType().isUnique() == false), var16_181.getName(), ValueShort.get((short)(var20_215 + 1)), var22_226.getName(), ValueInt.get(0), ValueBoolean.get(var16_181.getIndexType().isPrimaryKey()), var16_181.getIndexType().getSQL(), ValueBoolean.get(var16_181.getIndexType().getBelongsToConstraint()), ValueShort.get((short)3), (var21_221.sortType & 1) != 0 ? "D" : "A", ValueInt.get(0), "", MetaTable.replaceNullWithEmpty(var16_181.getComment()), var16_181.getCreateSQL(), ValueInt.get(var16_181.getId()), ValueInt.get(var21_221.sortType), var17_191, var19_208, ValueBoolean.get(var16_181.getIndexType().isAffinity())});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(var6_6, new Object[]{TableType.TABLE.toString()});
                this.add(var6_6, new Object[]{TableType.TABLE_LINK.toString()});
                this.add(var6_6, new Object[]{TableType.SYSTEM_TABLE.toString()});
                this.add(var6_6, new Object[]{TableType.VIEW.toString()});
                this.add(var6_6, new Object[]{TableType.EXTERNAL_TABLE_ENGINE.toString()});
                break;
            }
            case 4: {
                for (DataType var10_43 : DataType.getTypes()) {
                    if (var10_43.hidden || var10_43.sqlType == 0) continue;
                    this.add(var6_6, new Object[]{var10_43.name, ValueInt.get(var10_43.sqlType), ValueInt.get(MathUtils.convertLongToInt(var10_43.maxPrecision)), var10_43.prefix, var10_43.suffix, var10_43.params, ValueBoolean.get(var10_43.autoIncrement), ValueShort.get((short)var10_43.minScale), ValueShort.get((short)var10_43.maxScale), var10_43.decimal != false ? ValueInt.get(10) : null, ValueInt.get(var10_43.sqlTypePos), ValueBoolean.get(var10_43.caseSensitive), ValueShort.get((short)1), ValueShort.get((short)3)});
                }
                break;
            }
            case 5: {
                this.add(var6_6, new Object[]{var7_7});
                break;
            }
            case 6: {
                for (String[] var10_44 : this.database.getAllSettings()) {
                    var11_80 = var10_44.getStringValue();
                    if (var11_80 == null) {
                        var11_80 = Integer.toString(var10_44.getIntValue());
                    }
                    this.add(var6_6, new Object[]{this.identifier(var10_44.getName()), var11_80});
                }
                this.add(var6_6, new Object[]{"info.BUILD_ID", "200"});
                this.add(var6_6, new Object[]{"info.VERSION_MAJOR", "1"});
                this.add(var6_6, new Object[]{"info.VERSION_MINOR", "4"});
                this.add(var6_6, new Object[]{"info.VERSION", Constants.FULL_VERSION});
                if (var8_8) {
                    var9_13 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"};
                    for (String var13_136 : var9_13) {
                        this.add(var6_6, new Object[]{"property." + var13_136, Utils.getProperty(var13_136, "")});
                    }
                }
                this.add(var6_6, new Object[]{"EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE"});
                this.add(var6_6, new Object[]{"MODE", this.database.getMode().getName()});
                this.add(var6_6, new Object[]{"QUERY_TIMEOUT", Integer.toString(var1_1.getQueryTimeout())});
                this.add(var6_6, new Object[]{"RETENTION_TIME", Integer.toString(this.database.getRetentionTime())});
                this.add(var6_6, new Object[]{"LOG", Integer.toString(this.database.getLogMode())});
                for (Map.Entry<String, String> var12_112 : this.database.getSettings().getSortedSettings()) {
                    this.add(var6_6, new Object[]{var12_112.getKey(), var12_112.getValue()});
                }
                if (!this.database.isPersistent()) break;
                var9_13 = this.database.getPageStore();
                if (var9_13 != null) {
                    this.add(var6_6, new Object[]{"info.FILE_WRITE_TOTAL", Long.toString(var9_13.getWriteCountTotal())});
                    this.add(var6_6, new Object[]{"info.FILE_WRITE", Long.toString(var9_13.getWriteCount())});
                    this.add(var6_6, new Object[]{"info.FILE_READ", Long.toString(var9_13.getReadCount())});
                    this.add(var6_6, new Object[]{"info.PAGE_COUNT", Integer.toString(var9_13.getPageCount())});
                    this.add(var6_6, new Object[]{"info.PAGE_SIZE", Integer.toString(var9_13.getPageSize())});
                    this.add(var6_6, new Object[]{"info.CACHE_MAX_SIZE", Integer.toString(var9_13.getCache().getMaxMemory())});
                    this.add(var6_6, new Object[]{"info.CACHE_SIZE", Integer.toString(var9_13.getCache().getMemory())});
                }
                if ((var10_46 = this.database.getStore()) == null) break;
                var11_83 = var10_46.getMvStore();
                var12_113 = var11_83.getFileStore();
                this.add(var6_6, new Object[]{"info.FILE_WRITE", Long.toString(var12_113.getWriteCount())});
                this.add(var6_6, new Object[]{"info.FILE_READ", Long.toString(var12_113.getReadCount())});
                this.add(var6_6, new Object[]{"info.UPDATE_FAILURE_PERCENT", String.format(Locale.ENGLISH, "%.2f%%", new Object[]{100.0 * var11_83.getUpdateFailureRatio()})});
                try {
                    var13_137 = var12_113.getFile().size();
                }
                catch (IOException var15_170) {
                    throw DbException.convertIOException(var15_170, "Can not get size");
                }
                var15_171 = 4096;
                var16_182 = var13_137 / (long)var15_171;
                this.add(var6_6, new Object[]{"info.PAGE_COUNT", Long.toString(var16_182)});
                this.add(var6_6, new Object[]{"info.PAGE_SIZE", Integer.toString(var11_83.getPageSplitSize())});
                this.add(var6_6, new Object[]{"info.CACHE_MAX_SIZE", Integer.toString(var11_83.getCacheSize())});
                this.add(var6_6, new Object[]{"info.CACHE_SIZE", Integer.toString(var11_83.getCacheSizeUsed())});
                break;
            }
            case 7: {
                var9_14 = "/v14/h2/res/help.csv";
                try {
                    var10_47 = Utils.getResource(var9_14);
                    var11_84 = new InputStreamReader(new ByteArrayInputStream(var10_47));
                    var12_114 = new Csv();
                    var12_114.setLineCommentCharacter('#');
                    var13_138 = var12_114.read(var11_84, null);
                    var14_156 = 0;
                    while (var13_138.next()) {
                        this.add(var6_6, new Object[]{ValueInt.get(var14_156), var13_138.getString(1).trim(), var13_138.getString(2).trim(), var13_138.getString(3).trim(), var13_138.getString(4).trim()});
                        ++var14_156;
                    }
                    break;
                }
                catch (Exception var10_48) {
                    throw DbException.convert(var10_48);
                }
            }
            case 8: {
                for (SchemaObject var10_49 : this.database.getAllSchemaObjects(3)) {
                    var11_85 = (Sequence)var10_49;
                    this.add(var6_6, new Object[]{var7_7, var11_85.getSchema().getName(), var11_85.getName(), ValueLong.get(var11_85.getCurrentValue()), ValueLong.get(var11_85.getIncrement()), ValueBoolean.get(var11_85.getBelongsToTable()), MetaTable.replaceNullWithEmpty(var11_85.getComment()), ValueLong.get(var11_85.getCacheSize()), ValueLong.get(var11_85.getMinValue()), ValueLong.get(var11_85.getMaxValue()), ValueBoolean.get(var11_85.getCycle()), ValueInt.get(var11_85.getId())});
                }
                break;
            }
            case 9: {
                for (User var10_50 : this.database.getAllUsers()) {
                    if (!var8_8 && var1_1.getUser() != var10_50) continue;
                    this.add(var6_6, new Object[]{this.identifier(var10_50.getName()), String.valueOf(var10_50.isAdmin()), MetaTable.replaceNullWithEmpty(var10_50.getComment()), ValueInt.get(var10_50.getId())});
                }
                break;
            }
            case 10: {
                for (Role var10_51 : this.database.getAllRoles()) {
                    if (!var8_8 && !var1_1.getUser().isRoleGranted(var10_51)) continue;
                    this.add(var6_6, new Object[]{this.identifier(var10_51.getName()), MetaTable.replaceNullWithEmpty(var10_51.getComment()), ValueInt.get(var10_51.getId())});
                }
                break;
            }
            case 11: {
                if (!var8_8) break;
                for (Right var10_52 : this.database.getAllRights()) {
                    var11_86 = var10_52.getGrantedRole();
                    var12_115 = var10_52.getGrantee();
                    v0 = var13_139 = var12_115.getType() == 2 ? "USER" : "ROLE";
                    if (var11_86 == null) {
                        var14_157 = var10_52.getGrantedObject();
                        var15_172 = null;
                        var16_183 = null;
                        if (var14_157 != null) {
                            if (var14_157 instanceof Schema) {
                                var15_172 = (Schema)var14_157;
                            } else if (var14_157 instanceof Table) {
                                var16_183 = (Table)var14_157;
                                var15_172 = var16_183.getSchema();
                            }
                        }
                        var17_192 = var16_183 != null ? var16_183.getName() : "";
                        v1 = var18_201 = var15_172 != null ? var15_172.getName() : "";
                        if (!this.checkIndex(var1_1, var17_192, var4_4, var5_5)) continue;
                        this.add(var6_6, new Object[]{this.identifier(var12_115.getName()), var13_139, "", var10_52.getRights(), var18_201, var17_192, ValueInt.get(var10_52.getId())});
                        continue;
                    }
                    this.add(var6_6, new Object[]{this.identifier(var12_115.getName()), var13_139, this.identifier(var11_86.getName()), "", "", "", ValueInt.get(var10_52.getId())});
                }
                break;
            }
            case 12: {
                for (DbObject var10_53 : this.database.getAllSchemaObjects(9)) {
                    var11_87 = (FunctionAlias)var10_53;
                    try {
                        var12_116 = var11_87.getJavaMethods();
                    }
                    catch (DbException var13_141) {
                        var12_116 = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod var16_184 : var12_116) {
                        this.add(var6_6, new Object[]{var7_7, var11_87.getSchema().getName(), var11_87.getName(), var11_87.getJavaClassName(), var11_87.getJavaMethodName(), ValueInt.get(DataType.convertTypeToSQLType(var16_184.getDataType())), DataType.getDataType((int)var16_184.getDataType()).name, ValueInt.get(var16_184.getParameterCount()), ValueShort.get(var16_184.getDataType() == 0 ? 1 : 2), MetaTable.replaceNullWithEmpty(var11_87.getComment()), ValueInt.get(var11_87.getId()), var11_87.getSource()});
                    }
                }
                for (DbObject var10_53 : this.database.getAllAggregates()) {
                    this.add(var6_6, new Object[]{var7_7, this.database.getMainSchema().getName(), var10_53.getName(), var10_53.getJavaClassName(), "", ValueInt.get(0), DataType.getDataType((int)0).name, ValueInt.get(1), ValueShort.get((short)2), MetaTable.replaceNullWithEmpty(var10_53.getComment()), ValueInt.get(var10_53.getId()), ""});
                }
                break;
            }
            case 21: {
                for (SchemaObject var10_54 : this.database.getAllSchemaObjects(9)) {
                    var11_88 = (FunctionAlias)var10_54;
                    try {
                        var12_117 = var11_88.getJavaMethods();
                    }
                    catch (DbException var13_143) {
                        var12_117 = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod var16_185 : var12_117) {
                        if (var16_185.getDataType() != 0) {
                            var17_193 /* !! */  = DataType.getDataType(var16_185.getDataType());
                            this.add(var6_6, new Object[]{var7_7, var11_88.getSchema().getName(), var11_88.getName(), var11_88.getJavaClassName(), var11_88.getJavaMethodName(), ValueInt.get(var16_185.getParameterCount()), ValueInt.get(0), "P0", ValueInt.get(DataType.convertTypeToSQLType(var16_185.getDataType())), var17_193 /* !! */ .name, ValueInt.get(MathUtils.convertLongToInt(var17_193 /* !! */ .defaultPrecision)), ValueShort.get((short)var17_193 /* !! */ .defaultScale), ValueShort.get((short)10), ValueShort.get((short)2), ValueShort.get((short)5), "", null});
                        }
                        var17_193 /* !! */  = var16_185.getColumnClasses();
                        for (var18_202 = 0; var18_202 < var17_193 /* !! */ .length; ++var18_202) {
                            if (var16_185.hasConnectionParam() && var18_202 == 0) continue;
                            var19_209 = var17_193 /* !! */ [var18_202];
                            var20_216 = DataType.getTypeFromClass(var19_209);
                            var21_222 = DataType.getDataType(var20_216);
                            this.add(var6_6, new Object[]{var7_7, var11_88.getSchema().getName(), var11_88.getName(), var11_88.getJavaClassName(), var11_88.getJavaMethodName(), ValueInt.get(var16_185.getParameterCount()), ValueInt.get(var18_202 + (var16_185.hasConnectionParam() != false ? 0 : 1)), "P" + (var18_202 + 1), ValueInt.get(DataType.convertTypeToSQLType(var21_222.type)), var21_222.name, ValueInt.get(MathUtils.convertLongToInt(var21_222.defaultPrecision)), ValueShort.get((short)var21_222.defaultScale), ValueShort.get((short)10), ValueShort.get(var19_209.isPrimitive() != false ? 0 : 1), ValueShort.get((short)1), "", null});
                        }
                    }
                }
                break;
            }
            case 13: {
                var9_21 = this.database.getCompareMode().getName();
                for (Schema var11_89 : this.database.getAllSchemas()) {
                    this.add(var6_6, new Object[]{var7_7, var11_89.getName(), this.identifier(var11_89.getOwner().getName()), "Unicode", var9_21, ValueBoolean.get(var11_89.getId() == 0), MetaTable.replaceNullWithEmpty(var11_89.getComment()), ValueInt.get(var11_89.getId())});
                }
                break;
            }
            case 14: {
                for (Right var10_56 : this.database.getAllRights()) {
                    var11_90 = var10_56.getGrantedObject();
                    if (!(var11_90 instanceof Table) || this.hideTable(var12_118 = (Table)var11_90, var1_1) || !this.checkIndex(var1_1, var13_144 = var12_118.getName(), var4_4, var5_5)) continue;
                    this.addPrivileges(var6_6, var10_56.getGrantee(), var7_7, var12_118, null, var10_56.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right var10_57 : this.database.getAllRights()) {
                    var11_91 = var10_57.getGrantedObject();
                    if (!(var11_91 instanceof Table) || this.hideTable(var12_119 = (Table)var11_91, var1_1) || !this.checkIndex(var1_1, var13_145 = var12_119.getName(), var4_4, var5_5)) continue;
                    var14_160 = var10_57.getGrantee();
                    var15_175 = var10_57.getRightMask();
                    for (Column var19_210 : var12_119.getColumns()) {
                        this.addPrivileges(var6_6, var14_160, var7_7, var12_119, var19_210.getName(), var15_175);
                    }
                }
                break;
            }
            case 16: {
                for (Locale var12_120 : Collator.getAvailableLocales()) {
                    this.add(var6_6, new Object[]{CompareMode.getName(var12_120), var12_120.toString()});
                }
                break;
            }
            case 17: {
                for (Table var10_59 : this.getAllTables(var1_1)) {
                    if (var10_59.getTableType() != TableType.VIEW || !this.checkIndex(var1_1, var11_93 = var10_59.getName(), var4_4, var5_5)) continue;
                    var12_121 = (TableView)var10_59;
                    this.add(var6_6, new Object[]{var7_7, var10_59.getSchema().getName(), var11_93, var10_59.getCreateSQL(), "NONE", "NO", var12_121.isInvalid() != false ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(var12_121.getComment()), ValueInt.get(var12_121.getId())});
                }
                break;
            }
            case 18: {
                var9_26 = this.database.getInDoubtTransactions();
                if (var9_26 == null || !var8_8) break;
                for (InDoubtTransaction var11_94 : var9_26) {
                    this.add(var6_6, new Object[]{var11_94.getTransactionName(), var11_94.getState()});
                }
                break;
            }
            case 19: {
                for (SchemaObject var10_61 : this.database.getAllSchemaObjects(5)) {
                    var11_95 = (Constraint)var10_61;
                    if (var11_95.getConstraintType() != Constraint.Type.REFERENTIAL) continue;
                    var12_122 = (ConstraintReferential)var11_95;
                    var13_146 = var12_122.getColumns();
                    var14_161 = var12_122.getRefColumns();
                    var15_176 = var12_122.getTable();
                    var16_187 = var12_122.getRefTable();
                    var17_195 = var16_187.getName();
                    if (!this.checkIndex(var1_1, var17_195, var4_4, var5_5)) continue;
                    var18_204 = ValueShort.get(MetaTable.getRefAction(var12_122.getUpdateAction()));
                    var19_211 = ValueShort.get(MetaTable.getRefAction(var12_122.getDeleteAction()));
                    for (var20_217 = 0; var20_217 < var13_146.length; ++var20_217) {
                        this.add(var6_6, new Object[]{var7_7, var16_187.getSchema().getName(), var16_187.getName(), var14_161[var20_217].column.getName(), var7_7, var15_176.getSchema().getName(), var15_176.getName(), var13_146[var20_217].column.getName(), ValueShort.get((short)(var20_217 + 1)), var18_204, var19_211, var12_122.getName(), var12_122.getUniqueIndex().getName(), ValueShort.get((short)7)});
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject var10_62 : this.database.getAllSchemaObjects(5)) {
                    var11_96 = (Constraint)var10_62;
                    var12_123 = var11_96.getConstraintType();
                    var13_147 = null;
                    var14_162 = null;
                    var15_177 = var11_96.getTable();
                    if (this.hideTable(var15_177, var1_1)) continue;
                    var16_188 = var11_96.getUniqueIndex();
                    var17_196 = null;
                    if (var16_188 != null) {
                        var17_196 = var16_188.getName();
                    }
                    if (!this.checkIndex(var1_1, var18_205 = var15_177.getName(), var4_4, var5_5)) continue;
                    if (var12_123 == Constraint.Type.CHECK) {
                        var13_147 = ((ConstraintCheck)var11_96).getExpression().getSQL(true);
                    } else if (var12_123 == Constraint.Type.UNIQUE || var12_123 == Constraint.Type.PRIMARY_KEY) {
                        var14_162 = ((ConstraintUnique)var11_96).getColumns();
                    } else if (var12_123 == Constraint.Type.REFERENTIAL) {
                        var14_162 = ((ConstraintReferential)var11_96).getColumns();
                    }
                    var19_212 = null;
                    if (var14_162 != null) {
                        var20_218 = new StringBuilder();
                        var22_227 = var14_162.length;
                        for (var21_223 = 0; var21_223 < var22_227; ++var21_223) {
                            if (var21_223 > 0) {
                                var20_218.append(',');
                            }
                            var20_218.append(var14_162[var21_223].column.getName());
                        }
                        var19_212 = var20_218.toString();
                    }
                    this.add(var6_6, new Object[]{var7_7, var11_96.getSchema().getName(), var11_96.getName(), var12_123 == Constraint.Type.PRIMARY_KEY ? var12_123.getSqlName() : var12_123.name(), var7_7, var15_177.getSchema().getName(), var18_205, var17_196, var13_147, var19_212, MetaTable.replaceNullWithEmpty(var11_96.getComment()), var11_96.getCreateSQL(), ValueInt.get(var11_96.getId())});
                }
                break;
            }
            case 22: {
                for (SchemaObject var10_63 : this.database.getAllSchemaObjects(11)) {
                    var11_97 = (Constant)var10_63;
                    var12_124 = var11_97.getValue();
                    this.add(var6_6, new Object[]{var7_7, var11_97.getSchema().getName(), var11_97.getName(), ValueInt.get(DataType.convertTypeToSQLType(var12_124.getType().getValueType())), MetaTable.replaceNullWithEmpty(var11_97.getComment()), var12_124.getSQL(true), ValueInt.get(var11_97.getId())});
                }
                break;
            }
            case 23: {
                for (Domain var10_64 : this.database.getAllDomains()) {
                    var11_98 = var10_64.getColumn();
                    this.add(var6_6, new Object[]{var7_7, this.database.getMainSchema().getName(), var10_64.getName(), var11_98.getDefaultSQL(), var11_98.isNullable() != false ? "YES" : "NO", ValueInt.get(var11_98.getDataType().sqlType), ValueInt.get(var11_98.getPrecisionAsInt()), ValueInt.get(var11_98.getType().getScale()), var11_98.getDataType().name, ValueInt.get(var11_98.getSelectivity()), var11_98.getCheckConstraintSQL(var1_1, "VALUE"), MetaTable.replaceNullWithEmpty(var10_64.getComment()), var10_64.getCreateSQL(), ValueInt.get(var10_64.getId())});
                }
                break;
            }
            case 24: {
                for (SchemaObject var10_65 : this.database.getAllSchemaObjects(4)) {
                    var11_99 = (TriggerObject)var10_65;
                    var12_125 = var11_99.getTable();
                    this.add(var6_6, new Object[]{var7_7, var11_99.getSchema().getName(), var11_99.getName(), var11_99.getTypeNameList(new StringBuilder()).toString(), var7_7, var12_125.getSchema().getName(), var12_125.getName(), ValueBoolean.get(var11_99.isBefore()), var11_99.getTriggerClassName(), ValueInt.get(var11_99.getQueueSize()), ValueBoolean.get(var11_99.isNoWait()), MetaTable.replaceNullWithEmpty(var11_99.getComment()), var11_99.getCreateSQL(), ValueInt.get(var11_99.getId())});
                }
                break;
            }
            case 25: {
                for (Session var12_126 : this.database.getSessions(false)) {
                    if (!var8_8 && var12_126 != var1_1) continue;
                    var13_148 = var12_126.getNetworkConnectionInfo();
                    var14_163 = var12_126.getCurrentCommand();
                    var15_178 = var12_126.getBlockingSessionId();
                    this.add(var6_6, new Object[]{ValueInt.get(var12_126.getId()), var12_126.getUser().getName(), var13_148 == null ? null : var13_148.getServer(), var13_148 == null ? null : var13_148.getClient(), var13_148 == null ? null : var13_148.getClientInfo(), DateTimeUtils.timestampTimeZoneFromMillis(var12_126.getSessionStart()), var1_1.getIsolationLevel().getSQL(), var14_163 == null ? null : var14_163.toString(), var14_163 == null ? null : var12_126.getCurrentCommandStart(), ValueBoolean.get(var12_126.containsUncommitted()), String.valueOf((Object)var12_126.getState()), var15_178 == 0 ? null : ValueInt.get(var15_178)});
                }
                break;
            }
            case 26: {
                for (Session var12_127 : this.database.getSessions(false)) {
                    if (!var8_8 && var12_127 != var1_1) continue;
                    for (Table var14_164 : var12_127.getLocks()) {
                        this.add(var6_6, new Object[]{var14_164.getSchema().getName(), var14_164.getName(), ValueInt.get(var12_127.getId()), var14_164.isLockedExclusivelyBy(var12_127) != false ? "WRITE" : "READ"});
                    }
                }
                break;
            }
            case 27: {
                for (String var12_128 : var1_1.getVariableNames()) {
                    var13_150 = var1_1.getVariable(var12_128);
                    var14_165 = new StringBuilder().append("SET @").append(var12_128).append(' ');
                    var13_150.getSQL(var14_165);
                    this.add(var6_6, new Object[]{"@" + var12_128, var14_165.toString()});
                }
                for (Table var10_69 : var1_1.getLocalTempTables()) {
                    this.add(var6_6, new Object[]{"TABLE " + var10_69.getName(), var10_69.getCreateSQL()});
                }
                var9_34 = var1_1.getSchemaSearchPath();
                if (var9_34 != null && var9_34.length > 0) {
                    var10_70 = new StringBuilder("SET SCHEMA_SEARCH_PATH ");
                    var12_129 = var9_34.length;
                    for (var11_102 = 0; var11_102 < var12_129; ++var11_102) {
                        if (var11_102 > 0) {
                            var10_70.append(", ");
                        }
                        StringUtils.quoteIdentifier(var10_70, (String)var9_34[var11_102]);
                    }
                    this.add(var6_6, new Object[]{"SCHEMA_SEARCH_PATH", var10_70.toString()});
                }
                if ((var10_71 = var1_1.getCurrentSchemaName()) == null) break;
                this.add(var6_6, new Object[]{"SCHEMA", StringUtils.quoteIdentifier(new StringBuilder("SET SCHEMA "), var10_71).toString()});
                break;
            }
            case 28: {
                var9_35 = this.database.getQueryStatisticsData();
                if (var9_35 == null) break;
                for (QueryStatisticsData.QueryEntry var11_103 : var9_35.getQueries()) {
                    this.add(var6_6, new Object[]{var11_103.sqlStatement, ValueInt.get(var11_103.count), ValueDouble.get((double)var11_103.executionTimeMinNanos / 1000000.0), ValueDouble.get((double)var11_103.executionTimeMaxNanos / 1000000.0), ValueDouble.get((double)var11_103.executionTimeCumulativeNanos / 1000000.0), ValueDouble.get(var11_103.executionTimeMeanNanos / 1000000.0), ValueDouble.get(var11_103.getExecutionTimeStandardDeviation() / 1000000.0), ValueInt.get(var11_103.rowCountMin), ValueInt.get(var11_103.rowCountMax), ValueLong.get(var11_103.rowCountCumulative), ValueDouble.get(var11_103.rowCountMean), ValueDouble.get(var11_103.getRowCountStandardDeviation())});
                }
                break;
            }
            case 29: {
                for (TableSynonym var10_73 : this.database.getAllSynonyms()) {
                    this.add(var6_6, new Object[]{var7_7, var10_73.getSchema().getName(), var10_73.getName(), var10_73.getSynonymForName(), var10_73.getSynonymForSchema().getName(), "SYNONYM", "VALID", MetaTable.replaceNullWithEmpty(var10_73.getComment()), ValueInt.get(var10_73.getId())});
                }
                break;
            }
            case 30: {
                for (SchemaObject var10_74 : this.database.getAllSchemaObjects(5)) {
                    var11_104 = (Constraint)var10_74;
                    var12_130 = var11_104.getConstraintType();
                    var13_151 = var11_104.getTable();
                    if (this.hideTable(var13_151, var1_1) || !this.checkIndex(var1_1, var14_166 = var13_151.getName(), var4_4, var5_5)) continue;
                    this.add(var6_6, new Object[]{var7_7, var11_104.getSchema().getName(), var11_104.getName(), var12_130.getSqlName(), var7_7, var13_151.getSchema().getName(), var14_166, "NO", "NO"});
                }
                break;
            }
            case 31: {
                for (SchemaObject var10_75 : this.database.getAllSchemaObjects(5)) {
                    var11_105 = (Constraint)var10_75;
                    var12_131 = var11_105.getConstraintType();
                    var13_152 = null;
                    var14_167 = var11_105.getTable();
                    if (this.hideTable(var14_167, var1_1) || !this.checkIndex(var1_1, var15_179 = var14_167.getName(), var4_4, var5_5)) continue;
                    if (var12_131 == Constraint.Type.UNIQUE || var12_131 == Constraint.Type.PRIMARY_KEY) {
                        var13_152 = ((ConstraintUnique)var11_105).getColumns();
                    } else if (var12_131 == Constraint.Type.REFERENTIAL) {
                        var13_152 = ((ConstraintReferential)var11_105).getColumns();
                    }
                    if (var13_152 == null) continue;
                    var16_189 = var12_131 == Constraint.Type.REFERENTIAL ? MetaTable.lookupUniqueForReferential((ConstraintReferential)var11_105) : null;
                    for (var17_197 = 0; var17_197 < var13_152.length; ++var17_197) {
                        var18_206 = var13_152[var17_197];
                        var19_213 = ValueInt.get(var17_197 + 1);
                        if (var12_131 != Constraint.Type.REFERENTIAL) ** GOTO lbl465
                        var20_219 = var19_213;
                        if (var16_189 == null) ** GOTO lbl466
                        var21_224 = ((ConstraintReferential)var11_105).getRefColumns()[var17_197].column;
                        var22_228 = var16_189.getColumns();
                        for (var23_230 = 0; var23_230 < var22_228.length; ++var23_230) {
                            if (!var22_228[var23_230].column.equals(var21_224)) continue;
                            var20_219 = ValueInt.get(var23_230 + 1);
                            ** GOTO lbl466
                        }
                        ** GOTO lbl466
lbl465:
                        // 1 sources

                        var20_219 = null;
lbl466:
                        // 4 sources

                        this.add(var6_6, new Object[]{var7_7, var11_105.getSchema().getName(), var11_105.getName(), var7_7, var14_167.getSchema().getName(), var15_179, var18_206.columnName, var19_213, var20_219});
                    }
                }
                break;
            }
            case 32: {
                for (SchemaObject var10_76 : this.database.getAllSchemaObjects(5)) {
                    if (((Constraint)var10_76).getConstraintType() != Constraint.Type.REFERENTIAL || this.hideTable(var12_132 = (var11_106 = (ConstraintReferential)var10_76).getTable(), var1_1)) continue;
                    var13_153 = MetaTable.lookupUniqueForReferential(var11_106);
                    if (var13_153 == null) {
                        var13_153 = var11_106.getUniqueIndex();
                    }
                    this.add(var6_6, new Object[]{var7_7, var11_106.getSchema().getName(), var11_106.getName(), var7_7, var13_153.getSchema().getName(), var13_153.getName(), "NONE", var11_106.getUpdateAction().getSqlName(), var11_106.getDeleteAction().getSqlName()});
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return var6_6;
    }

    private static short getRefAction(ConstraintActionType constraintActionType) {
        switch (constraintActionType) {
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + (Object)((Object)constraintActionType));
    }

    private static ConstraintUnique lookupUniqueForReferential(ConstraintReferential constraintReferential) {
        Table table = constraintReferential.getRefTable();
        for (Constraint constraint : table.getConstraints()) {
            ConstraintUnique constraintUnique;
            if (constraint.getConstraintType() != Constraint.Type.UNIQUE || !(constraintUnique = (ConstraintUnique)constraint).getReferencedColumns(table).equals(constraintReferential.getReferencedColumns(table))) continue;
            return constraintUnique;
        }
        return null;
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(arrayList, dbObject, string, table, string2, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> arrayList, DbObject dbObject, String string, Table table, String string2, String string3) {
        User user;
        String string4 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string4 = "YES";
        }
        if (string2 == null) {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, table.getSchema().getName(), table.getName(), string3, string4);
        } else {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string, table.getSchema().getName(), table.getName(), string2, string3, string4);
        }
    }

    private void add(ArrayList<Row> arrayList, Object ... objectArray) {
        Value[] valueArray = new Value[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            ValueNull valueNull = object == null ? ValueNull.INSTANCE : (object instanceof String ? ValueString.get((String)object) : (Value)object);
            valueArray[i] = this.columns[i].convert(valueNull, false);
        }
        Row row = this.database.createRow(valueArray, 1);
        row.setKey(arrayList.size());
        arrayList.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> arrayList = new ArrayList<Index>(2);
        if (this.metaIndex == null) {
            return arrayList;
        }
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.metaIndex);
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 33;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

