/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.resource;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.nifi.flow.resource.CollisionAwareResourceProviderWorker;
import org.apache.nifi.flow.resource.CompositeExternalResourceProviderService;
import org.apache.nifi.flow.resource.DoNotReplaceResolutionStrategy;
import org.apache.nifi.flow.resource.ExternalResourceConflictResolutionStrategy;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flow.resource.ExternalResourceProviderService;
import org.apache.nifi.flow.resource.ExternalResourceProviderWorker;
import org.apache.nifi.flow.resource.ReplaceWithNewerResolutionStrategy;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.FormatUtils;

public final class ExternalResourceProviderServiceBuilder {
    private static final Map<String, Supplier<ExternalResourceConflictResolutionStrategy>> STRATEGIES = new HashMap<String, Supplier<ExternalResourceConflictResolutionStrategy>>();
    private final String serviceName;
    private final ExtensionManager extensionManager;
    private File targetDirectory;
    private long pollIntervalInMillis;
    private ExternalResourceConflictResolutionStrategy conflictResolutionStrategy;
    private Map<String, ExternalResourceProvider> providers;
    private boolean restrainStartup = true;

    public ExternalResourceProviderServiceBuilder(String serviceName, ExtensionManager extensionManager) {
        this.serviceName = serviceName;
        this.extensionManager = extensionManager;
    }

    public ExternalResourceProviderServiceBuilder targetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
        return this;
    }

    public ExternalResourceProviderServiceBuilder providers(Map<String, ExternalResourceProvider> providers) {
        this.providers = providers;
        return this;
    }

    public ExternalResourceProviderServiceBuilder conflictResolutionStrategy(String conflictResolutionStrategy) {
        this.conflictResolutionStrategy = ExternalResourceProviderServiceBuilder.getExternalResourceConflictResolutionStrategy(conflictResolutionStrategy);
        return this;
    }

    public ExternalResourceProviderServiceBuilder pollInterval(String pollInterval) {
        this.pollIntervalInMillis = Math.round(FormatUtils.getPreciseTimeDuration((String)pollInterval.trim(), (TimeUnit)TimeUnit.MILLISECONDS));
        return this;
    }

    public ExternalResourceProviderServiceBuilder restrainingStartup(boolean restrainStartup) {
        this.restrainStartup = restrainStartup;
        return this;
    }

    public ExternalResourceProviderService build() throws ClassNotFoundException, InstantiationException, IllegalAccessException, TlsException {
        if (this.targetDirectory == null) {
            throw new IllegalArgumentException("Target directory must be specified");
        }
        HashSet<ExternalResourceProviderWorker> workers = new HashSet<ExternalResourceProviderWorker>();
        CountDownLatch restrainStartupLatch = new CountDownLatch(this.restrainStartup ? this.providers.size() : 0);
        for (Map.Entry<String, ExternalResourceProvider> provider : this.providers.entrySet()) {
            InstanceClassLoader instanceClassLoader = this.extensionManager.getInstanceClassLoader(provider.getKey());
            InstanceClassLoader providerClassLoader = instanceClassLoader == null ? provider.getValue().getClass().getClassLoader() : instanceClassLoader;
            CollisionAwareResourceProviderWorker providerWorker = new CollisionAwareResourceProviderWorker(this.serviceName, (ClassLoader)providerClassLoader, provider.getValue(), this.conflictResolutionStrategy, this.targetDirectory, this.pollIntervalInMillis, restrainStartupLatch);
            workers.add(providerWorker);
        }
        return new CompositeExternalResourceProviderService(this.serviceName, workers, restrainStartupLatch);
    }

    private static ExternalResourceConflictResolutionStrategy getExternalResourceConflictResolutionStrategy(String conflictResolutionStrategy) {
        if (!STRATEGIES.containsKey(conflictResolutionStrategy)) {
            throw new IllegalArgumentException("Unknown conflict resolution strategy: " + conflictResolutionStrategy);
        }
        return STRATEGIES.get(conflictResolutionStrategy).get();
    }

    static {
        STRATEGIES.put("REPLACE", ReplaceWithNewerResolutionStrategy::new);
        STRATEGIES.put("IGNORE", DoNotReplaceResolutionStrategy::new);
    }
}

