/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.postgresql;

import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.database.postgresql.TransactionalModel;

public class PostgreSQLConfigurationExtension
implements ConfigurationExtension {
    private static final String TRANSACTIONAL_LOCK = "flyway.postgresql.transactional.lock";
    private TransactionalModel transactional = null;

    public boolean isTransactionalLock() {
        return this.transactional == null || this.transactional.getLock() == null || this.transactional.getLock() != false;
    }

    public void setTransactionalLock(boolean transactionalLock) {
        this.transactional = new TransactionalModel();
        this.transactional.setLock(transactionalLock);
    }

    public String getConfigurationParameterFromEnvironmentVariable(String environmentVariable) {
        if ("FLYWAY_POSTGRESQL_TRANSACTIONAL_LOCK".equals(environmentVariable)) {
            return TRANSACTIONAL_LOCK;
        }
        return null;
    }

    public String getNamespace() {
        return "postgresql";
    }

    public TransactionalModel getTransactional() {
        return this.transactional;
    }

    public void setTransactional(TransactionalModel transactional) {
        this.transactional = transactional;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgreSQLConfigurationExtension)) {
            return false;
        }
        PostgreSQLConfigurationExtension other = (PostgreSQLConfigurationExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionalModel this$transactional = this.getTransactional();
        TransactionalModel other$transactional = other.getTransactional();
        return !(this$transactional == null ? other$transactional != null : !((Object)this$transactional).equals(other$transactional));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostgreSQLConfigurationExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionalModel $transactional = this.getTransactional();
        result = result * 59 + ($transactional == null ? 43 : ((Object)$transactional).hashCode());
        return result;
    }

    public String toString() {
        return "PostgreSQLConfigurationExtension(transactional=" + this.getTransactional() + ")";
    }
}

