/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.error;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.ObjectError;

public final class Error
implements MessageSourceResolvable {
    private final MessageSourceResolvable cause;

    private Error(MessageSourceResolvable cause) {
        Assert.notNull((Object)cause, (String)"'cause' must not be null");
        this.cause = cause;
    }

    public String[] getCodes() {
        return this.cause.getCodes();
    }

    public Object[] getArguments() {
        return this.cause.getArguments();
    }

    public String getDefaultMessage() {
        return this.cause.getDefaultMessage();
    }

    @JsonIgnore
    public MessageSourceResolvable getCause() {
        return this.cause;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.cause, ((Error)obj).cause);
    }

    public int hashCode() {
        return Objects.hash(this.cause);
    }

    public String toString() {
        return this.cause.toString();
    }

    @Deprecated(since="3.5.4", forRemoval=true)
    public static List<Error> wrap(List<? extends MessageSourceResolvable> errors) {
        if (CollectionUtils.isEmpty(errors)) {
            return Collections.emptyList();
        }
        ArrayList<Error> result = new ArrayList<Error>(errors.size());
        for (MessageSourceResolvable messageSourceResolvable : errors) {
            result.add(new Error(messageSourceResolvable));
        }
        return List.copyOf(result);
    }

    public static List<MessageSourceResolvable> wrapIfNecessary(List<? extends MessageSourceResolvable> errors) {
        if (CollectionUtils.isEmpty(errors)) {
            return Collections.emptyList();
        }
        ArrayList<MessageSourceResolvable> result = new ArrayList<MessageSourceResolvable>(errors.size());
        for (MessageSourceResolvable messageSourceResolvable : errors) {
            result.add(Error.requiresWrapping(messageSourceResolvable) ? new Error(messageSourceResolvable) : messageSourceResolvable);
        }
        return List.copyOf(result);
    }

    private static boolean requiresWrapping(MessageSourceResolvable error) {
        return !(error instanceof ObjectError);
    }
}

