/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.util.Comparator;
import org.apache.nifi.controller.queue.FlowFileSummary;

public enum SortColumn implements Comparator<FlowFileSummary>
{
    QUEUE_POSITION(Comparator.comparingInt(FlowFileSummary::getPosition)),
    FLOWFILE_UUID(Comparator.comparing(FlowFileSummary::getUuid)),
    FILENAME(Comparator.comparing(FlowFileSummary::getFilename)),
    FLOWFILE_SIZE(Comparator.comparingLong(FlowFileSummary::getSize)),
    QUEUED_DURATION((o1, o2) -> -Long.compare(o1.getLastQueuedTime(), o2.getLastQueuedTime())),
    FLOWFILE_AGE(Comparator.comparingLong(FlowFileSummary::getLineageStartDate)),
    PENALIZATION((o1, o2) -> Boolean.compare(o1.isPenalized(), o2.isPenalized()));

    private final Comparator<FlowFileSummary> comparator;

    private SortColumn(Comparator<FlowFileSummary> comparator) {
        this.comparator = comparator;
    }

    @Override
    public int compare(FlowFileSummary o1, FlowFileSummary o2) {
        return this.comparator.compare(o1, o2);
    }
}

