/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.out.StreamWriterBase;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WNameTable;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.olingo.javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;

public final class RepairingStreamWriter
extends StreamWriterBase {
    final String _cfgAutomaticNsPrefix;
    int[] _autoNsSeq = null;
    String _suggestedDefNs = null;
    HashMap<String, String> _suggestedPrefixes = null;

    public RepairingStreamWriter(WriterConfig cfg, XmlWriter writer, WNameTable symbols) {
        super(cfg, writer, symbols);
        this._cfgAutomaticNsPrefix = cfg.getAutomaticNsPrefix();
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this._suggestedDefNs = uri == null || uri.length() == 0 ? null : uri;
    }

    @Override
    public void _setPrefix(String prefix, String uri) {
        if (uri == null || uri.length() == 0) {
            if (this._suggestedPrefixes != null) {
                Iterator<Map.Entry<String, String>> it = this._suggestedPrefixes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> en = it.next();
                    if (!en.getValue().equals(prefix)) continue;
                    it.remove();
                }
            }
        } else {
            if (this._suggestedPrefixes == null) {
                this._suggestedPrefixes = new HashMap(16);
            }
            this._suggestedPrefixes.put(uri, prefix);
        }
    }

    @Override
    public void writeAttribute(String nsURI, String localName, String value) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            RepairingStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        WName name = nsURI == null || nsURI.length() == 0 ? this._symbols.findSymbol(localName) : this._generateAttrName(null, localName, nsURI);
        this._writeAttribute(name, value);
    }

    @Override
    public void writeAttribute(String prefix, String nsURI, String localName, String value) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            RepairingStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        WName name = nsURI == null || nsURI.length() == 0 ? this._symbols.findSymbol(localName) : this._generateAttrName(prefix, localName, nsURI);
        this._writeAttribute(name, value);
    }

    @Override
    public void writeDefaultNamespace(String nsURI) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            RepairingStreamWriter.throwOutputError(ErrorConsts.WERR_NS_NO_ELEM);
        }
        if (!this._currElem.hasPrefix()) {
            this._currElem.setDefaultNsURI(nsURI);
            this._writeDefaultNamespace(nsURI);
        }
        this._writeDefaultNamespace(nsURI);
    }

    @Override
    public void writeEmptyElement(String nsURI, String localName) throws XMLStreamException {
        this._writeStartOrEmpty(null, localName, nsURI, true);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this._writeStartOrEmpty(prefix, localName, nsURI, true);
    }

    @Override
    public void writeNamespace(String prefix, String nsURI) throws XMLStreamException {
        if (prefix == null || prefix.length() == 0) {
            this.writeDefaultNamespace(nsURI);
            return;
        }
        if (!this._stateStartElementOpen) {
            RepairingStreamWriter.throwOutputError(ErrorConsts.WERR_NS_NO_ELEM);
        }
        if (this._currElem.isPrefixUnbound(prefix, this._rootNsContext)) {
            this._currElem.addPrefix(prefix, nsURI);
            this._writeNamespace(prefix, nsURI);
        }
    }

    @Override
    public void writeStartElement(String nsURI, String localName) throws XMLStreamException {
        this._writeStartOrEmpty(null, localName, nsURI, false);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String nsURI) throws XMLStreamException {
        this._writeStartOrEmpty(prefix, localName, nsURI, false);
    }

    @Override
    public void writeTypedAttribute(String prefix, String nsURI, String localName, AsciiValueEncoder enc) throws XMLStreamException {
        if (!this._stateStartElementOpen) {
            RepairingStreamWriter.throwOutputError(ErrorConsts.WERR_ATTR_NO_ELEM);
        }
        WName name = prefix == null || prefix.length() == 0 ? this._symbols.findSymbol(localName) : this._symbols.findSymbol(prefix, localName);
        this._writeAttribute(name, enc);
    }

    @Override
    protected String _serializeQName(QName name) throws XMLStreamException {
        String uri = name.getNamespaceURI();
        String prefix = name.getPrefix();
        String local = name.getLocalPart();
        if (this._currElem.isPrefixBoundTo(prefix, uri, this._rootNsContext)) {
            if (prefix == null || prefix.length() == 0) {
                return local;
            }
            return prefix + ":" + local;
        }
        WName newName = this._generateAttrName(prefix, local, uri);
        return newName.getPrefixedName();
    }

    protected WName _generateAttrName(String suggPrefix, String localName, String uri) throws XMLStreamException {
        String prefix;
        if (suggPrefix != null && suggPrefix.length() > 0) {
            switch (this._currElem.checkPrefixValidity(suggPrefix, uri, this._rootNsContext)) {
                case UNBOUND: {
                    this._writeNamespace(suggPrefix, uri);
                    this._currElem.addPrefix(suggPrefix, uri);
                }
                case OK: {
                    return this._symbols.findSymbol(suggPrefix, localName);
                }
            }
        }
        if ((prefix = this._currElem.getExplicitPrefix(uri, this._rootNsContext)) == null) {
            if (this._autoNsSeq == null) {
                this._autoNsSeq = new int[1];
                this._autoNsSeq[0] = 1;
            }
            prefix = this._currElem.generatePrefix(this._rootNsContext, this._cfgAutomaticNsPrefix, this._autoNsSeq);
            this._writeNamespace(prefix, uri);
            this._currElem.addPrefix(prefix, uri);
        }
        return this._symbols.findSymbol(prefix, localName);
    }

    public void _writeStartOrEmpty(String prefix, String localName, String nsURI, boolean isEmpty) throws XMLStreamException {
        if (nsURI == null || nsURI.length() == 0) {
            this._verifyStartElement(null, localName);
            WName name = this._symbols.findSymbol(localName);
            this._writeStartTag(name, isEmpty, null);
            if (!this._currElem.hasEmptyDefaultNs()) {
                this._writeDefaultNamespace(nsURI);
                this._currElem.setDefaultNsURI("");
            }
            if (this._validator != null) {
                this._validator.validateElementStart(localName, "", "");
            }
            return;
        }
        if (prefix == null) {
            prefix = this._currElem.getPrefix(nsURI);
            if (prefix != null) {
                this._writeStartAndVerify(prefix, localName, nsURI, isEmpty);
            } else {
                prefix = this._generateElemPrefix(nsURI);
                if (this._writeStartAndVerify(prefix, localName, nsURI, isEmpty)) {
                    this._writeDefaultNamespace(nsURI);
                    this._currElem.setDefaultNsURI(nsURI);
                } else {
                    this._writeNamespace(prefix, nsURI);
                    this._currElem.addPrefix(prefix, nsURI);
                }
            }
        } else {
            boolean isDef = this._writeStartAndVerify(prefix, localName, nsURI, isEmpty);
            if (!this._currElem.isPrefixBoundTo(prefix, nsURI, this._rootNsContext)) {
                if (isDef) {
                    this._writeDefaultNamespace(nsURI);
                    this._currElem.setDefaultNsURI(nsURI);
                } else {
                    this._writeNamespace(prefix, nsURI);
                    this._currElem.addPrefix(prefix, nsURI);
                }
            }
        }
        if (this._validator != null) {
            this._validator.validateElementStart(localName, "", prefix == null ? "" : prefix);
        }
    }

    private final boolean _writeStartAndVerify(String prefix, String localName, String nsURI, boolean isEmpty) throws XMLStreamException {
        if (prefix == null || prefix.length() == 0) {
            this._verifyStartElement(null, localName);
            this._writeStartTag(this._symbols.findSymbol(localName), isEmpty, nsURI);
            return true;
        }
        this._verifyStartElement(prefix, localName);
        this._writeStartTag(this._symbols.findSymbol(prefix, localName), isEmpty, nsURI);
        return false;
    }

    protected final String _generateElemPrefix(String uri) throws XMLStreamException {
        String prefix;
        if (this._suggestedDefNs != null && this._suggestedDefNs.equals(uri)) {
            return null;
        }
        if (this._suggestedPrefixes != null && (prefix = this._suggestedPrefixes.get(uri)) != null) {
            return prefix;
        }
        if (this._autoNsSeq == null) {
            this._autoNsSeq = new int[1];
            this._autoNsSeq[0] = 1;
        }
        return this._currElem.generatePrefix(this._rootNsContext, this._cfgAutomaticNsPrefix, this._autoNsSeq);
    }
}

