/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import java.util.Collections;
import java.util.Iterator;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.apache.olingo.javax.xml.stream.XMLStreamException;
import org.apache.olingo.javax.xml.stream.XMLStreamWriter;

class AtomGeoValueSerializer {
    AtomGeoValueSerializer() {
    }

    private void points(XMLStreamWriter writer, Iterator<Point> itor, boolean wrap) throws XMLStreamException {
        while (itor.hasNext()) {
            Point point = itor.next();
            if (wrap) {
                writer.writeStartElement("gml", "Point", "http://www.opengis.net/gml");
            }
            writer.writeStartElement("gml", "pos", "http://www.opengis.net/gml");
            try {
                writer.writeCharacters(EdmDouble.getInstance().valueToString(point.getX(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null) + " " + EdmDouble.getInstance().valueToString(point.getY(), null, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, null));
            }
            catch (EdmPrimitiveTypeException e) {
                throw new XMLStreamException("While serializing point coordinates as double", e);
            }
            writer.writeEndElement();
            if (!wrap) continue;
            writer.writeEndElement();
        }
    }

    private void lineStrings(XMLStreamWriter writer, Iterator<LineString> itor, boolean wrap) throws XMLStreamException {
        while (itor.hasNext()) {
            LineString lineString = itor.next();
            if (wrap) {
                writer.writeStartElement("gml", "LineString", "http://www.opengis.net/gml");
            }
            this.points(writer, lineString.iterator(), false);
            if (!wrap) continue;
            writer.writeEndElement();
        }
    }

    private void polygons(XMLStreamWriter writer, Iterator<Polygon> itor, boolean wrap) throws XMLStreamException {
        while (itor.hasNext()) {
            Polygon polygon = itor.next();
            if (wrap) {
                writer.writeStartElement("gml", "Polygon", "http://www.opengis.net/gml");
            }
            if (!polygon.getExterior().isEmpty()) {
                writer.writeStartElement("gml", "exterior", "http://www.opengis.net/gml");
                writer.writeStartElement("gml", "LinearRing", "http://www.opengis.net/gml");
                this.points(writer, polygon.getExterior().iterator(), false);
                writer.writeEndElement();
                writer.writeEndElement();
            }
            for (int i = 0; i < polygon.getNumberOfInteriorRings(); ++i) {
                writer.writeStartElement("gml", "interior", "http://www.opengis.net/gml");
                writer.writeStartElement("gml", "LinearRing", "http://www.opengis.net/gml");
                this.points(writer, polygon.getInterior(i).iterator(), false);
                writer.writeEndElement();
                writer.writeEndElement();
            }
            if (!wrap) continue;
            writer.writeEndElement();
        }
    }

    private void writeSrsName(XMLStreamWriter writer, Geospatial value) throws XMLStreamException {
        if (value.getSrid() != null && value.getSrid().isNotDefault()) {
            writer.writeAttribute("gml", "http://www.opengis.net/gml", "srsName", "http://www.opengis.net/def/crs/EPSG/0/" + value.getSrid().toString());
        }
    }

    public void serialize(XMLStreamWriter writer, Geospatial value) throws XMLStreamException {
        switch (value.getEdmPrimitiveTypeKind()) {
            case GeographyPoint: 
            case GeometryPoint: {
                writer.writeStartElement("gml", "Point", "http://www.opengis.net/gml");
                this.writeSrsName(writer, value);
                this.points(writer, Collections.singleton((Point)value).iterator(), false);
                writer.writeEndElement();
                break;
            }
            case GeometryMultiPoint: 
            case GeographyMultiPoint: {
                writer.writeStartElement("gml", "MultiPoint", "http://www.opengis.net/gml");
                this.writeSrsName(writer, value);
                if (!((MultiPoint)value).isEmpty()) {
                    writer.writeStartElement("gml", "pointMembers", "http://www.opengis.net/gml");
                    this.points(writer, ((MultiPoint)value).iterator(), true);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                break;
            }
            case GeometryLineString: 
            case GeographyLineString: {
                writer.writeStartElement("gml", "LineString", "http://www.opengis.net/gml");
                this.writeSrsName(writer, value);
                this.lineStrings(writer, Collections.singleton((LineString)value).iterator(), false);
                writer.writeEndElement();
                break;
            }
            case GeometryMultiLineString: 
            case GeographyMultiLineString: {
                writer.writeStartElement("gml", "MultiCurve", "http://www.opengis.net/gml");
                this.writeSrsName(writer, value);
                if (!((MultiLineString)value).isEmpty()) {
                    writer.writeStartElement("gml", "curveMembers", "http://www.opengis.net/gml");
                    this.lineStrings(writer, ((MultiLineString)value).iterator(), true);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                break;
            }
            case GeographyPolygon: 
            case GeometryPolygon: {
                writer.writeStartElement("gml", "Polygon", "http://www.opengis.net/gml");
                this.writeSrsName(writer, value);
                this.polygons(writer, Collections.singleton((Polygon)value).iterator(), false);
                writer.writeEndElement();
                break;
            }
            case GeographyMultiPolygon: 
            case GeometryMultiPolygon: {
                writer.writeStartElement("gml", "MultiSurface", "http://www.opengis.net/gml");
                this.writeSrsName(writer, value);
                if (!((MultiPolygon)value).isEmpty()) {
                    writer.writeStartElement("gml", "surfaceMembers", "http://www.opengis.net/gml");
                    this.polygons(writer, ((MultiPolygon)value).iterator(), true);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                break;
            }
            case GeographyCollection: 
            case GeometryCollection: {
                writer.writeStartElement("gml", "MultiGeometry", "http://www.opengis.net/gml");
                this.writeSrsName(writer, value);
                if (!((GeospatialCollection)value).isEmpty()) {
                    writer.writeStartElement("gml", "geometryMembers", "http://www.opengis.net/gml");
                    for (Geospatial geospatial : (GeospatialCollection)value) {
                        this.serialize(writer, geospatial);
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                break;
            }
        }
    }
}

