/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class EdmReturnTypeImpl
implements EdmReturnType {
    private final CsdlReturnType returnType;
    private final Edm edm;
    private EdmType typeImpl;

    public EdmReturnTypeImpl(Edm edm, CsdlReturnType returnType) {
        this.edm = edm;
        this.returnType = returnType;
    }

    public boolean isCollection() {
        return this.returnType.isCollection();
    }

    public boolean isNullable() {
        return this.returnType.isNullable();
    }

    public Integer getMaxLength() {
        return this.returnType.getMaxLength();
    }

    public Integer getPrecision() {
        return this.returnType.getPrecision();
    }

    public Integer getScale() {
        return this.returnType.getScale();
    }

    public SRID getSrid() {
        return this.returnType.getSrid();
    }

    public EdmType getType() {
        if (this.typeImpl == null) {
            if (this.returnType.getType() == null) {
                throw new EdmException("Return types must hava a full qualified type.");
            }
            this.typeImpl = new EdmTypeInfo.Builder().setEdm(this.edm).setTypeExpression(this.returnType.getType()).build().getType();
            if (this.typeImpl == null) {
                throw new EdmException("Cannot find type with name: " + this.returnType.getType());
            }
        }
        return this.typeImpl;
    }
}

