/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.geo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.SRID;

public abstract class ComposedGeospatial<T extends Geospatial>
extends Geospatial
implements Iterable<T> {
    protected final List<T> geospatials = new ArrayList<T>();

    protected ComposedGeospatial(Geospatial.Dimension dimension, Geospatial.Type type, SRID srid, List<T> geospatials) {
        super(dimension, type, srid);
        if (geospatials != null) {
            this.geospatials.addAll(geospatials);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.geospatials.iterator();
    }

    public boolean isEmpty() {
        return this.geospatials.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComposedGeospatial other = (ComposedGeospatial)o;
        return this.dimension == other.dimension && (this.srid == null ? other.srid == null : this.srid.equals(other.srid)) && this.geospatials.equals(other.geospatials);
    }

    public int hashCode() {
        int result = this.dimension == null ? 0 : this.dimension.hashCode();
        result = 31 * result + (this.srid == null ? 0 : this.srid.hashCode());
        result = 31 * result + this.geospatials.hashCode();
        return result;
    }

    public String toString() {
        return this.geospatials.toString();
    }
}

