/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.debug.DebugInformation;
import org.apache.olingo.server.api.debug.DebugResponseHelper;
import org.apache.olingo.server.core.debug.DebugTab;
import org.apache.olingo.server.core.debug.DebugTabRequest;
import org.apache.olingo.server.core.debug.DebugTabResponse;
import org.apache.olingo.server.core.debug.DebugTabRuntime;
import org.apache.olingo.server.core.debug.DebugTabServer;
import org.apache.olingo.server.core.debug.DebugTabStacktrace;
import org.apache.olingo.server.core.debug.DebugTabUri;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;

public class DebugResponseHelperImpl
implements DebugResponseHelper {
    private final DebugFormat requestedFormat;

    public DebugResponseHelperImpl(String debugFormat) {
        this.requestedFormat = "html".equals(debugFormat) ? DebugFormat.HTML : ("download".equals(debugFormat) ? DebugFormat.DOWNLOAD : DebugFormat.JSON);
    }

    public ODataResponse createDebugResponse(DebugInformation debugInfo) {
        try {
            String contentTypeString;
            InputStream body;
            List<DebugTab> parts = this.createParts(debugInfo);
            ODataResponse response = new ODataResponse();
            if (this.requestedFormat == DebugFormat.DOWNLOAD || this.requestedFormat == DebugFormat.HTML) {
                String title = debugInfo.getRequest() == null ? "V4 Service" : "V4 Service: " + debugInfo.getRequest().getRawODataPath();
                body = this.wrapInHtml(parts, title);
                contentTypeString = ContentType.TEXT_HTML.toContentTypeString();
            } else {
                body = this.wrapInJson(parts);
                contentTypeString = ContentType.APPLICATION_JSON.toContentTypeString();
            }
            if (this.requestedFormat == DebugFormat.DOWNLOAD) {
                response.setHeader("Content-Disposition", "attachment; filename=OData-Response." + new Date().toString().replace(' ', '_').replace(':', '.') + ".html");
            }
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", contentTypeString);
            response.setContent(body);
            return response;
        }
        catch (IOException e) {
            throw new ODataRuntimeException((Exception)e);
        }
    }

    private List<DebugTab> createParts(DebugInformation debugInfo) {
        List runtimeInformation;
        ArrayList<DebugTab> parts = new ArrayList<DebugTab>();
        parts.add(new DebugTabRequest(debugInfo.getRequest()));
        parts.add(new DebugTabResponse(debugInfo.getApplicationResponse()));
        Map serverEnvironmentVariables = debugInfo.getServerEnvironmentVariables();
        if (serverEnvironmentVariables != null && !serverEnvironmentVariables.isEmpty()) {
            parts.add(new DebugTabServer(serverEnvironmentVariables));
        }
        if (debugInfo.getUriInfo() != null) {
            parts.add(new DebugTabUri(debugInfo.getUriInfo()));
        }
        if ((runtimeInformation = debugInfo.getRuntimeInformation()) != null && !runtimeInformation.isEmpty()) {
            parts.add(new DebugTabRuntime(runtimeInformation));
        }
        if (debugInfo.getException() != null) {
            parts.add(new DebugTabStacktrace(debugInfo.getException()));
        }
        return parts;
    }

    private InputStream wrapInJson(List<DebugTab> parts) throws IOException {
        OutputStream outputStream = null;
        CircleStreamBuffer csb = new CircleStreamBuffer();
        outputStream = csb.getOutputStream();
        try {
            InputStream inputStream;
            block11: {
                JsonGenerator gen = new ObjectMapper().getFactory().createGenerator(outputStream);
                try {
                    gen.writeStartObject();
                    DebugTab requestInfo = parts.get(0);
                    gen.writeFieldName(requestInfo.getName().toLowerCase(Locale.ROOT));
                    requestInfo.appendJson(gen);
                    DebugTab responseInfo = parts.get(1);
                    gen.writeFieldName(responseInfo.getName().toLowerCase(Locale.ROOT));
                    responseInfo.appendJson(gen);
                    gen.writeFieldName("server");
                    gen.writeStartObject();
                    gen.writeStringField("version", DebugResponseHelperImpl.getVersion());
                    for (DebugTab part : parts.subList(2, parts.size())) {
                        gen.writeFieldName(part.getName().toLowerCase(Locale.ROOT));
                        part.appendJson(gen);
                    }
                    gen.writeEndObject();
                    gen.writeEndObject();
                    gen.close();
                    inputStream = csb.getInputStream();
                    if (gen == null) break block11;
                }
                catch (Throwable throwable) {
                    if (gen != null) {
                        try {
                            gen.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                gen.close();
            }
            return inputStream;
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    protected static String getVersion() {
        Package pack = DebugResponseHelperImpl.class.getPackage();
        String name = pack.getImplementationTitle();
        String version = pack.getImplementationVersion();
        return (name == null ? "Olingo" : name) + (version == null ? "" : " Version " + version);
    }

    private InputStream wrapInHtml(List<DebugTab> parts, String title) throws IOException {
        StringWriter writer = new StringWriter();
        writer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n").append("  \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n").append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n").append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n").append("<title>").append(DebugResponseHelperImpl.escapeHtml(title)).append("</title>\n").append("<style type=\"text/css\">\n").append("body { font-family: Arial, sans-serif; font-size: 13px;\n").append("       line-height: 16px; margin: 0;\n").append("       background-color: #eeeeee; color: #333333; }\n").append(".header { float: left; }\n").append(".header a { line-height: 22px; padding: 10px 18px;\n").append("            text-decoration: none; color: #333333; }\n").append(":target, .header:nth-last-child(2) { background-color: #cccccc; }\n").append(":target ~ .header:nth-last-child(2) { background-color: inherit; }\n").append(".header:focus, .header:hover,\n").append("  .header:nth-last-child(2):focus, .header:nth-last-child(2):hover\n").append("    { background-color: #999999; }\n").append(".section { position: absolute; top: 42px; min-width: 100%;\n").append("           padding-top: 18px; border-top: 1px solid #dddddd; }\n").append(".section > * { margin-left: 18px; }\n").append(":target + .section, .section:last-child { display: block; }\n").append(".section, :target + .section ~ .section { display: none; }\n").append("h1 { font-size: 18px; font-weight: normal; margin: 10px 0; }\n").append("h2 { font-size: 15px; }\n").append("h2:not(:first-child) { margin-top: 2em; }\n").append("table { border-collapse: collapse; border-spacing: 0;\n").append("        margin-top: 1.5em; }\n").append("table, thead { border-width: 1px 0; border-style: solid;\n").append("               border-color: #dddddd; text-align: left; }\n").append("th.name, td.name { padding: 1ex 2em 1ex 0; }\n").append("tbody > tr:hover { background-color: #cccccc; }\n").append(".code { font-family: \"Courier New\", monospace; }\n").append(".code, .tree li { line-height: 15px; }\n").append("ul, .tree { padding-left: 0; list-style-type: none; }\n").append(".null, .numeric { padding-left: 1.5em; }\n").append(".json { white-space: pre-wrap; }\n").append("</style>\n").append("</head>\n").append("<body>\n");
        char count = '0';
        for (DebugTab part : parts) {
            count = (char)(count + 1);
            writer.append("<div class=\"header\" id=\"sec").append(count).append("\">\n").append("<h1><a href=\"#sec").append(count).append("\">").append(part.getName()).append("</a></h1>\n").append("</div>\n").append("<div class=\"section\">\n");
            part.appendHtml(writer);
            writer.append("</div>\n");
        }
        writer.append("</body>\n").append("</html>\n").close();
        byte[] bytes = writer.toString().getBytes("UTF-8");
        return new ByteArrayInputStream(bytes);
    }

    protected static String escapeHtml(String value) {
        return value == null ? null : value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    protected static void appendJsonTable(JsonGenerator gen, Map<String, String> entries) throws IOException {
        if (entries == null || entries.isEmpty()) {
            gen.writeNull();
        } else {
            gen.writeStartObject();
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                gen.writeFieldName(entry.getKey());
                if (entry.getValue() == null) {
                    gen.writeNull();
                    continue;
                }
                gen.writeString(entry.getValue());
            }
            gen.writeEndObject();
        }
    }

    protected static void appendHtmlTable(Writer writer, Map<String, String> entries) throws IOException {
        writer.append("<table>\n<thead>\n").append("<tr><th class=\"name\">Name</th><th class=\"value\">Value</th></tr>\n").append("</thead>\n<tbody>\n");
        if (entries != null && !entries.isEmpty()) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                writer.append("<tr><td class=\"name\">").append(entry.getKey()).append("</td>").append("<td class=\"value\">").append(DebugResponseHelperImpl.escapeHtml(entry.getValue())).append("</td></tr>\n");
            }
        }
        writer.append("</tbody>\n</table>\n");
    }

    private static enum DebugFormat {
        JSON,
        HTML,
        DOWNLOAD;

    }
}

