/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Embeddable;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.meta.strats.AbstractValueHandler;
import org.apache.openjpa.jdbc.meta.strats.MaxEmbeddedLobFieldStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.kernel.ObjectIdStateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.MetaDataException;

public abstract class EmbedValueHandler
extends AbstractValueHandler {
    private static final Localizer _loc = Localizer.forPackage(EmbedValueHandler.class);

    protected void map(ValueMapping vm, String name, ColumnIO io, boolean adapt, List cols, List args) {
        DBDictionary dict = vm.getMappingRepository().getDBDictionary();
        DBIdentifier colName = DBIdentifier.newColumn(name, dict != null ? dict.delimitAll() : false);
        this.map(vm, colName, io, adapt, cols, args);
    }

    protected void map(ValueMapping vm, DBIdentifier name, ColumnIO io, boolean adapt, List cols, List args) {
        vm.getEmbeddedMapping().resolve(1 | 2);
        FieldMapping[] fms = vm.getEmbeddedMapping().getFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            int j;
            if (fms[i].getManagement() != 3) continue;
            FieldStrategy strat = fms[i].getStrategy();
            if (!(strat instanceof Embeddable)) {
                throw new MetaDataException(_loc.get("not-embeddable", vm, fms[i]));
            }
            ValueMapping val = fms[i].getValueMapping();
            if (val.getEmbeddedMapping() != null) {
                this.map(val, name, io, adapt, cols, args);
            }
            Column[] curCols = ((Embeddable)((Object)strat)).getColumns();
            ColumnIO curIO = ((Embeddable)((Object)strat)).getColumnIO();
            for (j = 0; j < curCols.length; ++j) {
                io.setInsertable(cols.size(), curIO.isInsertable(j, false));
                io.setNullInsertable(cols.size(), curIO.isInsertable(j, true));
                io.setUpdatable(cols.size(), curIO.isUpdatable(j, false));
                io.setNullUpdatable(cols.size(), curIO.isUpdatable(j, true));
                cols.add(curCols[j]);
            }
            Object[] curArgs = ((Embeddable)((Object)fms[i].getStrategy())).getResultArguments();
            if (curCols.length == 1) {
                args.add(curArgs);
                continue;
            }
            if (curCols.length <= 1) continue;
            for (j = 0; j < curCols.length; ++j) {
                args.add(curArgs == null ? null : curArgs[j]);
            }
        }
    }

    protected Object toDataStoreValue(OpenJPAStateManager em, ValueMapping vm, JDBCStore store, Column[] cols, Object rval, int idx) {
        ArrayList<Object> rvals = new ArrayList<Object>();
        if (rval != null) {
            rvals.add(rval);
        }
        this.toDataStoreValue1(em, vm, store, cols, rvals, idx);
        return rvals.get(0);
    }

    protected int toDataStoreValue1(OpenJPAStateManager em, ValueMapping vm, JDBCStore store, Column[] cols, List rvals, int idx) {
        FieldMapping[] fms = vm.getEmbeddedMapping().getFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            Object rval;
            Embeddable embed;
            Column[] ecols;
            Object cval;
            if (fms[i].getManagement() != 3) continue;
            ValueMapping val = fms[i].getValueMapping();
            if (val.getEmbeddedMapping() != null) {
                Object object = cval = em == null ? null : em.fetch(i);
                if (cval instanceof PersistenceCapable) {
                    OpenJPAStateManager embedSm = (OpenJPAStateManager)((PersistenceCapable)cval).pcGetStateManager();
                    idx = this.toDataStoreValue1(embedSm, val, store, cols, rvals, idx);
                } else if (cval instanceof ObjectIdStateManager) {
                    idx = this.toDataStoreValue1((ObjectIdStateManager)cval, val, store, cols, rvals, idx);
                } else if (cval == null) {
                    idx = this.toDataStoreValue1(null, val, store, cols, rvals, idx);
                }
            }
            if ((ecols = (embed = (Embeddable)((Object)fms[i].getStrategy())).getColumns()).length == 0) continue;
            cval = em == null ? null : this.getValue(embed, em, i);
            cval = embed.toEmbeddedDataStoreValue(cval, store);
            if (cols.length == 1) {
                rvals.add(cval);
                continue;
            }
            if (ecols.length == 1) {
                rval = rvals.get(0);
                ((Object[])rval)[idx++] = cval;
                continue;
            }
            rval = rvals.get(0);
            System.arraycopy(cval, 0, rval, idx, ecols.length);
            idx += ecols.length;
        }
        return idx;
    }

    private Object getValue(Embeddable embed, OpenJPAStateManager sm, int idx) {
        if (embed instanceof MaxEmbeddedLobFieldStrategy) {
            return ((MaxEmbeddedLobFieldStrategy)embed).getValue(sm);
        }
        return sm.fetch(idx);
    }

    protected void toObjectValue(OpenJPAStateManager em, ValueMapping vm, Object val, JDBCStore store, JDBCFetchConfiguration fetch, Column[] cols, int idx) throws SQLException {
        this.toObjectValue1(em, vm, val, store, fetch, cols, idx);
    }

    protected int toObjectValue1(OpenJPAStateManager em, ValueMapping vm, Object val, JDBCStore store, JDBCFetchConfiguration fetch, Column[] cols, int idx) throws SQLException {
        FieldMapping[] fms = vm.getEmbeddedMapping().getFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            Object cval;
            if (fms[i].getManagement() != 3) continue;
            ValueMapping vm1 = fms[i].getValueMapping();
            OpenJPAStateManager em1 = null;
            Embeddable embed = (Embeddable)((Object)fms[i].getStrategy());
            if (vm1.getEmbeddedMapping() != null) {
                if (em instanceof StateManagerImpl) {
                    em1 = store.getContext().embed(null, null, em, vm1);
                    idx = this.toObjectValue1(em1, vm1, val, store, fetch, cols, idx);
                } else if (em instanceof ObjectIdStateManager) {
                    em1 = new ObjectIdStateManager(null, null, vm1);
                    idx = this.toObjectValue1(em1, vm1, val, store, null, this.getColumns(fms[i]), idx);
                }
                cval = em1 != null ? em1.getManagedInstance() : null;
            } else {
                Column[] ecols = embed.getColumns();
                if (ecols.length == 0) {
                    cval = null;
                } else if (idx == 0 && ecols.length == cols.length) {
                    cval = val;
                } else if (ecols.length == 1) {
                    cval = ((Object[])val)[idx++];
                } else {
                    cval = new Object[ecols.length];
                    System.arraycopy(val, idx, cval, 0, ecols.length);
                    idx += ecols.length;
                }
            }
            if (store != null && em instanceof StateManagerImpl) {
                embed.loadEmbedded(em, store, fetch, cval);
                continue;
            }
            if (!(em instanceof ObjectIdStateManager)) {
                cval = embed.toEmbeddedObjectValue(cval);
            }
            if (fms[i].getHandler() != null) {
                cval = fms[i].getHandler().toObjectValue(fms[i], cval);
            }
            em.store(fms[i].getIndex(), cval);
        }
        return idx;
    }

    private Column[] getColumns(FieldMapping fm) {
        ArrayList colList = new ArrayList();
        EmbedValueHandler.getEmbeddedIdCols(fm, colList);
        Column[] cols = new Column[colList.size()];
        int i = 0;
        for (Column col : colList) {
            cols[i++] = col;
        }
        return cols;
    }

    public static void getEmbeddedIdCols(FieldMapping fmd, List cols) {
        ClassMapping embed = fmd.getEmbeddedMapping();
        FieldMapping[] fmds = embed.getFieldMappings();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].getValue().getEmbeddedMetaData() == null) {
                EmbedValueHandler.getIdColumns(fmds[i], cols);
                continue;
            }
            EmbedValueHandler.getEmbeddedIdCols(fmds[i], cols);
        }
    }

    public static void getIdColumns(FieldMapping fmd, List cols) {
        Column[] pkCols = ((ValueMappingImpl)fmd.getValue()).getColumns();
        for (int j = 0; j < pkCols.length; ++j) {
            Column newCol = new Column();
            newCol.copy(pkCols[j]);
            cols.add(newCol);
        }
    }
}

