/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.kernel.DataCacheRetrieveMode;
import org.apache.openjpa.kernel.DataCacheStoreMode;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class DelegatingFetchConfiguration
implements FetchConfiguration {
    private final FetchConfiguration _fetch;
    private final DelegatingFetchConfiguration _del;
    private final RuntimeExceptionTranslator _trans;

    public DelegatingFetchConfiguration(FetchConfiguration fetch) {
        this(fetch, null);
    }

    public DelegatingFetchConfiguration(FetchConfiguration fetch, RuntimeExceptionTranslator trans) {
        this._fetch = fetch;
        this._del = fetch instanceof DelegatingFetchConfiguration ? (DelegatingFetchConfiguration)fetch : null;
        this._trans = trans;
    }

    public FetchConfiguration getDelegate() {
        return this._fetch;
    }

    public FetchConfiguration getInnermostDelegate() {
        return this._del == null ? this._fetch : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingFetchConfiguration) {
            other = ((DelegatingFetchConfiguration)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    protected RuntimeException translate(RuntimeException re) {
        return this._trans == null ? re : this._trans.translate(re);
    }

    @Override
    public StoreContext getContext() {
        try {
            return this._fetch.getContext();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void setContext(StoreContext ctx) {
        try {
            this._fetch.setContext(ctx);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int getFetchBatchSize() {
        try {
            return this._fetch.getFetchBatchSize();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setFetchBatchSize(int fetchBatchSize) {
        try {
            this._fetch.setFetchBatchSize(fetchBatchSize);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int getMaxFetchDepth() {
        try {
            return this._fetch.getMaxFetchDepth();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setMaxFetchDepth(int depth) {
        try {
            this._fetch.setMaxFetchDepth(depth);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Set getRootInstances() {
        try {
            return this._fetch.getRootInstances();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setRootInstances(Collection roots) {
        try {
            this._fetch.setRootInstances(roots);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Set getRootClasses() {
        try {
            return this._fetch.getRootClasses();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration setRootClasses(Collection roots) {
        try {
            this._fetch.setRootClasses(roots);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean getQueryCacheEnabled() {
        try {
            return this._fetch.getQueryCacheEnabled();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setQueryCacheEnabled(boolean cache) {
        try {
            this._fetch.setQueryCacheEnabled(cache);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int getFlushBeforeQueries() {
        try {
            return this._fetch.getFlushBeforeQueries();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setFlushBeforeQueries(int flush) {
        try {
            this._fetch.setFlushBeforeQueries(flush);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean getExtendedPathLookup() {
        try {
            return this._fetch.getExtendedPathLookup();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setExtendedPathLookup(boolean flag) {
        try {
            this._fetch.setExtendedPathLookup(flag);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Set getFetchGroups() {
        try {
            return this._fetch.getFetchGroups();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean hasFetchGroup(String group) {
        try {
            return this._fetch.hasFetchGroup(group);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration addFetchGroup(String group) {
        try {
            this._fetch.addFetchGroup(group);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration addFetchGroups(Collection groups) {
        try {
            this._fetch.addFetchGroups(groups);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration removeFetchGroup(String group) {
        try {
            this._fetch.removeFetchGroup(group);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration removeFetchGroups(Collection groups) {
        try {
            this._fetch.removeFetchGroups(groups);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration clearFetchGroups() {
        try {
            this._fetch.clearFetchGroups();
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration resetFetchGroups() {
        try {
            this._fetch.resetFetchGroups();
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public Set getFields() {
        try {
            return this._fetch.getFields();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean hasField(String field) {
        try {
            return this._fetch.hasField(field);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration addField(String field) {
        try {
            this._fetch.addField(field);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration addFields(Collection fields) {
        try {
            this._fetch.addFields(fields);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration removeField(String field) {
        try {
            this._fetch.removeField(field);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public FetchConfiguration removeFields(Collection fields) {
        try {
            this._fetch.removeFields(fields);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration clearFields() {
        try {
            this._fetch.clearFields();
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int getLockTimeout() {
        try {
            return this._fetch.getLockTimeout();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setLockTimeout(int timeout) {
        try {
            this._fetch.setLockTimeout(timeout);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int getQueryTimeout() {
        try {
            return this._fetch.getQueryTimeout();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setQueryTimeout(int timeout) {
        try {
            this._fetch.setQueryTimeout(timeout);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int getLockScope() {
        try {
            return this._fetch.getLockScope();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setLockScope(int scope) {
        try {
            this._fetch.setLockScope(scope);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int getReadLockLevel() {
        try {
            return this._fetch.getReadLockLevel();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setReadLockLevel(int level) {
        try {
            this._fetch.setReadLockLevel(level);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int getWriteLockLevel() {
        try {
            return this._fetch.getWriteLockLevel();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration setWriteLockLevel(int level) {
        try {
            this._fetch.setWriteLockLevel(level);
            return this;
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    public ResultList newResultList(ResultObjectProvider rop) {
        try {
            return this._fetch.newResultList(rop);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void copy(FetchConfiguration fetch) {
        try {
            this._fetch.copy(fetch);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Object clone() {
        try {
            return this._fetch.clone();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void setHint(String name, Object value) {
        try {
            this._fetch.setHint(name, value);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void setHint(String name, Object value, Object original) {
        try {
            this._fetch.setHint(name, value, original);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean isHintSet(String key) {
        try {
            return this._fetch.isHintSet(key);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean isDefaultPUFetchGroupConfigurationOnly() {
        try {
            return this._fetch.isDefaultPUFetchGroupConfigurationOnly();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Object getHint(String name) {
        try {
            return this._fetch.getHint(name);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Map<String, Object> getHints() {
        try {
            return this._fetch.getHints();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public int requiresFetch(FieldMetaData fmd) {
        try {
            return this._fetch.requiresFetch(fmd);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean requiresLoad() {
        try {
            return this._fetch.requiresLoad();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration traverse(FieldMetaData fmd) {
        try {
            return this._fetch.traverse(fmd);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void lock() {
        try {
            this._fetch.lock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void unlock() {
        try {
            this._fetch.unlock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public DataCacheRetrieveMode getCacheRetrieveMode() {
        try {
            return this._fetch.getCacheRetrieveMode();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public DataCacheStoreMode getCacheStoreMode() {
        try {
            return this._fetch.getCacheStoreMode();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void setCacheRetrieveMode(DataCacheRetrieveMode mode) {
        try {
            this._fetch.setCacheRetrieveMode(mode);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void setCacheStoreMode(DataCacheStoreMode mode) {
        try {
            this._fetch.setCacheStoreMode(mode);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean isFetchConfigurationSQLCacheAdmissible() {
        try {
            return this._fetch.isFetchConfigurationSQLCacheAdmissible();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }
}

