/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.BooleanRepresentationFactory;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.util.StringUtil;

public class H2Dictionary
extends DBDictionary {
    private static final List<String> V2_KEYWORDS = Arrays.asList("ALL", "AND", "ANY", "ARRAY", "AS", "ASYMMETRIC", "AUTHORIZATION", "BETWEEN", "BOTH", "CASE", "CAST", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DAY", "DEFAULT", "DISTINCT", "ELSE", "END", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FILTER", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "GROUPS", "HAVING", "HOUR", "IF", "ILIKE", "IN", "INNER", "INTERSECT", "INTERSECTS", "INTERVAL", "IS", "JOIN", "KEY", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "MINUS", "MINUTE", "MONTH", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "OR", "ORDER", "OVER", "PARTITION", "PRIMARY", "QUALIFY", "RANGE", "REGEXP", "RIGHT", "ROW", "ROWNUM", "ROWS", "SECOND", "SELECT", "SESSION_USER", "SET", "SOME", "SYMMETRIC", "SYSTEM_USER", "TABLE", "TO", "TOP", "TRAILING", "TRUE", "UESCAPE", "UNION", "UNIQUE", "UNKNOWN", "USER", "USING", "VALUE", "VALUES", "WHEN", "WHERE", "WINDOW", "WITH", "YEAR", "_ROWID_");

    public H2Dictionary() {
        this.platform = "H2";
        this.validationSQL = "CALL 1";
        this.closePoolSQL = "SHUTDOWN";
        this.supportsAutoAssign = true;
        this.lastGeneratedKeyQuery = "CALL IDENTITY()";
        this.autoAssignClause = "IDENTITY";
        this.autoAssignTypeName = "INTEGER";
        this.nextSequenceQuery = "CALL NEXT VALUE FOR {0}";
        this.stringLengthFunction = "LENGTH({0})";
        this.trimLeadingFunction = "LTRIM({0})";
        this.trimTrailingFunction = "RTRIM({0})";
        this.trimBothFunction = "TRIM({0})";
        this.supportsSelectStartIndex = true;
        this.supportsSelectEndIndex = true;
        this.rangePosition = 3;
        this.supportsDeferredConstraints = false;
        this.supportsNullTableForGetPrimaryKeys = true;
        this.supportsNullTableForGetIndexInfo = true;
        this.supportsLockingWithOuterJoin = false;
        this.supportsLockingWithInnerJoin = false;
        this.timeWithZoneTypeName = "TIME";
        this.reservedWordSet.addAll(Arrays.asList("ALL", "CHECK", "CONSTRAINT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DISTINCT", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "INNER", "INTERSECT", "IS", "JOIN", "LIKE", "LIMIT", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "ORDER", "PRIMARY", "ROWNUM", "SELECT", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TODAY", "TRUE", "UNION", "UNIQUE", "WHERE", "WITH"));
        this.invalidColumnWordSet.addAll(Arrays.asList("CHECK", "CONSTRAINT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DISTINCT", "END-EXEC", "EXCEPT", "EXISTS", "FALSE", "FETCH", "FOR", "FOREIGN", "FROM", "FULL", "GROUP", "HAVING", "INNER", "INTERSECT", "IS", "JOIN", "LIKE", "LIMIT", "MINUS", "NATURAL", "NOT", "NULL", "OFFSET", "ON", "ORDER", "PRIMARY", "ROWNUM", "SELECT", "SYSDATE", "TRUE", "UNION", "UNIQUE", "WHERE", "WITH"));
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        if (this.versionLaterThan(1)) {
            this.supportsGetGeneratedKeys = true;
            this.supportsNullTableForGetPrimaryKeys = false;
            this.supportsNullTableForGetIndexInfo = false;
            this.autoAssignClause = "GENERATED ALWAYS AS IDENTITY";
            this.bitTypeName = "BOOLEAN";
            this.timeTypeName = "TIME(9)";
            this.timestampTypeName = "TIMESTAMP(9)";
            this.timeWithZoneTypeName = "TIME(9) WITH TIME ZONE";
            this.timestampWithZoneTypeName = "TIMESTAMP(9) WITH TIME ZONE";
            this.booleanRepresentation = BooleanRepresentationFactory.BOOLEAN;
            this.booleanTypeName = "BOOLEAN";
            this.reservedWordSet.clear();
            this.reservedWordSet.addAll(V2_KEYWORDS);
            this.invalidColumnWordSet.clear();
            this.invalidColumnWordSet.addAll(V2_KEYWORDS);
        }
    }

    @Override
    public int getJDBCType(int metaTypeCode, boolean lob) {
        int type = super.getJDBCType(metaTypeCode, lob);
        switch (type) {
            case -5: {
                if (metaTypeCode != 25) break;
                return 2;
            }
        }
        return type;
    }

    @Override
    public int getPreferredType(int type) {
        if (type == -7) {
            return 16;
        }
        return type;
    }

    @Override
    public String[] getAddPrimaryKeySQL(PrimaryKey pk) {
        return new String[0];
    }

    @Override
    public String[] getDropPrimaryKeySQL(PrimaryKey pk) {
        return new String[0];
    }

    @Override
    public String[] getAddColumnSQL(Column column) {
        return new String[]{"ALTER TABLE " + this.getFullName(column.getTable(), false) + " ADD COLUMN " + this.getDeclareColumnSQL(column, true)};
    }

    @Override
    public String[] getCreateTableSQL(Table table) {
        Unique[] unqs;
        String pkStr;
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ").append(this.getFullName(table, false)).append(" (");
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getDeclareColumnSQL(cols[i], false));
        }
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && !StringUtil.isEmpty(pkStr = this.getPrimaryKeyConstraintSQL(pk))) {
            buf.append(", ").append(pkStr);
        }
        for (Unique unq : unqs = table.getUniques()) {
            String unqStr = this.getUniqueConstraintSQL(unq);
            if (unqStr == null) continue;
            buf.append(", ").append(unqStr);
        }
        buf.append(")");
        return new String[]{buf.toString()};
    }

    @Override
    protected String getPrimaryKeyConstraintSQL(PrimaryKey pk) {
        if (this.versionLaterThan(1)) {
            return super.getPrimaryKeyConstraintSQL(pk);
        }
        Column[] cols = pk.getColumns();
        if (cols.length == 1 && cols[0].isAutoAssigned()) {
            return null;
        }
        return super.getPrimaryKeyConstraintSQL(pk);
    }

    @Override
    public boolean isSystemIndex(String name, Table table) {
        return name.toUpperCase(Locale.ENGLISH).startsWith("SYSTEM_");
    }

    @Override
    public boolean isSystemIndex(DBIdentifier name, Table table) {
        if (DBIdentifier.isNull(name)) {
            return false;
        }
        return name.getName().toUpperCase(Locale.ENGLISH).startsWith("SYSTEM_");
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return this.getSequencesSQL(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName));
    }

    @Override
    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT SEQUENCE_SCHEMA, SEQUENCE_NAME FROM ").append("INFORMATION_SCHEMA.SEQUENCES");
        if (!DBIdentifier.isNull(schemaName) || !DBIdentifier.isNull(sequenceName)) {
            buf.append(" WHERE ");
        }
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append("SEQUENCE_SCHEMA = ?");
            if (!DBIdentifier.isNull(sequenceName)) {
                buf.append(" AND ");
            }
        }
        if (!DBIdentifier.isNull(sequenceName)) {
            buf.append("SEQUENCE_NAME = ?");
        }
        return buf.toString();
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        return this.getColumns(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), DBIdentifier.newColumn(columnName), conn);
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, DBIdentifier columnName, Connection conn) throws SQLException {
        Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
        return cols;
    }

    @Override
    public void setLocalDate(PreparedStatement stmnt, int idx, LocalDate val, Column col) throws SQLException {
        stmnt.setObject(idx, val);
    }

    @Override
    public LocalDate getLocalDate(ResultSet rs, int column) throws SQLException {
        return rs.getObject(column, LocalDate.class);
    }

    @Override
    public void setLocalTime(PreparedStatement stmnt, int idx, LocalTime val, Column col) throws SQLException {
        stmnt.setObject(idx, val);
    }

    @Override
    public LocalTime getLocalTime(ResultSet rs, int column) throws SQLException {
        return rs.getObject(column, LocalTime.class);
    }

    @Override
    public void setLocalDateTime(PreparedStatement stmnt, int idx, LocalDateTime val, Column col) throws SQLException {
        stmnt.setObject(idx, val);
    }

    @Override
    public LocalDateTime getLocalDateTime(ResultSet rs, int column) throws SQLException {
        return rs.getObject(column, LocalDateTime.class);
    }

    @Override
    public void setOffsetDateTime(PreparedStatement stmnt, int idx, OffsetDateTime val, Column col) throws SQLException {
        stmnt.setObject(idx, val);
    }

    @Override
    public int getInt(ResultSet rs, int column) throws SQLException {
        BigDecimal decRes = rs.getBigDecimal(column);
        return decRes == null ? 0 : decRes.intValue();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(ResultSet rs, int column) throws SQLException {
        return rs.getObject(column, OffsetDateTime.class);
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        if (end != Long.MAX_VALUE) {
            buf.append(" LIMIT ").appendValue(end - start);
        }
        if (start != 0L) {
            buf.append(" OFFSET ").appendValue(start);
        }
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("LOCATE(");
        find.appendTo(buf);
        buf.append(", ");
        str.appendTo(buf);
        if (start != null) {
            buf.append(", ");
            start.appendTo(buf);
        }
        buf.append(")");
    }

    @Override
    public boolean isFatalException(int subtype, SQLException ex) {
        int errorCode = ex.getErrorCode();
        if (!(subtype != 6 && subtype != 1 || 57014 != errorCode && 50200 != errorCode)) {
            return false;
        }
        return super.isFatalException(subtype, ex);
    }
}

