/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MappedSuperclassType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.StaticMetamodel;
import jakarta.persistence.metamodel.Type;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.Resolver;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.Members;
import org.apache.openjpa.persistence.meta.Types;
import org.apache.openjpa.util.InternalException;

public class MetamodelImpl
implements Metamodel,
Resolver {
    private final MetaDataRepository repos;
    private Map<Class<?>, jakarta.persistence.metamodel.Type<?>> _basics = new HashMap();
    private Map<Class<?>, EntityType<?>> _entities = new HashMap();
    private Set<EntityType<?>> _entitiesOnlySet = null;
    private Map<Class<?>, EmbeddableType<?>> _embeddables = new HashMap();
    private Map<Class<?>, MappedSuperclassType<?>> _mappedsupers = new HashMap();
    private Map<Class<?>, Types.PseudoEntity<?>> _pseudos = new HashMap();
    private static Localizer _loc = Localizer.forPackage(MetamodelImpl.class);

    public MetamodelImpl(MetaDataRepository repos) {
        this.repos = repos;
        Collection<Class<?>> classes = repos.loadPersistentTypes(true, null);
        for (Class<?> cls : classes) {
            if (repos.skipMetadata(cls)) continue;
            ClassMetaData meta = repos.getMetaData(cls, null, true);
            Type.PersistenceType type = MetamodelImpl.getPersistenceType(meta);
            switch (type) {
                case ENTITY: {
                    this.find(cls, this._entities, Type.PersistenceType.ENTITY, false);
                    if (!meta.isEmbeddable()) break;
                    this.find(cls, this._embeddables, Type.PersistenceType.EMBEDDABLE, false);
                    break;
                }
                case EMBEDDABLE: {
                    this.find(cls, this._embeddables, Type.PersistenceType.EMBEDDABLE, false);
                    break;
                }
                case MAPPED_SUPERCLASS: {
                    this.find(cls, this._mappedsupers, Type.PersistenceType.MAPPED_SUPERCLASS, false);
                    break;
                }
            }
        }
    }

    public MetaDataRepository getRepository() {
        return this.repos;
    }

    @Override
    public <X> EmbeddableType<X> embeddable(Class<X> clazz) {
        return this.find(clazz, this._embeddables, Type.PersistenceType.EMBEDDABLE, false);
    }

    @Override
    public <X> EntityType<X> entity(Class<X> clazz) {
        return this.find(clazz, this._entities, Type.PersistenceType.ENTITY, false);
    }

    public <X> EntityType<X> entityImpl(Class<X> clazz) {
        return this.find(clazz, this._entities, Type.PersistenceType.ENTITY, true);
    }

    private Collection<EntityType<?>> getEntityValuesOnly() {
        if (this._entitiesOnlySet == null) {
            this._entitiesOnlySet = new HashSet();
            for (Class<?> cls : this._entities.keySet()) {
                if (this._embeddables.containsKey(cls)) continue;
                this._entitiesOnlySet.add(this._entities.get(cls));
            }
        }
        return this._entitiesOnlySet;
    }

    @Override
    public Set<EmbeddableType<?>> getEmbeddables() {
        return this.unmodifiableSet(this._embeddables.values());
    }

    @Override
    public Set<EntityType<?>> getEntities() {
        return this.unmodifiableSet(this.getEntityValuesOnly());
    }

    @Override
    public Set<ManagedType<?>> getManagedTypes() {
        HashSet result = new HashSet();
        result.addAll(this.getEntityValuesOnly());
        result.addAll(this._embeddables.values());
        result.addAll(this._mappedsupers.values());
        return result;
    }

    @Override
    public <X> ManagedType<X> managedType(Class<X> clazz) {
        if (this._embeddables.containsKey(clazz)) {
            return this._embeddables.get(clazz);
        }
        if (this._entities.containsKey(clazz)) {
            return this._entities.get(clazz);
        }
        if (this._mappedsupers.containsKey(clazz)) {
            return this._mappedsupers.get(clazz);
        }
        throw new IllegalArgumentException(_loc.get("type-not-managed", clazz).getMessage());
    }

    public <X> jakarta.persistence.metamodel.Type<X> getType(Class<X> cls) {
        try {
            return this.managedType(cls);
        }
        catch (IllegalArgumentException ex) {
            if (this._basics.containsKey(cls)) {
                return this._basics.get(cls);
            }
            if (this._pseudos.containsKey(cls)) {
                return this._pseudos.get(cls);
            }
            if (Map.class.isAssignableFrom(cls)) {
                Types.PseudoEntity<X> pseudo = new Types.PseudoEntity<X>(cls, this);
                this._pseudos.put(cls, new Types.PseudoEntity<X>(cls, this));
                return pseudo;
            }
            Types.Basic<X> basic = new Types.Basic<X>(cls);
            this._basics.put(cls, basic);
            return basic;
        }
    }

    public static Type.PersistenceType getPersistenceType(ClassMetaData meta) {
        if (meta == null) {
            return Type.PersistenceType.BASIC;
        }
        if (meta.isAbstract()) {
            return Type.PersistenceType.MAPPED_SUPERCLASS;
        }
        if (meta.isEmbeddable()) {
            return Type.PersistenceType.EMBEDDABLE;
        }
        return Type.PersistenceType.ENTITY;
    }

    private <V extends ManagedType<?>> V find(Class<?> cls, Map<Class<?>, V> container, Type.PersistenceType expected, boolean implFind) {
        if (container.containsKey(cls) && (implFind || expected != Type.PersistenceType.ENTITY || !this._embeddables.containsKey(cls))) {
            return (V)((ManagedType)container.get(cls));
        }
        ClassMetaData meta = this.repos.getMetaData(cls, null, false);
        if (meta != null) {
            this.instantiate(cls, meta, container, expected);
        }
        return (V)((ManagedType)container.get(cls));
    }

    private <X, V extends ManagedType<?>> void instantiate(Class<X> cls, ClassMetaData meta, Map<Class<?>, V> container, Type.PersistenceType expected) {
        Type.PersistenceType actual = MetamodelImpl.getPersistenceType(meta);
        if (!(actual == expected || meta.isEmbeddable() && actual == Type.PersistenceType.ENTITY && expected == Type.PersistenceType.EMBEDDABLE)) {
            throw new IllegalArgumentException(_loc.get("type-wrong-category", cls, (Object)actual, (Object)expected).getMessage());
        }
        switch (actual) {
            case EMBEDDABLE: {
                Types.Embeddable embedded = new Types.Embeddable(meta, this);
                this._embeddables.put(cls, embedded);
                this.populate(embedded);
            }
            case ENTITY: {
                Types.Entity entity = new Types.Entity(meta, this);
                this._entities.put(cls, entity);
                this._entitiesOnlySet = null;
                this.populate(entity);
                break;
            }
            case MAPPED_SUPERCLASS: {
                Types.MappedSuper mapped = new Types.MappedSuper(meta, this);
                this._mappedsupers.put(cls, mapped);
                this.populate(mapped);
                break;
            }
            default: {
                throw new InternalException(cls.getName());
            }
        }
    }

    public <T> Set<T> unmodifiableSet(Collection<T> coll) {
        HashSet<T> result = new HashSet<T>();
        for (T t : coll) {
            result.add(t);
        }
        return result;
    }

    static PluralAttribute.CollectionType categorizeCollection(Class<?> cls) {
        if (Set.class.isAssignableFrom(cls)) {
            return PluralAttribute.CollectionType.SET;
        }
        if (List.class.isAssignableFrom(cls)) {
            return PluralAttribute.CollectionType.LIST;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return PluralAttribute.CollectionType.COLLECTION;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return PluralAttribute.CollectionType.MAP;
        }
        throw new InternalException(cls.getName() + " not a collection");
    }

    public <X> void populate(AbstractManagedType<X> type) {
        Field[] mfields;
        Class cls = type.getJavaType();
        Class<?> mcls = this.repos.getMetaModel(cls, true);
        if (mcls == null) {
            return;
        }
        StaticMetamodel anno = mcls.getAnnotation(StaticMetamodel.class);
        if (anno == null) {
            throw new IllegalArgumentException(_loc.get("meta-class-no-anno", mcls.getName(), cls.getName(), StaticMetamodel.class.getName()).getMessage());
        }
        if (cls != anno.value()) {
            throw new IllegalStateException(_loc.get("meta-class-mismatch", mcls.getName(), cls.getName(), anno.value()).getMessage());
        }
        ParameterizedType mfType = null;
        Attribute<X, ?> f = null;
        for (Field mf : mfields = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction(mcls))) {
            try {
                mfType = this.getParameterizedType(mf);
                if (mfType == null) continue;
                f = type.getAttribute(mf.getName());
                mf.set(null, f);
            }
            catch (Exception e) {
                throw new RuntimeException(_loc.get("meta-field-mismatch", new Object[]{mf.getName(), mcls.getName(), this.toTypeName(mfType), f.getJavaType().toString()}).getMessage(), e);
            }
        }
    }

    ParameterizedType getParameterizedType(Field mf) {
        Type t = mf.getGenericType();
        if (!(t instanceof ParameterizedType)) {
            this.repos.getLog().warn(_loc.get("meta-field-not-param", mf.getDeclaringClass(), mf.getName(), this.toTypeName(t)).getMessage());
            return null;
        }
        ParameterizedType mfType = (ParameterizedType)t;
        Type[] args = mfType.getActualTypeArguments();
        if (args.length < 2) {
            throw new IllegalStateException(_loc.get("meta-field-less-param", mf.getDeclaringClass(), mf.getName(), this.toTypeName(t)).getMessage());
        }
        return mfType;
    }

    String toTypeName(Type type) {
        if (type instanceof GenericArrayType) {
            return this.toTypeName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        if (!(type instanceof ParameterizedType)) {
            Class cls = (Class)type;
            return cls.getName();
        }
        ParameterizedType pType = (ParameterizedType)type;
        Type[] args = pType.getActualTypeArguments();
        StringBuilder tmp = new StringBuilder(pType.getRawType().toString());
        for (int i = 0; i < args.length; ++i) {
            tmp.append(i == 0 ? (char)'<' : ',');
            tmp.append(this.toTypeName(args[i]));
            if (i != args.length - 1) continue;
            tmp.append('>');
        }
        return tmp.toString();
    }

    void validate(Field metaField, FieldMetaData fmd) {
    }

    <X, Y> void validate(Field mField, Members.Member<X, Y> member) {
        if (!ParameterizedType.class.isInstance(mField.getGenericType())) {
            throw new IllegalArgumentException(_loc.get("meta-bad-field", mField).getMessage());
        }
        ParameterizedType mfType = (ParameterizedType)mField.getGenericType();
        Type[] args = mfType.getActualTypeArguments();
        Type owner = args[0];
        if (member.getDeclaringType().getJavaType() != owner) {
            throw new IllegalArgumentException(_loc.get("meta-bad-field-owner", mField, owner).getMessage());
        }
    }

    @Override
    public Class classForName(String name, String[] imports) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AggregateListener getAggregateListener(String tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OpenJPAConfiguration getConfiguration() {
        return this.repos.getConfiguration();
    }

    @Override
    public FilterListener getFilterListener(String tag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryContext getQueryContext() {
        throw new UnsupportedOperationException();
    }
}

